package dressing.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public abstract class ObservableEntity {

	transient protected PropertyChangeSupport propertyChangeSupport;
	
	public ObservableEntity() {
		this.propertyChangeSupport = new PropertyChangeSupport(this);
	}
	
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		this.propertyChangeSupport.addPropertyChangeListener(listener);
	}
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		this.propertyChangeSupport.removePropertyChangeListener(listener);
	}
	
	public void removeAllListeners() {
		
		for(PropertyChangeListener listener: this.propertyChangeSupport.getPropertyChangeListeners()) {
			this.propertyChangeSupport.removePropertyChangeListener(listener);
		}
	}
	
	public void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
		this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);

	}
	
	public void propagatePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
		
	}

	public PropertyChangeSupport getPropertyChangeSupport() {
		return propertyChangeSupport;
	}

	public void setPropertyChangeSupport(PropertyChangeSupport propertyChangeSupport) {
		this.propertyChangeSupport = propertyChangeSupport;
	}
}
