package org.frs.structures.node;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Consumer;

public class NodeIterator<T> implements Iterator<Node<T>>{
	
	
	public ArrayList<Node> flatList = new ArrayList<Node>();
	int currentIndex;
	
	public NodeIterator(Node node) {
		traverse(node);
	}

	private void traverse(Node node) {
		flatList.add(node);
		node.getChildren().forEach(item ->traverse((Node) item));
	}

	@Override
	public boolean hasNext() {
		return currentIndex < flatList.size();
	}

	@Override
	public Node next() {
		return flatList.get(currentIndex++);
	}

}
