package dressing.ui.project;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import dressing.config.WorkspaceConfiguration;
import dressing.model.ProjectManager;
import dressing.model.SuperCadProject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Table;
import org.eclipse.jface.viewers.TableViewer;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import javax.inject.Inject;

import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.jface.viewers.TableViewerColumn;

public class RestoreProjectComposite extends Composite{
	private Table table;
	private SuperCadProject project;
	@Inject
	private IEventBroker eventBroker;
	TableViewer tableViewer;
	String[] columns= {"Nom","Date"}; 
	
	TableViewerColumn tblViewerClmnName;
	TableViewerColumn tblViewerClmnDate;
	int[] sortDirections= {SWT.DOWN,SWT.UP};
	int sortdirection= SWT.DOWN;
	int index=0;
	Object sorterSelection=null;
	private TableViewerColumn tblViewerClmnTaille;
	public RestoreProjectComposite(Composite parent, SuperCadProject project, int style) {
		super(parent, style);
		this.project = project;
		setLayout(new GridLayout(1, false));
		Composite composite_1 = new Composite(this, SWT.NONE);
		composite_1.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		composite_1.setLayout(new GridLayout(1, false));

		tableViewer = new TableViewer(composite_1, SWT.BORDER | SWT.FULL_SELECTION | SWT.V_SCROLL);
		table = tableViewer.getTable();
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		table.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		tblViewerClmnName = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNomProjet = tblViewerClmnName.getColumn();
		tblclmnNomProjet.setMoveable(true);
		tblclmnNomProjet.setWidth(71);
		tblclmnNomProjet.setText("Nom projet");

		tblViewerClmnName.setLabelProvider(new ColumnLabelProvider() {
			@Override
			public String getText(Object element) {
				if (element instanceof File) {
					String name = ((File) element).getName();
					return name.substring(0, name.lastIndexOf('_'));
				}
				return "undefined";
			}
		});
		tblViewerClmnTaille = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnTaille = tblViewerClmnTaille.getColumn();
		tblclmnTaille.setMoveable(true);
		tblclmnTaille.setWidth(71);
		tblclmnTaille.setText("Taille");

		tblViewerClmnTaille.setLabelProvider(new ColumnLabelProvider() {
			@Override
			public String getText(Object element) {

				if (element instanceof File) {
					String name = String.valueOf(Math.round(((File) element).length() / 1024.0f)) + " Ko";
					return name;
				}
				return "undefined";
			}
		});
		tblViewerClmnDate = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnDateDeCration = tblViewerClmnDate.getColumn();
		tblclmnDateDeCration.setMoveable(true);
		tblclmnDateDeCration.setWidth(71);
		tblclmnDateDeCration.setText("Modifié le");

		tblViewerClmnDate.setLabelProvider(new ColumnLabelProvider() {

			@Override
			public String getText(Object element) {
				if (element instanceof SuperCadProject)
					return ((SuperCadProject) element).getCreationDate().toString();
				if (element instanceof File) {
					String name = ((File) element).getName();
					return new Date(Long.valueOf(name.substring(name.lastIndexOf('_') + 1, name.lastIndexOf(".cad"))))
							.toLocaleString();
				}
				return "undefined";
			}

		});

		ControlAdapter cal = new ControlAdapter() {

			public void controlResized(ControlEvent e) {

				Rectangle area = composite_1.getClientArea();
				Point preferredSize = table.computeSize(SWT.DEFAULT, SWT.DEFAULT);
				int width = area.width;
				if (preferredSize.y > area.height + table.getHeaderHeight()) {
					// Subtract the scrollbar width from the total column width
					// if a vertical scrollbar will be required
					Point vBarSize = table.getVerticalBar().getSize();
					width -= vBarSize.x;
					width-=table.getBorderWidth()*2;
					width-=composite_1.getBorderWidth()*2;
					width-=parent.getBorderWidth()*2;
				}
				Point oldSize = table.getSize();
				if (oldSize.x > area.width) {
					// table is getting smaller so make the columns
					// smaller first and then resize the table to
					// match the client area width
					int columnWidth = (width) / 3;
					tblclmnNomProjet.setWidth(columnWidth);
					tblclmnTaille.setWidth(columnWidth);
					tblclmnDateDeCration.setWidth(columnWidth);
					table.setSize(area.width, area.height);
				} else {
					// table is getting bigger so make the table
					// bigger first and then make the columns wider
					// to match the client area width
					int columnWidth = (width) / 3;
					table.setSize(area.width, area.height);
					tblclmnNomProjet.setWidth(columnWidth);
					tblclmnTaille.setWidth(columnWidth);
					tblclmnDateDeCration.setWidth(columnWidth);
				}
			}
		};
		tableViewer.setContentProvider(ArrayContentProvider.getInstance());
		ArrayList<SuperCadProject> projects = (ArrayList<SuperCadProject>) ProjectManager.getManager().getProjects();
		if (this.project != null) {
			String name = this.project.getName();
			String backupFolder = WorkspaceConfiguration.getProjectsBackupFolder() + File.separator + name;
			File folder = new File(backupFolder);
			if (folder != null && folder.exists() && folder.isDirectory()) {
				tableViewer.setInput(folder.listFiles());
			}
		}
		composite_1.addControlListener(cal);
		table.addControlListener(cal);
		this.addControlListener(cal);
		parent.addControlListener(cal);
	}
	
	public SuperCadProject getProject() {
		return project;
	}
	public void setProject(SuperCadProject project) {
		this.project = project;
	}

	public TableViewer getTableViewer() {
		return tableViewer;
	}

	
}
