package dressing.ui.etagere;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;

import dressing.controller.EtagereCreator;
import dressing.controller.Piece2DCreator;
import dressing.model.DesignException;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.PieceType;

public class EtagereWizardWelcomePage extends WizardPage {
	PropertyChangeListener pcl;
	boolean errorfound = false;
	EtagereCreator etgCreator = new EtagereCreator();
	EtagereWizardSecondPage etgSecondPage;

	public EtagereCreator getEtgCreator() {
		return etgCreator;
	}

	public void setEtgCreator(EtagereCreator etgCreator) {
		this.etgCreator = etgCreator;
	}

	public EtagereWizardWelcomePage(String pageName, EtagereCreator etgCreator) {
		super(pageName);
		setTitle("Etagere information");
		setDescription("S'il vous plais entrer les informataion de vous étagere");
		setPageComplete(false);
		setEtgCreator(etgCreator);
	}

	@Override
	public void createControl(Composite parent) {
		EtagereCompositeWelcomePage composite = new EtagereCompositeWelcomePage(parent, SWT.BORDER, etgCreator);
		setControl(composite);
		pcl = new PropertyChangeListener() {

			@Override
			public void propertyChange(PropertyChangeEvent evt) {
				// TODO Auto-generated method stub
				if (!evt.getPropertyName().startsWith("project.")) // seulemnt les proprietes de javabean
				{
					try {
					
							etgCreator.create();
						

						setErrorMessage(null);
						errorfound = false;
						setMessage("Vous pouvez ajouter votre Etagère", WizardPage.INFORMATION);
					} catch (DesignException | GeometricEngineException e) {
						setErrorMessage(e.getMessage());

						errorfound = true;
					}
					getWizard().getContainer().updateButtons();
				}

			}
		};
	
		etgCreator.addPropertyChangeListener(pcl);

	}

	@Override
	public boolean canFlipToNextPage() {
		if (!etgCreator.getTableDesDistance() || errorfound) {
			return false;
		}
		return true;
	}

	@Override
	public boolean isPageComplete() {
		// TODO Auto-generated method stub
		boolean b = !errorfound;
		return b;
	}

	public void clearlistners() {
		etgCreator.removePropertyChangeListener(pcl);
	}

}
