package gdxapp.screens.wall;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.GL20;

import dressing.mathutils.Surface;
import dressing.model.ProjectManager;
import gdxapp.Commun.AbstractScreen;
import gdxapp.Commun.GroupSelection;
import gdxapp.Commun.ScreenController;
import gdxapp.object3d.Wall;
import gdxapp.scenes.Scene;
import gdxapp.scenes.SceneEvent;
import gdxapp.screens.room.RoomController;

public class SurfaceScreen extends AbstractScreen {

	SurfaceController controller;

	public SurfaceScreen(Surface surface) {
		super();
		ProjectManager.instance.getCurrentScene().getSurfaceScreens().add(this);
		controller = new SurfaceController(surface);
	}

	@Override
	public void show() {
		Gdx.input.setInputProcessor(controller.getInputMultiplexer());
		GroupSelection.getInstance().clearSelection();
		controller.reloadActors();
		controller.getChangeCommandController().clear();
		controller.subscribe(SceneEvent.OBJECT_DROP.name());
	}

	@Override
	public void render(float delta) {
		try {
			Gdx.gl20.glClearColor(1f, 1f, 1f, 1);
			Gdx.gl.glClear(GL20.GL_COLOR_BUFFER_BIT | GL20.GL_DEPTH_BUFFER_BIT
					| (Gdx.graphics.getBufferFormat().coverageSampling ? GL20.GL_COVERAGE_BUFFER_BIT_NV : 0));
			controller.getStage().act();
			Gdx.gl.glActiveTexture(GL20.GL_TEXTURE0);// This is required by the SpriteBatch!!
			controller.getStage().draw();
			controller.drawPipes();
		}catch (Exception e) {
			e.printStackTrace();
			if(controller.getStage().getBatch().isDrawing())
				controller.getStage().getBatch().end();
			controller.init();
			controller.reloadActors();
		}
	}

	@Override
	public void resize(int width, int height) {
		controller.getStage().getViewport().update(width, height, true);
		controller.resize();
	}

	@Override
	public void pause() {
		// TODO Auto-generated method stub

	}

	@Override
	public void resume() {
		// TODO Auto-generated method stub

	}

	@Override
	public void hide() {
		this.controller.setActorsRealWorldPosition();
		controller.getAttachedActors().clear();
		controller.getChangeCommandController().clear();
		controller.unsubscribe(SceneEvent.OBJECT_DROP.name());
	}

	@Override
	public void dispose() {
		controller.dispose();
	}

	@Override
	public ScreenController getController() {
		return controller;
	}

}
