package dressing.ui.tiroire;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import dressing.model.Cuisine;
import dressing.model.DesignException;
import dressing.model.Dressing;
import dressing.model.IUpdateStructure;
import dressing.model.ModelProvider;
import dressing.model.Tirroir;
import dressing.model.evalutor.GeometricEngineException;
import dressing.ui.util.SingleImageItemLabelProvider;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;

public class TiroireCompositeEditor extends Composite implements IUpdateStructure{

	private DataBindingContext m_bindingContext;
	private Tirroir tiroire = null;
	private ModelProvider modelprovider = new ModelProvider();
	private Label lblNewLabel;
	private Label lbltiroire;
	private Spinner spinner_longeur;
	private Spinner spinner_hauteur;
	private Spinner spinner_profondeur;
	private Text text_nom;
	private MDirtyable dirty;
	private int updatestragey = UpdateValueStrategy.POLICY_UPDATE;
	private Button btnCheckfreelongeur;
	private Button btnCheckfreehauteur;
	private Button btnCheckfreeprofondeur;
	private Label lblMatrieauprincipale;
	private Label lblMatrieauxDeDos;
	private Combo combobasematerial;
	private ComboViewer comboViewer;
	private Combo combodosmaterial;
	private ComboViewer comboViewer_1;
	private Button btnLibrebasematrial;
	private Button btnLibrebackmaterial;
	private TableComboViewer tableComboViewermatprincipale;
	private TableComboViewer tableComboViewer_matdos;
	private Label lblMatrieauxfacde;
	private TableCombo tableCombo;
	private TableComboViewer tableComboViewermatfacade;

	public TiroireCompositeEditor(Composite parent, int style, Tirroir tiroire,int updatestrategy) {
		this(parent, style);
		this.updatestragey = updatestrategy;
		this.setTiroire(tiroire);
		if (this.tiroire != null) {
			m_bindingContext = initDataBindings();
		}
	}

	public TiroireCompositeEditor(Composite parent, int style) {
		super(parent, style);
		setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND));
		GridLayout gridLayout = new GridLayout(3, false);
		setLayout(gridLayout);
		
		lbltiroire = new Label(this, SWT.NONE);
		lbltiroire.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND));
		lbltiroire.setForeground(SWTResourceManager.getColor(SWT.COLOR_DARK_GREEN));
		lbltiroire.setFont(SWTResourceManager.getFont("Segoe UI", 16, SWT.BOLD));
		lbltiroire.setText("Tiroire");
		new Label(this, SWT.NONE);
		new Label(this, SWT.NONE);

		Label label_8 = new Label(this, SWT.NONE);
		label_8.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		label_8.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND));
		label_8.setText("Nom");
		
		text_nom = new Text(this, SWT.BORDER);
		text_nom.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		lblNewLabel = new Label(this, SWT.NONE);
		lblNewLabel.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND));
		lblNewLabel.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1));
		lblNewLabel.setText("   ");

		Label label_9 = new Label(this, SWT.NONE);
		label_9.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		label_9.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND));
		label_9.setText("Longeur (mm)");
		
		spinner_longeur = new Spinner(this, SWT.BORDER);
		spinner_longeur.setEnabled(false);
		spinner_longeur.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		spinner_longeur.setMaximum(100000);
		spinner_longeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		
		btnCheckfreelongeur = new Button(this, SWT.CHECK);
		btnCheckfreelongeur.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
			}
		});
		btnCheckfreelongeur.setText("Libre");

		Label label_7 = new Label(this, SWT.NONE);
		label_7.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		label_7.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND));
		label_7.setText("Hauteur (mm)");
		
		spinner_hauteur = new Spinner(this, SWT.BORDER);
		spinner_hauteur.setEnabled(false);
		spinner_hauteur.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		spinner_hauteur.setMaximum(100000);
		spinner_hauteur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		
		btnCheckfreehauteur = new Button(this, SWT.CHECK);
		btnCheckfreehauteur.setText("Libre");

		Label label_6 = new Label(this, SWT.NONE);
		label_6.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		label_6.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND));
		label_6.setText("Profondeur (mm)");
		
		spinner_profondeur = new Spinner(this, SWT.BORDER);
		spinner_profondeur.setEnabled(false);
		spinner_profondeur.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		spinner_profondeur.setMaximum(100000);
		spinner_profondeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		
		btnCheckfreeprofondeur = new Button(this, SWT.CHECK);
		btnCheckfreeprofondeur.setText("Libre");
		
		lblMatrieauprincipale = new Label(this, SWT.NONE);
		lblMatrieauprincipale.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblMatrieauprincipale.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND));
		lblMatrieauprincipale.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		lblMatrieauprincipale.setText("Matérieaux principale");
		
//		comboViewer = new ComboViewer(this, SWT.NONE);
//		combobasematerial = comboViewer.getCombo();
//		combobasematerial.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableComboViewermatprincipale = new TableComboViewer(this, SWT.READ_ONLY | SWT.BORDER);
		tableComboViewermatprincipale.getTableCombo().setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableComboViewermatprincipale.getTableCombo().setShowTableHeader(true);
		tableComboViewermatprincipale.getTableCombo().defineColumns(new String[] { "Texture","Epaisseur" });
		tableComboViewermatprincipale.getTableCombo().getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		// do not allow editable
		tableComboViewermatprincipale.getTableCombo().setEditable(false);
		// set the content provider
		tableComboViewermatprincipale.setContentProvider(ArrayContentProvider.getInstance());

		// set the label provider
		tableComboViewermatprincipale.setLabelProvider(new SingleImageItemLabelProvider(this));

		// load the data
		tableComboViewermatprincipale.setInput(modelprovider.getMateriallist());
		
		//
		btnLibrebasematrial = new Button(this, SWT.CHECK);
		btnLibrebasematrial.setText("Libre");
		
		lblMatrieauxfacde = new Label(this, SWT.NONE);
		lblMatrieauxfacde.setText("Matérieaux facade");
		lblMatrieauxfacde.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		lblMatrieauxfacde.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND));
		
		tableComboViewermatfacade = new TableComboViewer(this, SWT.READ_ONLY | SWT.BORDER);
		tableComboViewermatfacade.getTableCombo().setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableComboViewermatfacade.getTableCombo().setShowTableHeader(true);
		tableComboViewermatfacade.getTableCombo().defineColumns(new String[] { "Texture","Epaisseur" });
		tableComboViewermatfacade.getTableCombo().getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		// do not allow editable
		tableComboViewermatfacade.getTableCombo().setEditable(false);
		// set the content provider
		tableComboViewermatfacade.setContentProvider(ArrayContentProvider.getInstance());

		// set the label provider
		tableComboViewermatfacade.setLabelProvider(new SingleImageItemLabelProvider(this));

		// load the data
		tableComboViewermatfacade.setInput(modelprovider.getMateriallist());
		new Label(this, SWT.NONE);
		
		lblMatrieauxDeDos = new Label(this, SWT.NONE);
		lblMatrieauxDeDos.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND));
		lblMatrieauxDeDos.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		lblMatrieauxDeDos.setText("Matérieaux de dos");
//		
//		comboViewer_1 = new ComboViewer(this, SWT.NONE);
//		combodosmaterial = comboViewer_1.getCombo();
//		combodosmaterial.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableComboViewer_matdos = new TableComboViewer(this, SWT.READ_ONLY | SWT.BORDER);
		tableComboViewer_matdos.getTableCombo().setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableComboViewer_matdos.getTableCombo().setShowTableHeader(true);
		tableComboViewer_matdos.getTableCombo().defineColumns(new String[] { "Texture", "Epaisseur" });

		tableComboViewer_matdos.getTableCombo().setDisplayColumnIndex(0);
		tableComboViewer_matdos.getTableCombo().getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		// do not allow editable
		tableComboViewer_matdos.getTableCombo().setEditable(false);
		// set the content provider
		tableComboViewer_matdos.setContentProvider(ArrayContentProvider.getInstance());
		
		// set the label provider
		tableComboViewer_matdos.setLabelProvider(new SingleImageItemLabelProvider(this));

		// load the data
		tableComboViewer_matdos.setInput(modelprovider.getMateriallist());	
		
		btnLibrebackmaterial = new Button(this, SWT.CHECK);
		btnLibrebackmaterial.setText("Libre");

		if (tiroire != null) {
			m_bindingContext = initDataBindings();
		}

		//Ajouter le controle de dirty
		makedirtycontroller();		

	}

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}

	public Tirroir getTiroire() {
		return tiroire;
	}

	public void setTiroire(Tirroir tiroire) {
		setTiroire(tiroire, true);
	}

	public void setTiroire(Tirroir tiroire, boolean update) {
		this.tiroire = tiroire;
		if (update) {
			if (m_bindingContext != null) {
				m_bindingContext.dispose();
				m_bindingContext = null;
			}
			if (this.tiroire != null) {
				m_bindingContext = initDataBindings();
			}
		}
	}

	@Override
	public void run() throws DesignException {
		// TODO Auto-generated method stub
			m_bindingContext.updateModels();
			try {
			
				tiroire.propagateUpdateToChildrens(null);
				if(tiroire!=null && tiroire.getParentdesign()!=null
					&& tiroire.getParentdesign() instanceof Dressing
					&& !(tiroire.getParentdesign() instanceof Cuisine)) {
					try {
						((Dressing)tiroire.getParentdesign()).update();
						tiroire.setErrormsg("");
						tiroire.setErrorexist(false);
					} catch (Exception e) {
						e.printStackTrace();
						tiroire.setErrormsg(e.getMessage());
						tiroire.setErrorexist(true);
					}
				}
				tiroire.setErrormsg("");
				tiroire.setErrorexist(false);
			} catch (GeometricEngineException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				tiroire.setErrormsg(e.getMessage());
				tiroire.setErrorexist(true);
			}

	}

	@Override
	public void cancel() {
		// TODO Auto-generated method stub
		m_bindingContext.updateTargets();
	}
	public void setDirty(MDirtyable dirty) {
		this.dirty = dirty;
	}
	public MDirtyable getDirty() {
		return dirty;
	}
	public void updateDirty()
	{
		if(this.dirty!=null)
		{
			this.dirty.setDirty(true);
		}
	}
	//Pour corriger le Bug de spinner que selctionne tous apres chaque saisie
	private void updateCaretposition(Control ctr)
	{
		Event ke = new Event();
        ke.type = SWT.MENU_KEYBOARD;
        ke.keyCode = SWT.ARROW_RIGHT;
        ctr.getDisplay().post(ke);
	}
	protected void makedirtycontroller()
	{
		//Faire la mise ajour des controel pour qui enregistre le dirty
				Control [] ctrl = this.getChildren();
				for(Control ctr : this.getChildren())
				{
					if(ctr instanceof Text)
					{
						((Text) ctr).addKeyListener(new KeyListener() {
							
							@Override
							public void keyReleased(KeyEvent e) {
								// TODO Auto-generated method stub
								updateDirty();
							}
							
							@Override
							public void keyPressed(KeyEvent e) {
								// TODO Auto-generated method stub
								
							}
						});
					}
					else
					{
						ctr.addListener(SWT.Selection, event->updateDirty());//Pour les spinner et les chekbox labada expresseion
					}
					if(ctr instanceof Spinner)
					{
						ctr.addListener(SWT.Selection, event->updateCaretposition(ctr));
					}
				}
	}

	protected void makeerrorhandler(Control control)
	{
		ControlDecoration deco;
		deco = new ControlDecoration(control, SWT.TOP | SWT.RIGHT);
		// re-use an existing image
		Image image = FieldDecorationRegistry.getDefault().getFieldDecoration(FieldDecorationRegistry.DEC_ERROR)
				.getImage();
		// set description and image
		deco.setImage(image);
		// hide deco if not in focus
		deco.setShowOnlyOnFocus(false);
		deco.hide();
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeTextText_nomObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(text_nom);
		IObservableValue nameTiroireObserveValue = BeanProperties.value("name").observe(tiroire);
		bindingContext.bindValue(observeTextText_nomObserveWidget, nameTiroireObserveValue, null, null);
		//
		IObservableValue observeSelectionSpinner_longeurObserveWidget = WidgetProperties.widgetSelection().observe(spinner_longeur);
		IObservableValue longeurextTiroireObserveValue = BeanProperties.value("longeurext").observe(tiroire);
		bindingContext.bindValue(observeSelectionSpinner_longeurObserveWidget, longeurextTiroireObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnCheckfreelongeurObserveWidget = WidgetProperties.widgetSelection().observe(btnCheckfreelongeur);
		IObservableValue longeurextfreeTiroireObserveValue = BeanProperties.value("longeurextfree").observe(tiroire);
		bindingContext.bindValue(observeSelectionBtnCheckfreelongeurObserveWidget, longeurextfreeTiroireObserveValue, null, null);
		//
		IObservableValue observeSelectionSpinner_hauteurObserveWidget = WidgetProperties.widgetSelection().observe(spinner_hauteur);
		IObservableValue hauteurextTiroireObserveValue = BeanProperties.value("hauteurext").observe(tiroire);
		bindingContext.bindValue(observeSelectionSpinner_hauteurObserveWidget, hauteurextTiroireObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnCheckfreehauteurObserveWidget = WidgetProperties.widgetSelection().observe(btnCheckfreehauteur);
		IObservableValue hauteurextfreeTiroireObserveValue = BeanProperties.value("hauteurextfree").observe(tiroire);
		bindingContext.bindValue(observeSelectionBtnCheckfreehauteurObserveWidget, hauteurextfreeTiroireObserveValue, null, null);
		//
		IObservableValue observeSelectionSpinner_profondeurObserveWidget = WidgetProperties.widgetSelection().observe(spinner_profondeur);
		IObservableValue profondeurextTiroireObserveValue = BeanProperties.value("profondeurext").observe(tiroire);
		bindingContext.bindValue(observeSelectionSpinner_profondeurObserveWidget, profondeurextTiroireObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnCheckfreeprofondeurObserveWidget = WidgetProperties.widgetSelection().observe(btnCheckfreeprofondeur);
		IObservableValue profondeurextfreeTiroireObserveValue = BeanProperties.value("profondeurextfree").observe(tiroire);
		bindingContext.bindValue(observeSelectionBtnCheckfreeprofondeurObserveWidget, profondeurextfreeTiroireObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionTableComboViewermatprincipale = ViewerProperties.singleSelection().observe(tableComboViewermatprincipale);
		IObservableValue basematerialTiroireObserveValue = BeanProperties.value("basematerial").observe(tiroire);
		bindingContext.bindValue(observeSingleSelectionTableComboViewermatprincipale, basematerialTiroireObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnLibrebasematrialObserveWidget = WidgetProperties.widgetSelection().observe(btnLibrebasematrial);
		IObservableValue basematerialfreeTiroireObserveValue = BeanProperties.value("basematerialfree").observe(tiroire);
		bindingContext.bindValue(observeSelectionBtnLibrebasematrialObserveWidget, basematerialfreeTiroireObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionTableComboViewer_matdos = ViewerProperties.singleSelection().observe(tableComboViewer_matdos);
		IObservableValue backmaterialTiroireObserveValue = BeanProperties.value("backmaterial").observe(tiroire);
		bindingContext.bindValue(observeSingleSelectionTableComboViewer_matdos, backmaterialTiroireObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnLibrebackmaterialObserveWidget = WidgetProperties.widgetSelection().observe(btnLibrebackmaterial);
		IObservableValue backmaterialfreeTiroireObserveValue = BeanProperties.value("backmaterialfree").observe(tiroire);
		bindingContext.bindValue(observeSelectionBtnLibrebackmaterialObserveWidget, backmaterialfreeTiroireObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionTableComboViewermatfacade_1 = ViewerProperties.singleSelection().observe(tableComboViewermatfacade);
		IObservableValue facadeMaterialTiroireObserveValue = BeanProperties.value("facadeMaterial").observe(tiroire);
		bindingContext.bindValue(observeSingleSelectionTableComboViewermatfacade_1, facadeMaterialTiroireObserveValue, null, null);
		//
		return bindingContext;
	}
}
