package dressing.ui.parts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.RoundingMode;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Locale;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;

import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.services.IServiceConstants;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider.IStyledLabelProvider;
import org.eclipse.jface.viewers.StyledString.Styler;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

import dressing.config.model.ModelpackageProvider;
import dressing.model.Caisson;
import dressing.model.CaissonCuisine;
import dressing.model.Cuisine;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Dressing;
import dressing.model.Etagere;
import dressing.model.ModelPackageProject3D;
import dressing.model.ModelPackageProjectParent;
import dressing.model.ModelProvider;
import dressing.model.Piece2D;
import dressing.model.Piece2DCoupe;
import dressing.model.Project3D;
import dressing.model.ProjectParent;
import dressing.model.Separator;
import dressing.model.Space3D;
import dressing.model.Tirroir;
import dressing.model.types.PieceType;
import dressing.model.types.Zone3DType;
import dressing.model.usinage.Usinage;
import dressing.ui.ModelPackageTreeContentProvider;
import dressing.ui.ProjectTreeContentProvider;
import dressing.ui.modelprovders.DimHLabelProvider;
import dressing.ui.modelprovders.DimLLabelProvider;
import dressing.ui.modelprovders.MaterialLabelProvider;
import dressing.ui.modelprovders.NameLabelProvider;
import dressing.ui.palette.PaletteItem;
import dressing.ui.palette.PaletteItemTransferType;
import dressing.ui.util.ListenerSelection;

/**
 * créer un part pour le bibliothèque des modèle
 * @Bug 0001846
 * @author Imed
 *
 */
public class ModelPackageTreePart {
	@Inject 
	IEclipseContext eclipsecontext;
	@Inject
	private ESelectionService selectionService;

	@Inject 
	EPartService partService;
	
	@Inject
	private EHandlerService handlerService;
	
	@Inject
	private ECommandService commandService;
	@Inject
	private MDirtyable dirty;
	static  Display display;
	ListenerSelection listenerSelection;
	public ModelPackageTreePart() {

	}
	
	/**
	 * Create contents of the view part.
	 */
	@PostConstruct
	public void createControls(Composite parent) {
		
		display = parent.getDisplay();
		final TreeViewer treeViewer = new TreeViewer(parent, SWT.BORDER|SWT.MULTI);
		final Tree tree = treeViewer.getTree();		
		
		ModelPackageProjectParent parentproject = ModelpackageProvider.RootInstance();
//		ModelpackageProvider.loadLibrary();
		treeViewer.setContentProvider(new ModelPackageTreeContentProvider());
		treeViewer.setInput(parentproject);
		treeViewer.addSelectionChangedListener(new ISelectionChangedListener() {
		    public void selectionChanged(SelectionChangedEvent event) {
		      IStructuredSelection selection = (IStructuredSelection) event.getSelection();
		      // set the selection to the service
		      Object selectionobj= selection.size() == 1 ? selection.getFirstElement() : selection.toList();
		      selectionService.setSelection(selectionobj);
		    
		    }
		  });
		 listenerSelection=new ListenerSelection(selectionService);
		parentproject.addPropertyChangeListener(new PropertyChangeListener() {
			
			@Override
			public void propertyChange(PropertyChangeEvent evt) {

			      parent.getDisplay().asyncExec(new Runnable() {

				         @Override
				         public void run() {
								Object x = evt.getNewValue();
								treeViewer.refresh(true);
								treeViewer.getAutoExpandLevel();
//								treeViewer.expandToLevel(evt.getNewValue(), TreeViewer.ALL_LEVELS);
								if(!evt.getPropertyName().equals("project.read") && !evt.getPropertyName().equals("project.close")
										&&!evt.getPropertyName().contentEquals("selected"))
								{
									dirty.setDirty(true);
								}								
								
								
								
				      }});
				}
		});		
		
		
		TreeViewerColumn viewerColumn = new TreeViewerColumn(treeViewer, SWT.NONE);
		TreeColumn column = viewerColumn.getColumn();
		column.setText("Nom");
		column.setWidth(200);
		viewerColumn.setLabelProvider(new DelegatingStyledCellLabelProvider(new NameLabelProvider(ModelPackageTreePart.display)));


		viewerColumn = new TreeViewerColumn(treeViewer, SWT.NONE);
	    column = viewerColumn.getColumn();
		column.setText("Materieaux");
		column.setWidth(100);
		viewerColumn.setLabelProvider(new DelegatingStyledCellLabelProvider(new MaterialLabelProvider()));
		
		
		viewerColumn = new TreeViewerColumn(treeViewer, SWT.NONE);
	    column = viewerColumn.getColumn();
		column.setText("Longeur");
		column.setWidth(100);
		viewerColumn.setLabelProvider(new DelegatingStyledCellLabelProvider(new DimLLabelProvider()));
		
		viewerColumn = new TreeViewerColumn(treeViewer, SWT.NONE);
	    column = viewerColumn.getColumn();
		column.setText("Largeur");
		column.setWidth(100);
		viewerColumn.setLabelProvider(new DelegatingStyledCellLabelProvider(new DimHLabelProvider()));
		
	
		
		
		

		Listener listener = new Listener() {

		   @Override
		   public void handleEvent(Event event) {
		      TreeItem treeItem = (TreeItem) event.item;
		      
		      final TreeColumn[] treeColumns = treeItem.getParent().getColumns();
		      parent.getDisplay().asyncExec(new Runnable() {
 
		         @Override
		         public void run() {
		            for (TreeColumn treeColumn : treeColumns)
		                 treeColumn.pack();
		         }
		        
		      });
		   }
		};
		tree.addListener(SWT.Expand, listener);
		tree.addSelectionListener(new SelectionListener() {
			
			@Override
			public void widgetSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				
			}
		});
		
		
		MenuManager menuMgr = new MenuManager();

        Menu menu = menuMgr.createContextMenu(treeViewer.getControl());
        menuMgr.addMenuListener(new IMenuListener() {
            @Override
            public void menuAboutToShow(IMenuManager manager) {
                // IWorkbench wb = PlatformUI.getWorkbench();
                // IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
                if (treeViewer.getSelection().isEmpty()) {
                    return;
                }

                if (treeViewer.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection) treeViewer.getSelection();
                    Object object = selection.getFirstElement();
                    manager.add(new Action("Costomiser les Parameters") {
                    	public void run() {
                    		ParameterizedCommand cmd = commandService.createCommand("dressing.command.customiseParameters", null);
                    		handlerService.executeHandler(cmd);
                    		};
					});
                    manager.add(new Action("Réinitialiser les Parameters") {
                    	public void run() {
                    		ParameterizedCommand cmd = commandService.createCommand("dressing.command.reinitialiserParameters", null);                        	
                    		handlerService.executeHandler(cmd);
                    	};
					});
                    if(object instanceof ModelPackageProject3D) {
                        manager.add(new Action("Ajouter une cuisine") {
                        	public void run() {
                        		ParameterizedCommand cmd = commandService.createCommand("dressing.command.add.cuisine", null);
                        		handlerService.executeHandler(cmd);
                        	};
						});
                        manager.add(new Action("exporter vers model 3D") {
                        	public void run() {
                        		ParameterizedCommand cmd = commandService.createCommand("dressing.command.exportmodelto3d", null);
                        		handlerService.executeHandler(cmd);
                        		};
    					});
                    }
                    manager.add(new Action("Supprimer") {
                    	public void run() {
                    		ParameterizedCommand cmd = commandService.createCommand("dressing.command.delete", null);
                    		handlerService.executeHandler(cmd);
                    		};
					});
                }
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        treeViewer.getControl().setMenu(menu);    	
       	
       	DropTarget target = new DropTarget(treeViewer.getControl(), DND.DROP_COPY | DND.DROP_DEFAULT);
        target.setTransfer(new Transfer[] { PaletteItemTransferType.getInstance() });
        target.addDropListener(new DropTargetAdapter() {
          public void dragEnter(DropTargetEvent event) {
            if (event.detail == DND.DROP_DEFAULT) {
              event.detail = DND.DROP_COPY;
            }
          }

          public void dragOperationChanged(DropTargetEvent event) {
            if (event.detail == DND.DROP_DEFAULT) {
              event.detail = DND.DROP_COPY;
            }
          }

          public void drop(DropTargetEvent event) {
            if (event.data != null) {
              PaletteItem[] myTypes = (PaletteItem[]) event.data;
              if (myTypes != null) {
                String cmdstr = "";
                for (int i = 0; i < myTypes.length; i++) {
                  cmdstr += myTypes[i].getCmd();
                }                
				if (event.item != null && event.item.getData() instanceof Space3D)
				{
					selectionService.setSelection(event.item.getData());
            		ParameterizedCommand cmd = commandService.createCommand(cmdstr, null);
            		handlerService.executeHandler(cmd);
				}
            
              }
            }
          }

        });
	}

	@PreDestroy
	public void dispose() {
	}

	@Focus
	public void setFocus() {
		// TODO	Set the focus to control
	}
	@Persist
	public void save() throws DesignException {
		dirty.setDirty(false);
	}
	public void setSelection( @Named(IServiceConstants.ACTIVE_SELECTION) Dressing contact) {
		  if (contact == null) {
		    /* implementation not shown */
		  } else {
		    /* implementation not shown */
		  }
		}
}