package dressing.ui.etagere;

import java.util.List;

import javax.inject.Inject;

import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;

import dressing.controller.EtagereCreator;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Space3D;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.EtagereType;
import dressing.model.types.PieceType;
import dressing.model.types.EtagereReferenceType;

public class EtagereWizard extends Wizard {
	@Inject
	IEclipseContext eclipsecontext;

	@Inject
	private EHandlerService handlerService;

	@Inject
	private ECommandService commandService;
	Space3D space3d;
	EtagereWizardWelcomePage welcomePage;
	EtagereWizardSecondPage secondPage;
	EtagereCreator etgCreator = new EtagereCreator();

	public Space3D getSpace3d() {
		return space3d;
	}

	public void setSpace3d(Space3D space3d) {
		this.space3d = space3d;
		etgCreator.setParent((DesignObject3D) space3d);
	}

	public EtagereCreator getEtgCreator() {
		return etgCreator;
	}

	public void setEtgCreator(EtagereCreator etgCreator) {
		this.etgCreator = etgCreator;
	}

	public EtagereWizard() {
		super();
		setWindowTitle("Ajouter des étagère");
	}

	@Override
	public void addPages() {
		welcomePage = new EtagereWizardWelcomePage("Welcome Page", etgCreator);
		addPage(welcomePage);
		secondPage = new EtagereWizardSecondPage("page de table des distance", etgCreator);
		addPage(secondPage);
		
	}

	@Override
	public boolean performFinish() {
		for (IWizardPage page : getPages()) {
			((WizardPage) page).setErrorMessage("");
		}
		etgCreator.setParent((DesignObject3D) space3d);
		try {
			
			if((etgCreator.getListDistance().size()!=etgCreator.getEtagerecount())&&etgCreator.getTableDesDistance()) {
				
				throw new DesignException("le nombre des etagere doit egale le nombre des distance donnée");
				
			}
			this.etgCreator.create();
			welcomePage.clearlistners();
			secondPage.clearlistners();			
			List<DesignObject3D> etglist = etgCreator.getEtagereList();
			for (DesignObject3D etg : etglist) {
				space3d.addElement(etg);
			}
		} catch (DesignException | GeometricEngineException e) {
			for (IWizardPage page : getPages()) {
				((WizardPage) page).setErrorMessage(e.getMessage());
			}
			return false;
		}
		return true;

	}

	@Override
	public boolean canFinish() {
		if (!welcomePage.isPageComplete()&&!(secondPage.isPageComplete()&&etgCreator.getTableDesDistance()))
			return false;
		
		return true;
	}

}
