package dressing.ui.dressing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import dressing.controller.DressingCreator;
import dressing.controller.Piece2DCreator;
import dressing.model.DesignException;
import dressing.model.Dressing;
import dressing.model.Separator;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.PositionCalculationType;
import dressing.model.types.SeprationAxe;

public class DressingSecondPage extends WizardPage{

	DressingCreator dress ;
	PropertyChangeListener pcl;
	PropertyChangeListener pcl2;
	boolean errorfound=true;
	protected DressingSecondPage(String pageName,DressingCreator dress) {
		super(pageName);
		this.dress = dress;
		setTitle("Créer un nouveau dressing");
		setDescription("Veuillez renseigner les propriétés de votre dressing");				
		// TODO Auto-generated constructor stub
	}


	@Override
	public void createControl(Composite parent) {
		// TODO Auto-generated method stub
		DressingCompositeWizard2 compo1 = new DressingCompositeWizard2(parent, SWT.NONE,dress,UpdateValueStrategy.POLICY_UPDATE);
		setControl(compo1);
		pcl = new PropertyChangeListener() {
			
			@Override
			public void propertyChange(PropertyChangeEvent evt) {
				// TODO Auto-generated method stub
				if(!evt.getPropertyName().startsWith("project.")) //seulemnt les proprietes de javabean
				{
					try {						
						dress.create();
						setErrorMessage(null);	
						errorfound = false;
						setMessage("Vous pouvez ajouter votre dressing est specifier les caisson après", WizardPage.INFORMATION);
					} catch (DesignException  | GeometricEngineException e) {
						setErrorMessage(e.getMessage());	
						errorfound = true;
					}
					getWizard().getContainer().updateButtons();
				}

			}
		};
		//ajouter un propertychangelistener pour override le seppostion lorsque choisire separator isometrique
				pcl2 =new PropertyChangeListener() {
					
					@Override
					public void propertyChange(PropertyChangeEvent evt) {
						// TODO Auto-generated method stub
						if(evt.getPropertyName().equals("separatorisometrique")) {					
								if(evt.getNewValue().equals(true)) {
									dress.setSeparationposition(50);
								}
								//
								if(evt.getOldValue().equals(false)&& evt.getNewValue().equals(true)) {
									dress.setPositionCalculationtype(PositionCalculationType.POURCENT);
								}
								if(evt.getOldValue().equals(true)&& evt.getNewValue().equals(false)) {
									dress.setPositionCalculationtype(PositionCalculationType.FIX);
								}
							}
						
						}
				};
		dress.addPropertyChangeListener(pcl);
		dress.addPropertyChangeListener(pcl2);
	}
@Override
public boolean isPageComplete() {
	// TODO Auto-generated method stub
	boolean b = !errorfound;
	return b;
}
public void clearlistners() {
	dress.removePropertyChangeListener(pcl);
	dress.removePropertyChangeListener(pcl2);
}
}
