package dressing.ui.cuisine;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;

import dressing.controller.CuisineCreator;
import dressing.model.Cuisine;
import dressing.model.DesignException;
import dressing.model.Project3D;
import dressing.model.evalutor.GeometricEngineException;

public class CuisineWizard extends Wizard {
	CuisineWizardPage cuisinepage;
	Project3D project3d;
	CuisineCreator cuisine=new CuisineCreator();
	public CuisineWizard() {
		setWindowTitle("ajouter votre  cuisine");
	}

	@Override
	public void addPages() {
		 cuisinepage=new CuisineWizardPage("welcome Page", cuisine);
		this.addPage(cuisinepage);
	}

	@Override
	public boolean performFinish() {
		for(IWizardPage page :getPages())
		{
			((WizardPage) page).setErrorMessage("");
		}
			try {
				this.cuisine.create();
				cuisinepage.clearlistners();
			
				this.project3d.addElement(cuisine.getCuisineInstance());		
			} catch (DesignException  | GeometricEngineException e) {
				for(IWizardPage page :getPages())
				{
					((WizardPage) page).setErrorMessage(e.getMessage());
				}
					return false;
			}

					
			return true;
	}
	
public void setProject3d(Project3D project3d) {
	this.project3d = project3d;	
	cuisine.setParent(project3d);
}
	

}
