package dressing.ui.caisson;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import dressing.model.DesignException;
import dressing.model.IUpdateStructure;
import dressing.model.evalutor.GeometricEngineException;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.StyledText;

public class CaissonCompositeWizard extends Composite implements IUpdateStructure{

	private DataBindingContext m_bindingContext;
	private dressing.controller.CaissonCreator caisson = null;
	private Label lblNewLabel;
	private Label lblCaisson;
	private Spinner spinner_longeur;
	private Spinner spinner_hauteur;
	private Spinner spinner_profondeur;
	private Text text_nom;
	private MDirtyable dirty;
	private StyledText styledText;
	private int updatestragey = UpdateValueStrategy.POLICY_UPDATE;
	public CaissonCompositeWizard(Composite parent, int style, dressing.controller.CaissonCreator newCuisson,int updatestrategy) {
		this(parent, style);
		this.updatestragey = updatestrategy;
		this.setCuisson(newCuisson);
		if (caisson != null) {
			m_bindingContext = initDataBindings();
		}
	}

	public CaissonCompositeWizard(Composite parent, int style) {
		super(parent, style);
		setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND));
		GridLayout gridLayout = new GridLayout(3, false);
		setLayout(gridLayout);
		
		lblCaisson = new Label(this, SWT.NONE);
		lblCaisson.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND));
		lblCaisson.setForeground(SWTResourceManager.getColor(SWT.COLOR_DARK_GREEN));
		lblCaisson.setFont(SWTResourceManager.getFont("Segoe UI", 16, SWT.BOLD));
		lblCaisson.setText("Caisson");
		
		styledText = new StyledText(this, SWT.BORDER);
		styledText.setForeground(SWTResourceManager.getColor(SWT.COLOR_RED));
		styledText.setBackground(SWTResourceManager.getColor(SWT.COLOR_YELLOW));
		styledText.setDoubleClickEnabled(false);
		styledText.setEditable(false);
		styledText.setAlwaysShowScrollBars(false);
		styledText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));

		Label label_8 = new Label(this, SWT.NONE);
		label_8.setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		label_8.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND));
		label_8.setText("Nom");
		
		text_nom = new Text(this, SWT.BORDER);
		text_nom.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		lblNewLabel = new Label(this, SWT.NONE);
		lblNewLabel.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND));
		lblNewLabel.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1));
		lblNewLabel.setText("   ");

		Label label_9 = new Label(this, SWT.NONE);
		label_9.setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		label_9.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND));
		label_9.setText("Longeur (mm)");
		
		spinner_longeur = new Spinner(this, SWT.BORDER);
		spinner_longeur.setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		spinner_longeur.setMaximum(100000);
		spinner_longeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		new Label(this, SWT.NONE);

		Label label_7 = new Label(this, SWT.NONE);
		label_7.setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		label_7.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND));
		label_7.setText("Hauteur (mm)");
		
		spinner_hauteur = new Spinner(this, SWT.BORDER);
		spinner_hauteur.setEnabled(false);
		spinner_hauteur.setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		spinner_hauteur.setMaximum(100000);
		spinner_hauteur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		new Label(this, SWT.NONE);

		Label label_6 = new Label(this, SWT.NONE);
		label_6.setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		label_6.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND));
		label_6.setText("Profondeur (mm)");
		
		spinner_profondeur = new Spinner(this, SWT.BORDER);
		spinner_profondeur.setEnabled(false);
		spinner_profondeur.setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		spinner_profondeur.setMaximum(100000);
		spinner_profondeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		new Label(this, SWT.NONE);

		if (caisson != null) {
			m_bindingContext = initDataBindings();
		}

		//Ajouter le controle de dirty
		makedirtycontroller();		

	}

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}

	public dressing.controller.CaissonCreator getCuisson() {
		return caisson;
	}

	public void setCuisson(dressing.controller.CaissonCreator newCuisson) {
		setCuisson(newCuisson, true);
	}

	public void setCuisson(dressing.controller.CaissonCreator newCuisson, boolean update) {
		caisson = newCuisson;
		if (update) {
			if (m_bindingContext != null) {
				m_bindingContext.dispose();
				m_bindingContext = null;
			}
			if (caisson != null) {
				m_bindingContext = initDataBindings();
			}
		}
	}

	@Override
	public void run() throws DesignException {
		// TODO Auto-generated method stub
			m_bindingContext.updateModels();
			try {
				caisson.create();		
				caisson.getCaissonInstance();
			} catch (GeometricEngineException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

	}

	@Override
	public void cancel() {
		// TODO Auto-generated method stub
		m_bindingContext.updateTargets();
	}
	public void setDirty(MDirtyable dirty) {
		this.dirty = dirty;
	}
	public MDirtyable getDirty() {
		return dirty;
	}
	public void updateDirty()
	{
		if(this.dirty!=null)
		{
			this.dirty.setDirty(true);
		}
	}
	//Pour corriger le Bug de spinner que selctionne tous apres chaque saisie
	private void updateCaretposition(Control ctr)
	{
		Event ke = new Event();
        ke.type = SWT.MENU_KEYBOARD;
        ke.keyCode = SWT.ARROW_RIGHT;
        ctr.getDisplay().post(ke);
	}
	protected void makedirtycontroller()
	{
		//Faire la mise ajour des controel pour qui enregistre le dirty
				Control [] ctrl = this.getChildren();
				for(Control ctr : this.getChildren())
				{
					if(ctr instanceof Text)
					{
						((Text) ctr).addKeyListener(new KeyListener() {
							
							@Override
							public void keyReleased(KeyEvent e) {
								// TODO Auto-generated method stub
								updateDirty();
							}
							
							@Override
							public void keyPressed(KeyEvent e) {
								// TODO Auto-generated method stub
								
							}
						});
					}
					else
					{
						ctr.addListener(SWT.Selection, event->updateDirty());//Pour les spinner et les chekbox labada expresseion
					}
					if(ctr instanceof Spinner)
					{
						ctr.addListener(SWT.Selection, event->updateCaretposition(ctr));
					}
				}
	}

	protected void makeerrorhandler(Control control)
	{
		ControlDecoration deco;
		deco = new ControlDecoration(control, SWT.TOP | SWT.RIGHT);
		// re-use an existing image
		Image image = FieldDecorationRegistry.getDefault().getFieldDecoration(FieldDecorationRegistry.DEC_ERROR)
				.getImage();
		// set description and image
		deco.setImage(image);
		// hide deco if not in focus
		deco.setShowOnlyOnFocus(false);
		deco.hide();
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeTextText_nomObserveWidget = WidgetProperties.text(SWT.FocusOut).observe(text_nom);
		IObservableValue nameCuissonObserveValue = BeanProperties.value("name").observe(caisson);
		bindingContext.bindValue(observeTextText_nomObserveWidget, nameCuissonObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), null);
		//
		IObservableValue observeSelectionSpinner_profondeurObserveWidget_1 = WidgetProperties.widgetSelection().observe(spinner_profondeur);
		IObservableValue profondeurCaissonObserveValue = BeanProperties.value("profondeur").observe(caisson);
		bindingContext.bindValue(observeSelectionSpinner_profondeurObserveWidget_1, profondeurCaissonObserveValue, null, null);
		//
		IObservableValue observeSelectionSpinner_longeurObserveWidget_1 = WidgetProperties.widgetSelection().observe(spinner_longeur);
		IObservableValue longeurCaissonObserveValue = BeanProperties.value("longeur").observe(caisson);
		bindingContext.bindValue(observeSelectionSpinner_longeurObserveWidget_1, longeurCaissonObserveValue, null, null);
		//
		IObservableValue observeSelectionSpinner_hauteurObserveWidget_1 = WidgetProperties.widgetSelection().observe(spinner_hauteur);
		IObservableValue hauteurCaissonObserveValue = BeanProperties.value("hauteur").observe(caisson);
		bindingContext.bindValue(observeSelectionSpinner_hauteurObserveWidget_1, hauteurCaissonObserveValue, null, null);
		//
		return bindingContext;
	}
}
