package dressing.ui;

import org.eclipse.jface.viewers.ITreeContentProvider;

import dressing.model.DesignObject3D;
import dressing.model.ModelPackageProjectParent;
import dressing.model.ProjectParent;

public class ModelPackageTreeContentProvider implements ITreeContentProvider {
    @Override
    public boolean hasChildren(Object element) {
    	if(element!=null && element instanceof DesignObject3D)
    	{
    		DesignObject3D obj3d = (DesignObject3D)element;
    		if(obj3d!=null && obj3d.getChilds().size()>0)
    		{
    			return true;
    		}
    		return false;
    	}
        return false;
    }

    @Override
    public Object getParent(Object element) {
    	if(element!=null && element instanceof DesignObject3D)
    	{
    		DesignObject3D obj3d = (DesignObject3D)element;
    		return obj3d.getParentdesign();
    	}
        return null;
    }

    @Override
    public Object[] getElements(Object inputElement) {
    	if(inputElement instanceof ModelPackageProjectParent)
    	{
    		if(((ModelPackageProjectParent) inputElement).getProjects()!=null && !((ModelPackageProjectParent) inputElement).getProjects().isEmpty())
    		{
    			Object[]  o = ((ModelPackageProjectParent) inputElement).getProjects().toArray();
       		 return o;
    		}
    		//ne doit pas etre null
    		Object[] o = new Object[] {};
    		return o;
    	}
    	//ne doit pas etre null
    	Object[] o = new Object[] {};
		return o;
    }

    @Override
    public Object[] getChildren(Object parentElement) {
    	if(parentElement!=null && parentElement instanceof DesignObject3D)
    	{
    		DesignObject3D obj3d = (DesignObject3D)parentElement;
    		return obj3d.getChilds().toArray();
    	}
        return null;
    }
}