package dressing.model;

import dressing.model.debitage.DebitageFormulas;
import dressing.model.debitage.TiroirDebitageFormulas;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.CaissonType;
import dressing.model.types.TiroireFacadeType;
import dressing.model.types.TirroirType;

public class Tirroir extends Space3D{
	public final static double MIN_TIROIRE_HEIGHT = 100;
	private TiroireFacadeType tiroireFacadeType= TiroireFacadeType.FACADE_EXTERIEUR_TIROIR;
	private TirroirType tiroirType=TirroirType.CLASSIC;
	

	public TirroirType getTiroirType() {
		return tiroirType;
	}
	
	public void setTiroirType(TirroirType tiroirType) {
		TirroirType oldValue=this.tiroirType;
		this.tiroirType = tiroirType;
		firePropertyChange("tiroirType", oldValue, this.tiroirType);	
	}

	public TiroireFacadeType getTiroireFacadeType() {
		return tiroireFacadeType;
	}

	public void setTiroireFacadeType(TiroireFacadeType tiroireFacadeType) {
		TiroireFacadeType oldValue=this.tiroireFacadeType;
		this.tiroireFacadeType = tiroireFacadeType;
		firePropertyChange("tiroireFacadeType", oldValue, this.tiroireFacadeType);	
	}

	/* (non-Javadoc)
	 * @see dressing.model.Space3D#isdrawable()
	 */
	@Override
	public boolean isdrawable() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean canHold(DesignObject3D child) {
		// TODO Auto-generated method stub
		if(child instanceof Piece2D)
		{
			return true;
		}
		return true;
	}

	@Override
	public DesignObject3D clone() {
		Tirroir space=new Tirroir();
		try {
			space=(Tirroir) this.copy((DesignObject3D)space);
		} catch (DesignException | GeometricEngineException | CloneNotSupportedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return space;
	}
	@Override
	public DesignObject3D copy(DesignObject3D object) throws DesignException, GeometricEngineException, CloneNotSupportedException {
		Tirroir tirroir=(Tirroir) object;
		tirroir=(Tirroir) super.copy(tirroir);
		tirroir.setTiroireFacadeType(getTiroireFacadeType());
		tirroir.setTiroirType(getTiroirType());
		return tirroir;
	}
	
	@Override
	public DebitageFormulas getDebitageFormulas() {
		if(formulas==null|| !(formulas instanceof TiroirDebitageFormulas)) {
			formulas = new TiroirDebitageFormulas();
		}
		return formulas; 
	}
}
