package dressing.handlers.gdx;

import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;

import dressing.model.ProjectManager;
import dressing.cam.model.PlanUsinage;
import dressing.ui.cam.parts.GcodeEditorPart;
import gdxapp.scenes.Scene;
import gdxapp.screens.room.ActionController;
import gdxapp.screens.room.RoomController;
import gdxapp.screens.room3d.Room3DController;
import gdxapp.screens.room3d.Room3DScreen;

public class CAmera3DLookAt {
	
	@Execute
	public void execute(ParameterizedCommand command) {
		if(Scene.game.getScreen() instanceof Room3DScreen) {
			Room3DController controller=((Room3DScreen)Scene.game.getScreen()).getController();
			if(controller!=null && controller instanceof Room3DController && controller.getCameraController().getCamera()!=null) {
				if(command.getParameterMap().get("dressing.commandparameter.camera.look.at.direction")!=null)
				{
				
					String persp = (String) command.getParameterMap().get("dressing.commandparameter.camera.look.at.direction");

					switch (persp) {
					case "up":
						controller.getCameraController().tild(5);

						break;
					case "down":
					
						controller.getCameraController().tild(-5);;
						break;
					case "left":
						controller.getCameraController().lookLaterally(-5);

						break;
					case "right":
						controller.getCameraController().lookLaterally(5);
			        	 break;
					default:
						break ;
					}

				}
			}
		}
		
	}
	
	@CanExecute
	public boolean check() {
		if(ProjectManager.getManager().getCurrentKitchen()==null) {
			return false;
		}
		return true;
	}

}
