package dressing.handlers.cam;

import javax.inject.Inject;

import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.swt.widgets.Shell;

import dressing.cam.model.PlanUsinage;
import dressing.ui.cam.parts.GcodeEditorPart;

public class GcodeViewModeHandler {

	@Inject ESelectionService selectionService;
	
	@Inject
	IEclipseContext  eclipsecontext;
	@Execute
	public void execute(ParameterizedCommand command,EPartService partService,Shell shell){
		MPart part  = partService.getActivePart();
		if(part!=null)
		{
			Object o = part.getObject();
			if(o instanceof GcodeEditorPart)
			{
				GcodeEditorPart perspectiveview2d= (GcodeEditorPart)o;
				if(command.getParameterMap().get("dressing.commandparameter.perspective.gcode.choosed")==null)
				{
					
					System.out.println("  view selected default" );
				}
				else
				{
					String persp = (String) command.getParameterMap().get("dressing.commandparameter.perspective.gcode.choosed");
					switch (persp) {
					case "Face":
						perspectiveview2d.setPerspective(PlanUsinage.FRONT);
						break;
					case "Back":
						perspectiveview2d.setPerspective(PlanUsinage.BACK);
						break;
					case "Haut":
						perspectiveview2d.setPerspective(PlanUsinage.TOP);
						break;
					case "Bas":
						perspectiveview2d.setPerspective(PlanUsinage.DOWN);
						break;
					case "Droite":
						perspectiveview2d.setPerspective(PlanUsinage.RIGHT);
						break;	
					case "Gauche":
						perspectiveview2d.setPerspective(PlanUsinage.LEFT);
						break;		
					default:
						perspectiveview2d.setPerspective(PlanUsinage.FRONT);
						break;
					}
					System.out.println("  view selected " + command.getParameterMap().get("dressing.commandparameter.perspective.gcode.choosed"));

				}
				
			}
		}
	
	}
	@CanExecute
	public boolean check()
	{
		return true;
		
	}
}
