package dressing.handlers;

import java.util.Date;

import javax.inject.Inject;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.internal.contexts.EclipseContext;
import org.eclipse.e4.core.internal.contexts.osgi.EclipseContextOSGi;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;

import dressing.ui.update.UpdateProductWizard;

public class SearchForUpdateHandler {
	

	@Execute
	public void execute(Shell shell,IWorkbench workbench) {
		UpdateProductWizard wizard =new UpdateProductWizard();
		wizard.setWorkbench(workbench);
		WizardDialog dialog = new WizardDialog(shell,wizard );
		dialog.open();
	}
	
	@CanExecute
	public boolean check() {
		return true;
	}

}
