package dressing.cam.model;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

import dressing.model.Cavity;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Piece2D;
import dressing.model.usinage.Direction;
import dressing.model.usinage.Rainure;
import dressing.model.usinage.Trou;
import dressing.model.usinage.Usinage;

public class Util {
	public static Comparator<Cercle2D> comparX = new Comparator<Cercle2D>() {

		@Override
		public int compare(Cercle2D o1, Cercle2D o2) {
			double x1 = o1.getxPos();
			double x2 = o2.getxPos();
			double y1 = o1.getyPos();
			double y2 = o2.getyPos();
			if (x1 >= x2 && y1 >= y2) {
				return 1;
			} else if (x1 <= x2 && y1 <= y2) {
				return -1;
			} else {
				if (x1 >= x2 && y1 <= y2) {
					return 1;
				} else if (x1 <= x2 && y1 >= y2) {
					return -1;
				}
			}
			return 0;
		}

	};
	public static Comparator<Cercle2D> comparY = new Comparator<Cercle2D>() {

		@Override
		public int compare(Cercle2D o1, Cercle2D o2) {
			double x1 = o1.getxPos();
			double x2 = o2.getxPos();
			double y1 = o1.getyPos();
			double y2 = o2.getyPos();
			if (x1 >= x2 && y1 >= y2) {
				return 1;
			} else if (x1 <= x2 && y1 <= y2) {
				return -1;
			} else {
				if (y1 >= y2 && x1 <= x2) {
					return 1;
				} else if (y1 <= y2 && x1 >= x2) {
					return -1;
				}

			}
			return 0;
		}

	};

	public static double calculateDistance(List<Cercle2D> trous) {
		double cdisance = 0;
		for (int i = 0; i < trous.size() - 1; i++) {

			double x1 = trous.get(i).getxPos();
			double x2 = trous.get(i + 1).getxPos();
			double y1 = trous.get(i).getyPos();
			double y2 =trous.get(i + 1).getyPos();
			double dis = Point2D.distance(x1, y1, x2, y2);
			cdisance += dis;
		}
		return cdisance;
	}
	public static double calculateDistanceOperation(List<Operation> trous) {
		double cdisance = 0;
		for (int i = 0; i < trous.size() - 1; i++) {

			double x1 = trous.get(i).getShape().getxPos();
			double x2 = trous.get(i + 1).getShape().getxPos();
			double y1 = trous.get(i).getShape().getyPos();
			double y2 =trous.get(i + 1).getShape().getyPos();
			double dis = Point2D.distance(x1, y1, x2, y2);
			cdisance += dis;
		}
		return cdisance;
	}

	public static boolean candrawUsinage(Usinage cavity, PlanUsinage perspectiveview) {
		Piece2D piece = (Piece2D) cavity.getParentdesign();

		switch (perspectiveview) {
		case FRONT:
			return cavity.getZpos() + cavity.getProfondeurext() == piece.getProfondeurext();
		case BACK:
			return cavity.getZpos() == 0;
		case RIGHT:
			return cavity.getXpos() + cavity.getLongeurext() == piece.getLongeurext();
		case LEFT:
			return cavity.getXpos() == 0;
		case DOWN:
			return cavity.getYpos() == 0;
		case TOP:
			return cavity.getYpos() + cavity.getHauteurext() == piece.getHauteurext();
		default:
			return false;
		}
	}


	public static boolean candrawTrou(Trou tr, PlanUsinage perspectiveview) {
		switch (perspectiveview) {
		case FRONT:
			return tr.getDirection() == Direction.ZMINUS;
		case BACK:
			return tr.getDirection() == Direction.ZPLUS;
		case RIGHT:
			return tr.getDirection() == Direction.XMINUS;
		case LEFT:
			return tr.getDirection() == Direction.XPLUS;
		case DOWN:
			return tr.getDirection() == Direction.YPLUS;
		case TOP:
			return tr.getDirection() == Direction.YMINUS;
		default:
			return false;
		}

		
	}

	public static double getDepth(Rainure rn, PlanUsinage perspectiveview) {
		switch (perspectiveview) {
		case FRONT:
			return -rn.getProfondeurext();
		case BACK:
			return -rn.getProfondeurext();
		case RIGHT:
			return -rn.getLongeurext();
		case LEFT:
			return -rn.getLongeurext();
		case DOWN:
			return -rn.getHauteurext();
		case TOP:
			return -rn.getHauteurext();
		default:
			return 0;
		}

	}

	public static double getDepth(Trou tr, PlanUsinage perspectiveview) {
		return -tr.getDepth();

	}

	public static double getRainureHeight(Rainure rn, PlanUsinage perspectiveview) {
		switch (perspectiveview) {
		case FRONT:
			return rn.getHauteurext();
		case BACK:
			return rn.getHauteurext();
		case RIGHT:
			return rn.getHauteurext();
		case LEFT:
			return rn.getHauteurext();
		case DOWN:
			return rn.getProfondeurext();
		case TOP:
			return rn.getProfondeurext();
		default:
			return 0;
		}

	}

	public static double getRainureWidth(Rainure rn, PlanUsinage perspectiveview) {
		switch (perspectiveview) {
		case FRONT:
			return rn.getLongeurext();
		case BACK:
			return rn.getLongeurext();
		case RIGHT:
			return rn.getProfondeurext();
		case LEFT:
			return rn.getProfondeurext();
		case DOWN:
			return rn.getLongeurext();
		case TOP:
			return rn.getLongeurext();
		default:
			return 0;
		}

	}

	public static double getRainureXpos(Rainure rn, PlanUsinage perspectiveview) {
		Piece2D piece = (Piece2D) rn.getParentdesign();
		switch (perspectiveview) {
		case FRONT:
			return rn.getXpos();
		case BACK:
			return  rn.getXpos();
		case RIGHT:
			return piece.getProfondeurext() - rn.getZpos() - rn.getProfondeurext();
		case LEFT:
			return rn.getZpos();
		case DOWN:
			return rn.getXpos();
		case TOP:
			return rn.getXpos();
		default:
			return 0;
		}

	}

	public static double getRainureYpos(Rainure rn, PlanUsinage perspectiveview) {
		Piece2D piece = (Piece2D) rn.getParentdesign();

		switch (perspectiveview) {
		case FRONT:
			return rn.getYpos();
		case BACK:
			return piece.getHauteurext() - rn.getYpos();
		case RIGHT:
			return piece.getHauteurext() - rn.getYpos() - rn.getHauteurext();
		case LEFT:
			return piece.getHauteurext() - rn.getYpos() - rn.getHauteurext();
		case DOWN:
			return piece.getProfondeurext() - rn.getZpos() - rn.getProfondeurext();
		case TOP:
			return rn.getZpos();
		default:
			return 0;
		}

	}

	public static double getXcenter(Trou tr, PlanUsinage perspectiveview) {
		Piece2D piece = (Piece2D) tr.getParentdesign();
		if(perspectiveview == null)
			perspectiveview = PlanUsinage.FRONT;
			
		switch (perspectiveview) {
		case FRONT:
			return tr.getXcenter();
		case BACK:
			return piece.getLongeurext() - tr.getXcenter();
		case RIGHT:
			return piece.getProfondeurext() - tr.getZcenter();
		case LEFT:
			return tr.getZcenter();
		case DOWN:
			return tr.getXcenter();
		case TOP:
			return tr.getXcenter();
		default:
			return 0.00001;
		}
	}

	public static double getYcenter(Trou tr, PlanUsinage perspectiveview) {
		Piece2D piece = (Piece2D) tr.getParentdesign();
		if(perspectiveview == null)
			perspectiveview = PlanUsinage.FRONT;
		switch (perspectiveview) {
		case FRONT:
			return tr.getYcenter();
		case BACK:
			return tr.getYcenter();
		case RIGHT:
			return tr.getYcenter();
		case LEFT:
			return tr.getYcenter();
		case DOWN:
			return  tr.getZcenter();
		case TOP:
			return piece.getProfondeurext() -tr.getZcenter();
		default:
			return 0.00001;
		}
	}

	public static void sortTrous(List<Cercle2D> trous) {
		
		trous.sort(comparX);
		double xdisance = calculateDistance(trous);
		trous.sort(comparY);
		double ydisance = calculateDistance(trous);
		if (xdisance < ydisance) {
			trous.sort(comparX);
		} else {
			trous.sort(comparY);
		}
	}
	public static void sortOps(List<Operation> trous) {
		 Comparator<Operation> comparX = new Comparator<Operation>() {

			@Override
			public int compare(Operation o1, Operation o2) {
				CamShape c1=o1.getShape();
				CamShape c2=o2.getShape();
				if(c1 instanceof Cercle2D && !(c2 instanceof Cercle2D)) {
					return 1;
				}
				if(c2 instanceof Cercle2D && !(c1 instanceof Cercle2D)) {
					return -1;
				}
					

				double x1 = c1.getxPos(); 
				double x2 = c2.getxPos();
				double y1 = c1.getyPos();
				double y2 = c2.getyPos();
				if (x1 >= x2 && y1 >= y2) {
					return 1;
				} else if (x1 <= x2 && y1 <= y2) {
					return -1;
				} else {
					if (x1 >= x2 && y1 <= y2) {
						return 1;
					} else if (x1 <= x2 && y1 >= y2) {
						return -1;
					}
				}
				return 0;
			}

		};
		 Comparator<Operation> comparY = new Comparator<Operation>() {

			@Override
			public int compare(Operation o1, Operation o2) {
				CamShape c1=o1.getShape();
				CamShape c2=o2.getShape();
				double x1 = c1.getxPos();
				double x2 = c2.getxPos();
				double y1 = c1.getyPos();
				double y2 = c2.getyPos();
				if(c1 instanceof Cercle2D && !(c2 instanceof Cercle2D)) {
					return 1;
				}
				if(c2 instanceof Cercle2D && !(c1 instanceof Cercle2D)) {
					return -1;
				}
				if (x1 >= x2 && y1 >= y2) {
					return 1;
				} else if (x1 <= x2 && y1 <= y2) {
					return -1;
				} else {
					if (y1 >= y2 && x1 <= x2) {
						return 1;
					} else if (y1 <= y2 && x1 >= x2) {
						return -1;
					}
				}
				return 0;
			}

		};
		trous.sort(comparX);
		double xdisance = calculateDistanceOperation(trous);
		trous.sort(comparY);
		double ydisance = calculateDistanceOperation(trous);
		if (xdisance < ydisance) {
			trous.sort(comparX);
		} else {
			trous.sort(comparY);
		}
	}
	public static List<Cuboid> getcuboidsforPlan(PlanUsinage plan, Piece2D piece) {
		List<Cuboid> cuboids = new ArrayList<Cuboid>();
		for (DesignObject3D cv : piece.getChilds()) {
			if (cv instanceof Usinage && !(cv instanceof Trou)) {
				if (Util.candrawUsinage((Usinage) cv, plan)) {
					cuboids.add(new Cuboid((Usinage) cv, plan));
				}
			}
		}
		return cuboids;
	}

	public static List<Cercle2D> gettrousforPlan(PlanUsinage plan, Piece2D piece) {
		List<Cercle2D> trous = new ArrayList<Cercle2D>();
		for (DesignObject3D tr : piece.getChilds()) {
			if (tr instanceof Trou) {
				if (Util.candrawTrou((Trou) tr, plan)) {
					trous.add(new Cercle2D((Trou) tr, plan));
				}
			}
		}

		return trous;
	}

	public static List<Usinage> getRainureforPlan(PlanUsinage plan, Piece2D piece) {
		List<Usinage> cuboids = new ArrayList<Usinage>();
		for (DesignObject3D cv : piece.getChilds()) {
			if (cv instanceof Usinage && !(cv instanceof Trou)) {
				if (Util.candrawUsinage((Usinage) cv, plan)) {
					cuboids.add((Usinage) cv);
				}
			}
		}

		return cuboids;
	}

	public static List<Usinage> gettrous(PlanUsinage plan, Piece2D piece) {
		List<Usinage> trous = new ArrayList<Usinage>();
		for (DesignObject3D tr : piece.getChilds()) {
			if (tr instanceof Trou) {
				if (Util.candrawTrou((Trou) tr, plan)) {
					trous.add((Usinage) tr);
				}
			}
		}

		return trous;
	}
	public static double getPieceH(Piece2D piece, PlanUsinage perspectiveview) {
		if(perspectiveview == null)
			perspectiveview = PlanUsinage.FRONT;
		switch (perspectiveview) {
		case FRONT:
			return piece.getHauteurext() ;
		case BACK:
			return piece.getHauteurext();
		case RIGHT:
			return piece.getHauteurext();
		case LEFT:
			return piece.getHauteurext();
		case DOWN:
			return piece.getProfondeurext();
		case TOP:
			return piece.getProfondeurext();
		default:
			return 0.00001;
		}
	}
	public static double getPieceL(Piece2D piece, PlanUsinage perspectiveview) {
		if(perspectiveview == null)
			perspectiveview = PlanUsinage.FRONT;
		switch (perspectiveview) {
		case FRONT:
			return piece.getLongeurext() ;
		case BACK:
			return piece.getLongeurext();
		case RIGHT:
			return piece.getProfondeurext();
		case LEFT:
			return piece.getProfondeurext();
		case DOWN:
			return piece.getLongeurext();
		case TOP:
			return piece.getLongeurext();
		default:
			return 0.00001;
		}
	}
}
