package dressing.ui.bloctiroir;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import dressing.controller.BlocTirroirCreator;
import dressing.model.DesignException;
import dressing.model.evalutor.GeometricEngineException;

public class BlocTiroirWizardPage extends WizardPage {

	BlocTirroirCreator creator;
	PropertyChangeListener pcl;
	boolean errorfound=false;
	
	public BlocTirroirCreator getCreator() {
		return creator;
	}
	public void SetCreator(BlocTirroirCreator creator) {
		this.creator = creator;
	}
	/**
	 * Create the wizard.
	 */

	
	public BlocTiroirWizardPage(String pageName, BlocTirroirCreator creator) {
		super(pageName);
		setTitle("Créer un nouveau Bloc Tiroir");
		setDescription("Veuillez renseigner les propriétés de  Bloc Tiroir ");
		setPageComplete(false);
		SetCreator(creator);
	}
	/**
	 * Create contents of the wizard.
	 * @param parent
	 */
	public void createControl(Composite parent) {
		BlocTiroirWizardComposite container = new BlocTiroirWizardComposite(parent, SWT.BORDER,creator);
	
		setControl(container);
		pcl = new PropertyChangeListener() {
			
			@Override
			public void propertyChange(PropertyChangeEvent evt) {
				// TODO Auto-generated method stub
				if(!evt.getPropertyName().startsWith("project.")) //seulemnt les proprietes de javabean
				{
					try {						
						creator.create();
						setErrorMessage(null);	
						errorfound = false;
						setMessage("Vous pouvez ajouter votre cuisine", WizardPage.INFORMATION);
					} catch (DesignException  | GeometricEngineException e) {
						setErrorMessage(e.getMessage());	
						errorfound = true;
					}
					getWizard().getContainer().updateButtons();
				}

			}
		};
		creator.addPropertyChangeListener(pcl);
	
	}

	@Override
	public boolean isPageComplete() {
		// TODO Auto-generated method stub
		boolean b = !errorfound;
		return b;
	}
	public void clearlistners() {
		creator.removePropertyChangeListener(pcl);
	}
}
