package dressing.model.debitage;

import java.util.ArrayList;

import org.eclipse.emf.common.util.EList;

import dressing.controller.DressingCreator;
import dressing.model.Accessoire;
import dressing.model.Caisson;
import dressing.model.CaissonCuisine;
import dressing.model.Cavity;
import dressing.model.Charniere;
import dressing.model.Cuisine;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Dressing;
import dressing.model.Etagere;
import dressing.model.ModelProvider;
import dressing.model.Piece2D;
import dressing.model.Project3D;
import dressing.model.Separator;
import dressing.model.Space3D;
import dressing.model.SupportMeubleBas;
import dressing.model.SupportMeubleHaut;
import dressing.model.Tirroir;
import dressing.model.UsinageParam;
import dressing.model.accessoire.SupportPorteBoteille;
import dressing.model.evalutor.Equation;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.evalutor.GeomtericEngine;
import dressing.model.types.CaissonMontageType;
import dressing.model.types.CaissonType;
import dressing.model.types.CharniereType;
import dressing.model.types.CuisineCaissonType;
import dressing.model.types.PieceType;
import dressing.model.types.PortType;
import dressing.model.types.PositionCalculationType;
import dressing.model.types.PositionReferenceType;
import dressing.model.types.SeprationAxe;
import dressing.model.types.SupportPorteBoteilleType;
import dressing.model.types.TiroireFacadeType;
import dressing.model.types.TrouType;
import dressing.model.types.Zone3DType;
import dressing.model.usinage.Rainure;
import dressing.model.usinage.Trou;
import dressing.ui.parts.ParametersPart;
import param.ParamImpl;
import param.Parameters;

public class DebitageFormulas {
	static GeomtericEngine geoengine;// = new GeomtericEngine();
	DesignObject3D parent;
	DesignObject3D child;
	public ModelProvider modelprovider =new ModelProvider();
	
	public DebitageFormulas() {
		if(geoengine == null)
			geoengine = new GeomtericEngine();
	}
	
	public  void FILL_DEBITAGE_FORMULAS(DesignObject3D parent,DesignObject3D child,ArrayList<Equation> equations) throws DesignException
	{
		if(parent==null || child==null)
			throw new DesignException("Formule de debitage : Parent ou child null");
		this.parent = parent;
		this.child = child;
		FILL_USINAGE(parent,child,equations); //les parametres d usine doivent être les premier
				
		if(parent instanceof Space3D && child instanceof Piece2D)
		{
			Piece2D piece2d  = (Piece2D)child;
			Space3D space3d = (Space3D)parent;
			PieceType piecetype = piece2d.getPiecetype();
			
			switch (piecetype) {
			case HAUT_CUISSON:
				FILL_PIECE2D_FROM_PARENT(space3d, equations);
				ADDOrUpdateEquation("@this.e@", ""+piece2d.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;				
				//Fromules de debitage
				ADDOrUpdateEquation("@this.h@", "@this.e@", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.p@", "@Parent.p@", Equation.CALCULATION_AUTO,equations) ;
				if(((Caisson) space3d).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_I)){
					ADDOrUpdateEquation("@this.l@", "@Parent.l@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posx@", "0", Equation.CALCULATION_AUTO,equations) ;
				}else if(((Caisson) space3d).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_L))
				{
					ADDOrUpdateEquation("@this.l@", "@Parent.li@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posx@", "@Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
				}else
					throw new DesignException("type de montage non supporter");
				
				
				ADDOrUpdateEquation("@this.posy@", "@Parent.posy@ + @Parent.h@ - @this.e@ ", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.posz@", "@Parent.posz@", Equation.CALCULATION_AUTO,equations) ;
				
				ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
				
				FILL_CHANT_DIM("@this.l@","@this.p@","@this.l@","@this.p@",equations);
				if(space3d instanceof Caisson && ((Caisson)space3d).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_I) ) {
					FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","@ep.deuxmm@","@ep.deuxmm@","@ep.deuxmm@",equations);
				}else if(space3d instanceof Caisson && ((Caisson)space3d).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_L) ) {
					FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","0","@ep.deuxmm@","0",equations);
				}
				
				FILL_PIECE2D(piece2d, equations);
				
				break;
				//Imed bug 0001857: Créer le composant de "Bande " pour les caisson cuisine bas , casson four ...
			case BANDE_ARRIERE:	
			case BANDE_AVANT:
			case BANDE_FOUR_BAS_DROITE1:
			case BANDE_FOUR_BAS_DROITE2:
			case BANDE_FOUR_BAS_FACE:
			case BANDE_FOUR_BAS_GAUCHE1:
			case BANDE_FOUR_BAS_GAUCHE2:
				BandeDebitageFormulas formulas= new BandeDebitageFormulas();
				formulas.FILL_DEBITAGE_FORMULAS((CaissonCuisine)parent, child, equations);
				break;
			case BAS_CUISSON:
				FILL_PIECE2D_FROM_PARENT(space3d, equations);
				ADDOrUpdateEquation("@this.e@", ""+piece2d.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;				
				//Fromules de debitage
				ADDOrUpdateEquation("@this.h@", "@this.e@", Equation.CALCULATION_AUTO,equations) ;
				if(((Caisson) space3d).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_I)){
					ADDOrUpdateEquation("@this.l@", "@Parent.l@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posx@", "0", Equation.CALCULATION_AUTO,equations) ;
				}else if(((Caisson) space3d).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_L))
				{
					ADDOrUpdateEquation("@this.l@", "@Parent.li@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posx@", " @Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
				}else
					throw new DesignException("type de montage non supporter");
				//Imed bug	0001217 ajouter le retrait dériere sur bas caisson dans cas d'un caisson cuisine bas 
				if(space3d instanceof CaissonCuisine &&
						(((CaissonCuisine)space3d).getCaissoncuisineType().equals(CuisineCaissonType.Bas)
						||((CaissonCuisine)space3d).getCaissoncuisineType().equals(CuisineCaissonType.Bas_four)
						||((CaissonCuisine)space3d).getCaissoncuisineType().equals(CuisineCaissonType.colonne)
						||((CaissonCuisine)space3d).getCaissoncuisineType().equals(CuisineCaissonType.Bloc_Tiroir)
						||((CaissonCuisine)space3d).getCaissoncuisineType().equals(CuisineCaissonType.Porte_Boteille)
						||((CaissonCuisine)space3d).getCaissoncuisineType().equals(CuisineCaissonType.Porte_Pain))) {
					ADDOrUpdateEquation("@this.p@", "@Parent.p@ - @retrait.bascaissoncuisine@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "@Parent.posz@ + @retrait.bascaissoncuisine@", Equation.CALCULATION_AUTO,equations) ;

				}else {
					ADDOrUpdateEquation("@this.p@", "@Parent.p@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "@Parent.posz@", Equation.CALCULATION_AUTO,equations) ;
				}
					
				ADDOrUpdateEquation("@this.posy@", "@Parent.posy@", Equation.CALCULATION_AUTO,equations) ;
				
				ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
				//
				FILL_CHANT_DIM("@this.l@","@this.p@","@this.l@","@this.p@",equations);	
				if(space3d instanceof Caisson && ((Caisson)space3d).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_I) ) {
					FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","@ep.deuxmm@","@ep.deuxmm@","@ep.deuxmm@",equations);
				}else if(space3d instanceof Caisson && ((Caisson)space3d).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_L) ) {
					FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","0","@ep.deuxmm@","0",equations);
				}
				//
				FILL_PIECE2D(piece2d, equations);
				break;
			case BAS_CUISSON_SOUSEVIER:
				FILL_PIECE2D_FROM_PARENT(space3d, equations);
				ADDOrUpdateEquation("@this.e@", ""+piece2d.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;				
				//Fromules de debitage
				ADDOrUpdateEquation("@this.h@", "@this.e@", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.p@", "@Parent.p@ - @retrait.sousevier@", Equation.CALCULATION_AUTO,equations) ;
//				ADDOrUpdateEquation("@this.l@", "@Parent.l@", Equation.CALCULATION_AUTO,equations) ;
//				
//				ADDOrUpdateEquation("@this.posx@", "@Parent.posx@", Equation.CALCULATION_AUTO,equations) ;
				if(((Caisson) space3d).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_I)){
					ADDOrUpdateEquation("@this.l@", "@Parent.l@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posx@", "0", Equation.CALCULATION_AUTO,equations) ;
				}else if(((Caisson) space3d).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_L))
				{
					ADDOrUpdateEquation("@this.l@", "@Parent.li@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posx@", "@Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
				}else
					throw new DesignException("type de montage non supporter");
				
				
				ADDOrUpdateEquation("@this.posy@", "@Parent.posy@", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.posz@", "@Parent.posz@ + @retrait.sousevier@", Equation.CALCULATION_AUTO,equations) ;
				
				ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
				//
				FILL_CHANT_DIM("@this.l@","@this.p@","@this.l@","@this.p@",equations);	
				if(space3d instanceof Caisson && ((Caisson)space3d).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_I) ) {
					FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","@ep.deuxmm@","@ep.deuxmm@","@ep.deuxmm@",equations);
				}else if(space3d instanceof Caisson && ((Caisson)space3d).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_L) ) {
					FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","0","@ep.deuxmm@","0",equations);
				}
				//
				FILL_PIECE2D(piece2d, equations);
				break;
			case GAUCHE_CUISSON:
				FILL_PIECE2D_FROM_PARENT(space3d, equations);
				ADDOrUpdateEquation("@this.e@", ""+piece2d.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;				
				//Fromules de debitage

				
				
				if(((Caisson) space3d).getPorttype().equals(PortType.COLISSANT) 
						&& !((Caisson) space3d).getCuissontype().equals(CaissonType.EXTREME_GAUCHE) 
						&& !((Caisson) space3d).getCuissontype().equals(CaissonType.MONO_CAISSON))
				{
					ADDOrUpdateEquation("@this.p@", "@Parent.pi@ ", Equation.CALCULATION_AUTO,equations) ; //prendre la plus faible valeur en fonction de retrait
				}
				else
				{
					ADDOrUpdateEquation("@this.p@", "@Parent.p@ ", Equation.CALCULATION_AUTO,equations) ;
				}
				ADDOrUpdateEquation("@this.l@", "@this.e@", Equation.CALCULATION_AUTO,equations) ;
				//
				if(((Caisson) space3d).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_I)){
					ADDOrUpdateEquation("@this.h@", "@Parent.hi@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posy@", "@Parent.posy@ + @Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
				}else if(((Caisson) space3d).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_L))
				{
					ADDOrUpdateEquation("@this.h@", "@Parent.h@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posy@", "@Parent.posy@", Equation.CALCULATION_AUTO,equations) ;
				}else
					throw new DesignException("type de montage non supporter");
				//
				ADDOrUpdateEquation("@this.posx@", "0", Equation.CALCULATION_AUTO,equations) ;
//				ADDOrUpdateEquation("@this.posy@", "@Parent.posy@ + @Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.posz@", "@Parent.posz@ ", Equation.CALCULATION_AUTO,equations) ;
			
				ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
				//
				FILL_CHANT_DIM("@this.h@","@this.p@","@this.h@","@this.p@",equations);
				if(space3d instanceof Caisson && ((Caisson)space3d).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_I) ) {
					FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","@ep.deuxmm@","@ep.deuxmm@","@ep.deuxmm@",equations);
				}else if(space3d instanceof Caisson && ((Caisson)space3d).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_L) ) {
					FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","0","@ep.deuxmm@","0",equations);
				}
				//
				FILL_PIECE2D(piece2d, equations);
				break;
			case DROITE_CUISSON:
				FILL_PIECE2D_FROM_PARENT(space3d, equations);
				ADDOrUpdateEquation("@this.e@", ""+piece2d.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;		
				//Fromules de debitage
				if(((Caisson) space3d).getPorttype().equals(PortType.COLISSANT) 
						&& !((Caisson) space3d).getCuissontype().equals(CaissonType.EXTREME_DROITE)
						&& !((Caisson) space3d).getCuissontype().equals(CaissonType.MONO_CAISSON))
				{
					ADDOrUpdateEquation("@this.p@", "@Parent.pi@ ", Equation.CALCULATION_AUTO,equations) ; //prendre la plus faible valeur en fonction de retrait
				}
				else
				{
					ADDOrUpdateEquation("@this.p@", "@Parent.p@ ", Equation.CALCULATION_AUTO,equations) ;
				}
				ADDOrUpdateEquation("@this.l@", "@this.e@", Equation.CALCULATION_AUTO,equations) ;
				if(((Caisson) space3d).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_I)){
					ADDOrUpdateEquation("@this.h@", "@Parent.hi@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posy@", "@Parent.posy@ + @Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
				}else if(((Caisson) space3d).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_L))
				{
					ADDOrUpdateEquation("@this.h@", "@Parent.h@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posy@", "@Parent.posy@", Equation.CALCULATION_AUTO,equations) ;
				}else
					throw new DesignException("type de montage non supporter");
				ADDOrUpdateEquation("@this.posx@", " @Parent.l@- @Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
//				ADDOrUpdateEquation("@this.posy@", "@Parent.posy@ + @Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.posz@", "@Parent.posz@  ", Equation.CALCULATION_AUTO,equations) ;
				
				ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.h@,@this.p@)", Equation.CALCULATION_AUTO,equations) ;
				
				//
				FILL_CHANT_DIM("@this.h@","@this.p@","@this.h@","@this.p@",equations);
				if(space3d instanceof Caisson && ((Caisson)space3d).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_I) ) {
					FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","@ep.deuxmm@","@ep.deuxmm@","@ep.deuxmm@",equations);
				}else if(space3d instanceof Caisson && ((Caisson)space3d).getCaissonMontageType().equals(CaissonMontageType.CAISSON_MONTAGE_L) ) {
					FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","0","@ep.deuxmm@","0",equations);
				}
				//
				FILL_PIECE2D(piece2d, equations);
				
				break;	
			case PORTE:
				FILL_PIECE2D_FROM_PARENT(space3d, equations);
				ADDOrUpdateEquation("@this.e@", ""+piece2d.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;		
				//Fromules de debitage
				ADDOrUpdateEquation("@this.p@", "@this.e@", Equation.CALCULATION_AUTO,equations) ;
				
				if(space3d.getParentdesign()!=null 
						&& space3d.getParentdesign() instanceof Separator
						&& ((Separator)space3d.getParentdesign()).isInspaceporte(null)) {
						if (((Separator)space3d.getParentdesign()).getSepaxe().equals(SeprationAxe.YAXIS)) {
							if(space3d.getZonetype().equals(Zone3DType.ZONEBAS))
							{
							ADDOrUpdateEquation("@this.h@", "@Parent.h@ - @usin.porteJeu@ - @Parent.epaisseurprincipale@/2", Equation.CALCULATION_AUTO,equations) ;
							ADDOrUpdateEquation("@this.posy@", "@usin.porteJeu@/2", Equation.CALCULATION_AUTO,equations) ;
		
							}else {
								ADDOrUpdateEquation("@this.h@", "@Parent.h@ - @usin.porteJeu@ - @Parent.epaisseurprincipale@/2", Equation.CALCULATION_AUTO,equations) ;
								ADDOrUpdateEquation("@this.posy@", "@usin.porteJeu@/2 + @Parent.epaisseurprincipale@/2", Equation.CALCULATION_AUTO,equations) ;
							}
						}
						else {
							ADDOrUpdateEquation("@this.h@", "@Parent.h@ - @usin.porteJeu@", Equation.CALCULATION_AUTO,equations) ;
							ADDOrUpdateEquation("@this.posy@", "@usin.porteJeu@/2", Equation.CALCULATION_AUTO,equations) ;
						}
						if (((Separator)space3d.getParentdesign()).getSepaxe().equals(SeprationAxe.XAXIS)) {
							if(space3d.getZonetype().equals(Zone3DType.ZONEBAS))
							{
							ADDOrUpdateEquation("@this.l@", "@Parent.l@ - @usin.porteJeu@ - @Parent.epaisseurprincipale@/2", Equation.CALCULATION_AUTO,equations) ;
							ADDOrUpdateEquation("@this.posx@", "@usin.porteJeu@/2  + @Parent.epaisseurprincipale@/2", Equation.CALCULATION_AUTO,equations) ;
		
							}else {
								ADDOrUpdateEquation("@this.l@", "@Parent.l@ - @usin.porteJeu@ - @Parent.epaisseurprincipale@/2", Equation.CALCULATION_AUTO,equations) ;
								ADDOrUpdateEquation("@this.posx@", "@usin.porteJeu@/2", Equation.CALCULATION_AUTO,equations) ;
							}
						}
						else {
							ADDOrUpdateEquation("@this.l@", "@Parent.l@ - @usin.porteJeu@", Equation.CALCULATION_AUTO,equations) ;
							ADDOrUpdateEquation("@this.posx@", "@usin.porteJeu@/2", Equation.CALCULATION_AUTO,equations) ;
							
						}
						
				}else {					
					ADDOrUpdateEquation("@this.l@", "@Parent.l@ - @usin.porteJeu@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posx@", "@usin.porteJeu@/2", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.h@", "@Parent.h@ - @usin.porteJeu@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posy@", "@usin.porteJeu@/2", Equation.CALCULATION_AUTO,equations) ;
				}
				
				ADDOrUpdateEquation("@this.posz@", "@Parent.p@", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.h@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.h@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
				//
				FILL_CHANT_DIM("@this.l@","@this.h@","@this.l@","@this.h@",equations);
				FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","@ep.quatdixieme@","@ep.quatdixieme@","@ep.quatdixieme@",equations);

				//
				FILL_PIECE2D(piece2d, equations);
				
				break;
			case PORTE_GAUCHE:
				FILL_PIECE2D_FROM_PARENT(space3d, equations);
				ADDOrUpdateEquation("@this.e@", ""+piece2d.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;		
				//Fromules de debitage
				ADDOrUpdateEquation("@this.p@", "@this.e@", Equation.CALCULATION_AUTO,equations) ;
				//
				if(space3d.getParentdesign()!=null 
						&& space3d.getParentdesign() instanceof Separator
						&& ((Separator)space3d.getParentdesign()).isInspaceporte(null)) {
						if (((Separator)space3d.getParentdesign()).getSepaxe().equals(SeprationAxe.YAXIS)) {
					if(space3d.getZonetype().equals(Zone3DType.ZONEBAS))
					{
					ADDOrUpdateEquation("@this.h@", "@Parent.h@ - @usin.porteJeu@ - @Parent.epaisseurprincipale@/2", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posy@", "@usin.porteJeu@/2", Equation.CALCULATION_AUTO,equations) ;

					}else {
						ADDOrUpdateEquation("@this.h@", "@Parent.h@ - @usin.porteJeu@ - @Parent.epaisseurprincipale@/2", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.posy@", "@usin.porteJeu@/2 + @Parent.epaisseurprincipale@/2", Equation.CALCULATION_AUTO,equations) ;
					}
					
				}else {
					ADDOrUpdateEquation("@this.h@", "@Parent.h@ - @usin.porteJeu@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posy@", "@usin.porteJeu@/2", Equation.CALCULATION_AUTO,equations) ;
				}
				if (((Separator)space3d.getParentdesign()).getSepaxe().equals(SeprationAxe.XAXIS)) {
					if(space3d.getZonetype().equals(Zone3DType.ZONEBAS))
					{
					ADDOrUpdateEquation("@this.l@", "@Parent.l@/2 - @usin.porteJeu@ - @Parent.epaisseurprincipale@/4", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posx@", "@usin.porteJeu@/2 + @Parent.epaisseurprincipale@/2", Equation.CALCULATION_AUTO,equations) ;

					}else {
						ADDOrUpdateEquation("@this.l@", "@Parent.l@/2 - @usin.porteJeu@ - @Parent.epaisseurprincipale@/4", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.posx@", "@usin.porteJeu@/2 ", Equation.CALCULATION_AUTO,equations) ;
					}
				}
				else {
					ADDOrUpdateEquation("@this.l@", "@Parent.l@/2 - @usin.porteJeu@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posx@", "@usin.porteJeu@/2", Equation.CALCULATION_AUTO,equations) ;
					
				}
				
			}else {					
				ADDOrUpdateEquation("@this.l@", "@Parent.l@/2 - @usin.porteJeu@", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.posx@", "@usin.porteJeu@/2", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.h@", "@Parent.h@ - @usin.porteJeu@", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.posy@", "@usin.porteJeu@/2", Equation.CALCULATION_AUTO,equations) ;
			}
				//
				ADDOrUpdateEquation("@this.posz@", "@Parent.p@", Equation.CALCULATION_AUTO,equations) ;
				
				ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.h@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.h@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
				//
				FILL_CHANT_DIM("@this.l@","@this.h@","@this.l@","@this.h@",equations);
				FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","@ep.quatdixieme@","@ep.quatdixieme@","@ep.quatdixieme@",equations);
				//
				FILL_PIECE2D(piece2d, equations);
				
				break;		
			case PORTE_DROITE:
				FILL_PIECE2D_FROM_PARENT(space3d, equations);
				ADDOrUpdateEquation("@this.e@", ""+piece2d.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;		
				//Fromules de debitage
				ADDOrUpdateEquation("@this.p@", "@this.e@", Equation.CALCULATION_AUTO,equations) ;
				//
				if(space3d.getParentdesign()!=null 
						&& space3d.getParentdesign() instanceof Separator
						&& ((Separator)space3d.getParentdesign()).isInspaceporte(null)){
							if (((Separator)space3d.getParentdesign()).getSepaxe().equals(SeprationAxe.YAXIS)) {
					if(space3d.getZonetype().equals(Zone3DType.ZONEBAS))
					{
					ADDOrUpdateEquation("@this.h@", "@Parent.h@ - @usin.porteJeu@ - @Parent.epaisseurprincipale@/2", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posy@", "@usin.porteJeu@/2", Equation.CALCULATION_AUTO,equations) ;

					}else {
						ADDOrUpdateEquation("@this.h@", "@Parent.h@ - @usin.porteJeu@ - @Parent.epaisseurprincipale@/2", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.posy@", "@usin.porteJeu@/2 + @Parent.epaisseurprincipale@/2", Equation.CALCULATION_AUTO,equations) ;
					}
					
				}else {
					ADDOrUpdateEquation("@this.h@", "@Parent.h@ - @usin.porteJeu@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posy@", "@usin.porteJeu@/2", Equation.CALCULATION_AUTO,equations) ;
				}
				if (((Separator)space3d.getParentdesign()).getSepaxe().equals(SeprationAxe.XAXIS)) {
					if(space3d.getZonetype().equals(Zone3DType.ZONEBAS))
					{
						ADDOrUpdateEquation("@this.l@", "@Parent.l@/2 - @usin.porteJeu@ - @Parent.epaisseurprincipale@/4", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.posx@", "@usin.porteJeu@/2 + @Parent.l@/2 + @Parent.epaisseurprincipale@/4", Equation.CALCULATION_AUTO,equations) ;

					}else {
						ADDOrUpdateEquation("@this.l@", "@Parent.l@/2 - @usin.porteJeu@ - @Parent.epaisseurprincipale@/4", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.posx@", "@usin.porteJeu@/2 + @Parent.l@/2 - @Parent.epaisseurprincipale@/4", Equation.CALCULATION_AUTO,equations) ;
						}
				}
				else {
					ADDOrUpdateEquation("@this.l@", "@Parent.l@/2 - @usin.porteJeu@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posx@", "@usin.porteJeu@/2 + @Parent.l@/2", Equation.CALCULATION_AUTO,equations) ;
								
					}
			}else {					
				ADDOrUpdateEquation("@this.l@", "@Parent.l@/2 - @usin.porteJeu@", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.posx@", "@usin.porteJeu@/2 +@Parent.l@/2", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.h@", "@Parent.h@ - @usin.porteJeu@", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.posy@", "@usin.porteJeu@/2", Equation.CALCULATION_AUTO,equations) ;
			}				
				//
				ADDOrUpdateEquation("@this.posz@", "@Parent.p@", Equation.CALCULATION_AUTO,equations) ;
				
				ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.h@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.h@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
				
				//
				FILL_CHANT_DIM("@this.l@","@this.h@","@this.l@","@this.h@",equations);
				FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","@ep.quatdixieme@","@ep.quatdixieme@","@ep.quatdixieme@",equations);
				//
				
				FILL_PIECE2D(piece2d, equations);
				
				break;
			case PORTE_HAUT:
				FILL_PIECE2D_FROM_PARENT(space3d, equations);
				ADDOrUpdateEquation("@this.e@", ""+piece2d.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;		
				//Fromules de debitage
				ADDOrUpdateEquation("@this.p@", "@this.e@", Equation.CALCULATION_AUTO,equations) ;
				//
				if(space3d.getParentdesign()!=null 
						&& space3d.getParentdesign() instanceof Separator
						&& ((Separator)space3d.getParentdesign()).isInspaceporte(null)) {
						if(((Separator)space3d.getParentdesign()).getSepaxe().equals(SeprationAxe.YAXIS)) {
					if(space3d.getZonetype().equals(Zone3DType.ZONEBAS))
					{
					ADDOrUpdateEquation("@this.h@", "@Parent.h@/2 - @usin.porteJeu@ - @Parent.epaisseurprincipale@/4", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posy@", "@Parent.h@/2 + @usin.porteJeu@/2 - @Parent.epaisseurprincipale@/4", Equation.CALCULATION_AUTO,equations) ;

					}else {
						ADDOrUpdateEquation("@this.h@", "@Parent.h@/2 - @usin.porteJeu@ - @Parent.epaisseurprincipale@/4", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.posy@", "@Parent.h@/2 + @usin.porteJeu@/2 + @Parent.epaisseurprincipale@/4", Equation.CALCULATION_AUTO,equations) ;
					}
					
				}else {
					ADDOrUpdateEquation("@this.h@", "@Parent.h@/2 - @usin.porteJeu@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posy@", "@Parent.h@/2 + @usin.porteJeu@/2", Equation.CALCULATION_AUTO,equations) ;
				}
				if (((Separator)space3d.getParentdesign()).getSepaxe().equals(SeprationAxe.XAXIS)) {
					if(space3d.getZonetype().equals(Zone3DType.ZONEBAS))
					{
						ADDOrUpdateEquation("@this.l@", "@Parent.l@ - @usin.porteJeu@ - @Parent.epaisseurprincipale@/2", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.posx@", "@usin.porteJeu@/2 + @Parent.epaisseurprincipale@/2", Equation.CALCULATION_AUTO,equations) ;
		
					}else {
						ADDOrUpdateEquation("@this.l@", "@Parent.l@ - @usin.porteJeu@ - @Parent.epaisseurprincipale@/2", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.posx@", "@usin.porteJeu@/2", Equation.CALCULATION_AUTO,equations) ;
					}
				}else {
					ADDOrUpdateEquation("@this.l@", "@Parent.l@ - @usin.porteJeu@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posx@", "@usin.porteJeu@/2", Equation.CALCULATION_AUTO,equations) ;
							
				}		
			}else {
				ADDOrUpdateEquation("@this.l@", "@Parent.l@ - @usin.porteJeu@", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.posx@", " @usin.porteJeu@/2", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.h@", "@Parent.h@/2 - @usin.porteJeu@", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.posy@", "@Parent.h@/2 + @usin.porteJeu@/2", Equation.CALCULATION_AUTO,equations) ;
			}
				//
				ADDOrUpdateEquation("@this.posz@", "@Parent.p@", Equation.CALCULATION_AUTO,equations) ;
				
				ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.h@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.h@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
				
				//
				FILL_CHANT_DIM("@this.l@","@this.h@","@this.l@","@this.h@",equations);
				FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","@ep.quatdixieme@","@ep.quatdixieme@","@ep.quatdixieme@",equations);
				//
				
				FILL_PIECE2D(piece2d, equations);
				
				break;
			case PORTE_BAS:
				FILL_PIECE2D_FROM_PARENT(space3d, equations);
				ADDOrUpdateEquation("@this.e@", ""+piece2d.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;		
				//Fromules de debitage
				ADDOrUpdateEquation("@this.p@", "@this.e@", Equation.CALCULATION_AUTO,equations) ;
				//
				if(space3d.getParentdesign()!=null 
						&& space3d.getParentdesign() instanceof Separator
						&& ((Separator)space3d.getParentdesign()).isInspaceporte(null)) {
					if(((Separator)space3d.getParentdesign()).getSepaxe().equals(SeprationAxe.YAXIS)) {
						if(space3d.getZonetype().equals(Zone3DType.ZONEBAS))
						{
						ADDOrUpdateEquation("@this.h@", "@Parent.h@/2 - @usin.porteJeu@ - @Parent.epaisseurprincipale@/4", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.posy@", "@usin.porteJeu@/2 ", Equation.CALCULATION_AUTO,equations) ;
	
						}else {
							ADDOrUpdateEquation("@this.h@", "@Parent.h@/2 - @usin.porteJeu@ - @Parent.epaisseurprincipale@/4", Equation.CALCULATION_AUTO,equations) ;
							ADDOrUpdateEquation("@this.posy@", "@usin.porteJeu@/2 + @Parent.epaisseurprincipale@/2", Equation.CALCULATION_AUTO,equations) ;
						}
					
					}else {
					ADDOrUpdateEquation("@this.h@", "@Parent.h@/2 - @usin.porteJeu@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posy@", " @usin.porteJeu@/2", Equation.CALCULATION_AUTO,equations) ;
					}
					if (((Separator)space3d.getParentdesign()).getSepaxe().equals(SeprationAxe.XAXIS)) {
						if(space3d.getZonetype().equals(Zone3DType.ZONEBAS)){
							ADDOrUpdateEquation("@this.l@", "@Parent.l@ - @usin.porteJeu@ - @Parent.epaisseurprincipale@/2", Equation.CALCULATION_AUTO,equations) ;
							ADDOrUpdateEquation("@this.posx@", "@usin.porteJeu@/2 + @Parent.epaisseurprincipale@/2", Equation.CALCULATION_AUTO,equations) ;
						}else {
							ADDOrUpdateEquation("@this.l@", "@Parent.l@ - @usin.porteJeu@ - @Parent.epaisseurprincipale@/2", Equation.CALCULATION_AUTO,equations) ;
							ADDOrUpdateEquation("@this.posx@", "@usin.porteJeu@/2 ", Equation.CALCULATION_AUTO,equations) ;
							}
					}else {
						ADDOrUpdateEquation("@this.l@", "@Parent.l@ - @usin.porteJeu@", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.posx@", "@usin.porteJeu@/2", Equation.CALCULATION_AUTO,equations) ;
											
						}		
				}else {
					ADDOrUpdateEquation("@this.l@", "@Parent.l@ - @usin.porteJeu@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posx@", " @usin.porteJeu@/2", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.h@", "@Parent.h@/2 - @usin.porteJeu@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posy@", "@usin.porteJeu@/2", Equation.CALCULATION_AUTO,equations) ;
				}
				//
				ADDOrUpdateEquation("@this.posz@", "@Parent.p@", Equation.CALCULATION_AUTO,equations) ;
				
				ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.h@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.h@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
				
				//
				FILL_CHANT_DIM("@this.l@","@this.h@","@this.l@","@this.h@",equations);
				FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","@ep.quatdixieme@","@ep.quatdixieme@","@ep.quatdixieme@",equations);
				//
				
				FILL_PIECE2D(piece2d, equations);
				
				break;
			case DOS_INTERIEUR:
				FILL_PIECE2D_FROM_PARENT(space3d, equations);
				ADDOrUpdateEquation("@this.e@", ""+piece2d.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;		
				//Fromules de debitage
				ADDOrUpdateEquation("@this.h@", "@Parent.hi@ + 2*@usin.dosRainureProf@ ", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.p@", "@this.e@", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.l@", "@Parent.li@ + 2*@usin.dosRainureProf@ ", Equation.CALCULATION_AUTO,equations) ;
				
				ADDOrUpdateEquation("@this.posx@", "@Parent.epaisseurprincipale@ - @usin.dosRainureProf@", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.posy@", "@Parent.epaisseurprincipale@ - @usin.dosRainureProf@ ", Equation.CALCULATION_AUTO,equations) ;
				if(space3d instanceof CaissonCuisine) {
					CaissonCuisine caisson=(CaissonCuisine) space3d;
					CuisineCaissonType type=caisson.getCaissoncuisineType();
					if(type.equals(CuisineCaissonType.Bas)||type.equals(CuisineCaissonType.Bas_four)||type.equals(CuisineCaissonType.colonne)
						||type.equals(CuisineCaissonType.Bloc_Tiroir)||type.equals(CuisineCaissonType.Porte_Boteille)||type.equals(CuisineCaissonType.Porte_Pain)) {
						ADDOrUpdateEquation("@this.posz@", " @usin.dosRainurePositionOffset@ +@retrait.bascaissoncuisine@", Equation.CALCULATION_AUTO,equations) ;
					}else if(type.equals(CuisineCaissonType.Bas_sousevier)) {
						ADDOrUpdateEquation("@this.posz@", " @usin.dosRainurePositionOffset@ +@retrait.sousevier@", Equation.CALCULATION_AUTO,equations) ;
					}else {
						ADDOrUpdateEquation("@this.posz@", " @usin.dosRainurePositionOffset@", Equation.CALCULATION_AUTO,equations) ;
					}
				}else {
					ADDOrUpdateEquation("@this.posz@", " @usin.dosRainurePositionOffset@", Equation.CALCULATION_AUTO,equations) ;
				}
				
				ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.h@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.h@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
				
				
					FILL_CHANT_DIM("0","0","0","0",equations);
					FILL_CHANT_EPAISSEUR("0","0","0","0",equations);
				
				
				FILL_PIECE2D(piece2d, equations);
				
				break;
			case DOS_EXTERIRUR:
				FILL_PIECE2D_FROM_PARENT(space3d, equations);
				ADDOrUpdateEquation("@this.e@", ""+piece2d.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;		
				//Fromules de debitage
				ADDOrUpdateEquation("@this.h@", "@Parent.h@", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.p@", "@this.e@", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.l@", "@Parent.l@", Equation.CALCULATION_AUTO,equations) ;
				
				ADDOrUpdateEquation("@this.posx@", "0", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.posy@", "0", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.posz@", "- @this.e@", Equation.CALCULATION_AUTO,equations) ;
				
				
				ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.h@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.h@,@this.l@)", Equation.CALCULATION_AUTO,equations) ;
				
				FILL_CHANT_DIM("0","0","0","0",equations);
				FILL_CHANT_EPAISSEUR("0","0","0","0",equations);
				
				
				FILL_PIECE2D(piece2d, equations);
				
				break;			
				
			case SEPRATEUR_TRANSVERSANT: {
				if (child instanceof Separator == false || parent instanceof Space3D == false) {
					throw new DesignException("Type de parent ou de child incorrect pour le seprateur");
				}
				Separator sep = (Separator) child;
				Space3D space = (Space3D) parent;
				FILL_SEPRATOR_FROM_SPACE3d(space, equations);
				ChaeckorUpdateSepTranseversale(space, sep,equations);
				
			}

				break;
				
			case SEPRATEUR_NORMAL:
			{
				if (child instanceof Separator == false || parent instanceof Space3D == false) {
					throw new DesignException("Type de parent ou de child incorrect pour le seprateur");
				}
				Separator sep = (Separator) child;
				Space3D space = (Space3D) parent;
				FILL_SEPRATOR_FROM_SPACE3d(space, equations);
				ChaeckorUpdateSepNormale(space, sep, equations);
			}
				break;
			case ETAGERE_FIXE:
				if (child instanceof Etagere == false || parent instanceof Space3D == false  ) {
					throw new DesignException("Type de parent ou de child incorrect pour l'etagere");
				}
				Etagere etg = (Etagere) child;
				Space3D space = (Space3D) parent;
			
				FILL_SEPRATOR_FROM_SPACE3d(space, equations);
				
				ADDOrUpdateEquation("@this.e@", "" + etg.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations);
				ADDOrUpdateEquation("@this.sepposition@", "" + etg.getYpos(), Equation.CALCULATION_MANUAL,equations);
				// Fromules de debitage
				if (!etg.getSepaxe().equals(SeprationAxe.YAXIS)) {
					throw new DesignException("la separation utilisant axe autre que l'y n'est pas supporter");
				}
					ADDOrUpdateEquation("@this.h@", "@this.e@", Equation.CALCULATION_AUTO, equations);
					ADDOrUpdateEquation("@this.p@", "@Parent.pi@ ", Equation.CALCULATION_AUTO, equations);
					ADDOrUpdateEquation("@this.l@", "@Parent.li@", Equation.CALCULATION_AUTO, equations);
					ADDOrUpdateEquation("@this.posx@", "@Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations);
					ADDOrUpdateEquation("@this.posy@", "@this.sepposition@ + @Parent.epaisseurprincipale@ ",Equation.CALCULATION_AUTO, equations);
					ADDOrUpdateEquation("@this.posz@", "@Parent.posz@", Equation.CALCULATION_AUTO, equations);
					ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations);
					ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations);

					//
					FILL_CHANT_DIM("@this.l@","@this.p@","@this.l@","@this.p@",equations);
					FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","0","@ep.deuxmm@","0",equations);
					//
					
				FILL_PIECE2D(piece2d, equations);
				break;	
			case ETAGERE_MOBILE:
				if (child instanceof Etagere == false || parent instanceof Space3D == false  ) {
					throw new DesignException("Type de parent ou de child incorrect pour l'etagere");
				}
				Etagere etgM = (Etagere) child;
				Space3D spaceM = (Space3D) parent;
			
				FILL_SEPRATOR_FROM_SPACE3d(spaceM, equations);
				
				ADDOrUpdateEquation("@this.e@", "" + etgM.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations);
				ADDOrUpdateEquation("@this.sepposition@", "" + etgM.getYpos(), Equation.CALCULATION_MANUAL,equations);
				ADDOrUpdateEquation("@this.retrait@", "" + etgM.getRetraitFacade(), Equation.CALCULATION_MANUAL,equations);
				// Fromules de debitage
				if (!etgM.getSepaxe().equals(SeprationAxe.YAXIS)) {
					throw new DesignException("l'etagere utilisant axe autre que l'y n'est pas supporter");
				}
					ADDOrUpdateEquation("@this.h@", "@this.e@", Equation.CALCULATION_AUTO, equations);
					ADDOrUpdateEquation("@this.l@", "@Parent.li@ - 2 * @usin.jeuEtagereMobile@", Equation.CALCULATION_AUTO, equations);
					ADDOrUpdateEquation("@this.posx@", "@Parent.epaisseurprincipale@ + @usin.jeuEtagereMobile@", Equation.CALCULATION_AUTO,equations);
					ADDOrUpdateEquation("@this.posy@", "@this.sepposition@ ",Equation.CALCULATION_AUTO, equations);
					
						Boolean isParentHasDos=false;
						Piece2D dos=null;
						for(DesignObject3D piece:spaceM.getChilds()) {
							if(piece instanceof Piece2D && ((Piece2D)piece).getPiecetype().equals(PieceType.DOS_INTERIEUR)) {
								isParentHasDos=true;
								dos=(Piece2D) piece;
							}
						}
						if(!isParentHasDos  ) {
							ADDOrUpdateEquation("@this.posz@", "0", Equation.CALCULATION_AUTO, equations);
							ADDOrUpdateEquation("@this.p@", "@Parent.pi@ - @this.retrait@ ", Equation.CALCULATION_AUTO, equations);

						}else
						{
							ADDOrUpdateEquation("@parentdos.posz@", ""+dos.getZpos(), Equation.CALCULATION_AUTO, equations);
							ADDOrUpdateEquation("@this.posz@", " @Parent.epaisseursecondaire@ + @usin.jeurainuredos@ + @parentdos.posz@", Equation.CALCULATION_AUTO, equations);
							ADDOrUpdateEquation("@this.p@", "@Parent.pi@ - @this.retrait@ - @parentdos.posz@ - @Parent.epaisseursecondaire@ - @usin.jeurainuredos@", Equation.CALCULATION_AUTO, equations);
						}
				
					ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations);
					ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations);
					//
				FILL_CHANT_DIM("@this.l@","@this.p@","@this.l@","@this.p@",equations);
				FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","0","@ep.deuxmm@","0",equations);
					//
					
				FILL_PIECE2D(piece2d, equations);
				//	
				break;		
			case GENERIC:
				break;
			default:
				throw new DesignException(piecetype+" not found in debitage formula");
			}
			

		}
		else if(parent instanceof Separator && child instanceof Space3D)
		{
			FILL_SPACE3D_FROM_Seprator((Separator)parent, equations);
			Separator sep  = (Separator)parent;
			Space3D space = (Space3D)child;
			ADDOrUpdateEquation("@sep.retraitDeriere@",""+ sep.getSepretraitderiere(), Equation.CALCULATION_AUTO,equations) ;
			//Horizonale
			if(sep.getSepaxe().equals(SeprationAxe.YAXIS))
			{	
				if(space.getZonetype().equals(Zone3DType.ZONEHAUT))
				{
					ADDOrUpdateEquation("@this.hi@", "@ParentSPC.hi@ - @Sep.posy@ - @Sep.e@ + @ParentSPC.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posy@", "0", Equation.CALCULATION_AUTO,equations) ;
					
				}
				else
				{
					ADDOrUpdateEquation("@this.hi@", "@Sep.posy@ - @ParentSPC.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posy@", "-@Sep.posy@ ", Equation.CALCULATION_AUTO,equations) ;
				
				}								
				ADDOrUpdateEquation("@this.p@", "@ParentSPC.p@ - @Sep.posz@", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.pi@", "@Sep.p@", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.l@", "@ParentSPC.l@", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.li@", "@ParentSPC.li@", Equation.CALCULATION_AUTO,equations) ;	
				
				ADDOrUpdateEquation("@this.h@", "@this.hi@ + @ParentSPC.epaisseurprincipale@ + @Sep.e@", Equation.CALCULATION_AUTO,equations) ;
		
			
				ADDOrUpdateEquation("@this.posx@", "- @ParentSPC.epaisseurprincipale@ ", Equation.CALCULATION_AUTO,equations) ;				
				ADDOrUpdateEquation("@this.posz@", "0", Equation.CALCULATION_AUTO,equations) ;						
			}
			else if(sep.getSepaxe().equals(SeprationAxe.XAXIS))
			{
				if(space.getZonetype().equals(Zone3DType.ZONEHAUT))
				{
					ADDOrUpdateEquation("@this.li@", "@Sep.posx@ - @ParentSPC.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posx@", "-@Sep.posx@", Equation.CALCULATION_AUTO,equations) ;
					
					
				}
				else
				{
					ADDOrUpdateEquation("@this.li@", "@ParentSPC.li@ - @Sep.posx@ - @Sep.e@ + @ParentSPC.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posx@", "0", Equation.CALCULATION_AUTO,equations) ;
				
				}								
				ADDOrUpdateEquation("@this.p@", "@ParentSPC.p@ - @Sep.posz@", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.pi@", "@Sep.p@", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.h@", "@ParentSPC.h@", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.hi@", "@ParentSPC.hi@", Equation.CALCULATION_AUTO,equations) ;	
				
				ADDOrUpdateEquation("@this.l@", "@this.li@ + @ParentSPC.epaisseurprincipale@ + @Sep.e@", Equation.CALCULATION_AUTO,equations) ;
		
			
				ADDOrUpdateEquation("@this.posy@", "- @ParentSPC.epaisseurprincipale@ ", Equation.CALCULATION_AUTO,equations) ;				
				ADDOrUpdateEquation("@this.posz@", "0", Equation.CALCULATION_AUTO,equations) ;		
			}
			else if(sep.getSepaxe().equals(SeprationAxe.ZAXIS))
			{
				if(space.getZonetype().equals(Zone3DType.ZONEHAUT))
				{
					ADDOrUpdateEquation("@this.pi@", "@ParentSPC.pi@ - @Sep.posz@ - @Sep.e@ ", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "@Sep.e@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.p@", "@ParentSPC.p@ - @Sep.posz@ - @Sep.e@", Equation.CALCULATION_AUTO,equations) ;
				}
				else
				{	
					if(sep.getPiecetype().equals(PieceType.SEPRATEUR_TRANSVERSANT)) {
					ADDOrUpdateEquation("@this.pi@", "@Sep.posz@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "-@Sep.posz@ ", Equation.CALCULATION_AUTO,equations) ;
				
					}else if(sep.getPiecetype().equals(PieceType.SEPRATEUR_NORMAL)) {
						ADDOrUpdateEquation("@this.pi@", "@Sep.posz@ -@usin.dosRainurePositionOffset@ - @ParentSPC.epaisseursecondaire@ - @usin.jeurainuredos@", Equation.CALCULATION_AUTO,equations) ;
						ADDOrUpdateEquation("@this.posz@", "-@Sep.posz@ +@usin.dosRainurePositionOffset@ + @ParentSPC.epaisseursecondaire@ + @usin.jeurainuredos@", Equation.CALCULATION_AUTO,equations) ;
					}
					ADDOrUpdateEquation("@this.p@", "@this.pi@", Equation.CALCULATION_AUTO,equations) ;
				}								
				ADDOrUpdateEquation("@this.l@", "@ParentSPC.l@", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.li@", "@ParentSPC.li@", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.h@", "@ParentSPC.h@", Equation.CALCULATION_AUTO,equations) ;
				ADDOrUpdateEquation("@this.hi@", "@ParentSPC.hi@", Equation.CALCULATION_AUTO,equations) ;	
				
		
			
				ADDOrUpdateEquation("@this.posy@", "- @ParentSPC.epaisseurprincipale@ ", Equation.CALCULATION_AUTO,equations) ;				
				ADDOrUpdateEquation("@this.posx@", "- @ParentSPC.epaisseurprincipale@ ", Equation.CALCULATION_AUTO,equations) ;			
			}
		}
		else if(parent instanceof Cuisine && child instanceof CaissonCuisine) {
			CaissonCuisine caisson  = (CaissonCuisine)child;
			CuisineCaissonType caisstype = caisson.getCaissoncuisineType();
			FILL_CAISSONCUISINE(caisson, equations);
			ADDOrUpdateEquation("@this.li@", "@this.l@ - 2 * @this.epaisseurprincipale@ ", Equation.CALCULATION_AUTO,equations) ;				
			ADDOrUpdateEquation("@this.hi@", "@this.h@ - 2 * @this.epaisseurprincipale@ ", Equation.CALCULATION_AUTO,equations) ;
			switch (caisstype) {
			case Bas_four:
			case Bloc_Tiroir:
			case Porte_Boteille:
			case Porte_Pain:	
			case Bas:
				ADDOrUpdateEquation("@this.pi@", "@this.p@ - @retrait.bascaissoncuisine@", Equation.CALCULATION_AUTO,equations) ;

				break;
			case Bas_sousevier:
				ADDOrUpdateEquation("@this.pi@", "@this.p@ - @retrait.sousevier@", Equation.CALCULATION_AUTO,equations) ;

				break;
			case colonne:
				ADDOrUpdateEquation("@this.pi@", "@this.p@", Equation.CALCULATION_AUTO,equations) ;

					break;
			case haut:
				ADDOrUpdateEquation("@this.pi@", "@this.p@", Equation.CALCULATION_AUTO,equations) ;

				break;		
			default:
				break;
			}
		}
		else if(parent instanceof Dressing && child instanceof Caisson)
		{
			Caisson caisson  = (Caisson)child;
			Dressing dressing = (Dressing)parent;
			CaissonType caisstype = caisson.getCuissontype();
			PortType portType = caisson.getPorttype();
			switch (caisstype) {
			case EXTREME_DROITE:
				FILL_CAISSON_FROM_PARENT(dressing, equations);
				if(portType==PortType.FRANCAISE || portType==PortType.FRANCAISE2V || portType==PortType.COLISSANT)
				{
					ADDOrUpdateEquation("@this.l@", ""+caisson.getLongeurext(), Equation.CALCULATION_MANUAL,equations) ;				
					//Fromules de debitage
					ADDOrUpdateEquation("@this.h@", "@Parent.h@", Equation.CALCULATION_FIRST_AUTO,equations) ;
					ADDOrUpdateEquation("@this.p@", "@Parent.p@", Equation.CALCULATION_FIRST_AUTO,equations) ;

					
					ADDOrUpdateEquation("@this.li@", "@this.l@ - 2 * @Parent.epaisseurprincipale@ ", Equation.CALCULATION_AUTO,equations) ;				
					ADDOrUpdateEquation("@this.hi@", "@this.h@ - 2 * @Parent.epaisseurprincipale@ ", Equation.CALCULATION_AUTO,equations) ;
					if(portType==PortType.COLISSANT)
					{
						ADDOrUpdateEquation("@this.pi@", "@this.p@ -  @retrait.colissant@ ", Equation.CALCULATION_AUTO,equations) ;
					}
					else
					{
						ADDOrUpdateEquation("@this.pi@", "@this.p@", Equation.CALCULATION_AUTO,equations) ;
					}
					
					
					ADDOrUpdateEquation("@this.posx@", "@Parent.posx@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posy@", "@Parent.posy@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "@Parent.posz@", Equation.CALCULATION_AUTO,equations) ;
					
				}
				else
				{

					
				}

				break;
			case EXTREME_GAUCHE:
				FILL_CAISSON_FROM_PARENT(dressing, equations);
				if(portType==PortType.FRANCAISE || portType==PortType.FRANCAISE2V || portType==PortType.COLISSANT)
				{
					ADDOrUpdateEquation("@this.l@", ""+caisson.getLongeurext(), Equation.CALCULATION_MANUAL,equations) ;				
					//Fromules de debitage
					ADDOrUpdateEquation("@this.h@", "@Parent.h@", Equation.CALCULATION_FIRST_AUTO,equations) ;
					ADDOrUpdateEquation("@this.p@", "@Parent.p@", Equation.CALCULATION_FIRST_AUTO,equations) ;

					
					ADDOrUpdateEquation("@this.li@", "@this.l@ - 2 * @Parent.epaisseurprincipale@ ", Equation.CALCULATION_AUTO,equations) ;				
					ADDOrUpdateEquation("@this.hi@", "@this.h@ - 2 * @Parent.epaisseurprincipale@ ", Equation.CALCULATION_AUTO,equations) ;
					if(portType==PortType.COLISSANT)
					{
						ADDOrUpdateEquation("@this.pi@", "@this.p@ -  @retrait.colissant@ ", Equation.CALCULATION_AUTO,equations) ;
					}
					else
					{
						ADDOrUpdateEquation("@this.pi@", "@this.p@", Equation.CALCULATION_AUTO,equations) ;
					}
					
					ADDOrUpdateEquation("@this.posx@", "@Parent.posx@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posy@", "@Parent.posy@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "@Parent.posz@", Equation.CALCULATION_AUTO,equations) ;
					
				}
				else
				{

					
				}
				break;
			case MILIEU:
				FILL_CAISSON_FROM_PARENT(dressing, equations);
				if(portType==PortType.FRANCAISE || portType==PortType.FRANCAISE2V || portType==PortType.COLISSANT)
				{
					ADDOrUpdateEquation("@this.l@", ""+caisson.getLongeurext(), Equation.CALCULATION_MANUAL,equations) ;				
					//Fromules de debitage
					ADDOrUpdateEquation("@this.h@", "@Parent.h@", Equation.CALCULATION_FIRST_AUTO,equations) ;
					ADDOrUpdateEquation("@this.p@", "@Parent.p@", Equation.CALCULATION_FIRST_AUTO,equations) ;

					
					ADDOrUpdateEquation("@this.li@", "@this.l@ - 2 * @Parent.epaisseurprincipale@ ", Equation.CALCULATION_AUTO,equations) ;				
					ADDOrUpdateEquation("@this.hi@", "@this.h@ - 2 * @Parent.epaisseurprincipale@ ", Equation.CALCULATION_AUTO,equations) ;
					if(portType==PortType.COLISSANT)
					{
						ADDOrUpdateEquation("@this.pi@", "@this.p@ -   @retrait.colissant@ ", Equation.CALCULATION_AUTO,equations) ;
					}
					else
					{
						ADDOrUpdateEquation("@this.pi@", "@this.p@", Equation.CALCULATION_AUTO,equations) ;
					}
					
					ADDOrUpdateEquation("@this.posx@", "@Parent.posx@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posy@", "@Parent.posy@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "@Parent.posz@", Equation.CALCULATION_AUTO,equations) ;
					
				}
				else
				{

				}
				break;
				
			case MONO_CAISSON:
				FILL_CAISSON_FROM_PARENT(dressing, equations);
				if(portType==PortType.FRANCAISE || portType==PortType.FRANCAISE2V || portType==PortType.COLISSANT)
				{
					ADDOrUpdateEquation("@this.l@", ""+caisson.getLongeurext(), Equation.CALCULATION_MANUAL,equations) ;				
					//Fromules de debitage
					ADDOrUpdateEquation("@this.h@", "@Parent.h@", Equation.CALCULATION_FIRST_AUTO,equations) ;
					ADDOrUpdateEquation("@this.p@", "@Parent.p@", Equation.CALCULATION_FIRST_AUTO,equations) ;

					
					ADDOrUpdateEquation("@this.li@", "@this.l@ - 2 * @Parent.epaisseurprincipale@ ", Equation.CALCULATION_AUTO,equations) ;				
					ADDOrUpdateEquation("@this.hi@", "@this.h@ - 2 * @Parent.epaisseurprincipale@ ", Equation.CALCULATION_AUTO,equations) ;
					if(portType==PortType.COLISSANT)
					{
						ADDOrUpdateEquation("@this.pi@", "@this.p@ -   @retrait.colissant@ ", Equation.CALCULATION_AUTO,equations) ;
					}
					else
					{
						ADDOrUpdateEquation("@this.pi@", "@this.p@", Equation.CALCULATION_AUTO,equations) ;
					}
					
					ADDOrUpdateEquation("@this.posx@", "@Parent.posx@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posy@", "@Parent.posy@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "@Parent.posz@", Equation.CALCULATION_AUTO,equations) ;
					
				}
				else
				{

				}
				break;
			default:
				throw new DesignException(caisstype+" not found in debitage formula");
			}
		}
		else if(parent instanceof Project3D && child instanceof Dressing)
		{
			Dressing dress  = (Dressing)child;
			Project3D project = (Project3D)parent;
			FILL_DRESSING(dress, equations);
			ADDOrUpdateEquation("@this.li@", "@this.l@ - 2 * @this.epaisseurprincipale@ ", Equation.CALCULATION_AUTO,equations) ;				
			ADDOrUpdateEquation("@this.hi@", "@this.h@ - 2 * @this.epaisseurprincipale@ ", Equation.CALCULATION_AUTO,equations) ;
			ADDOrUpdateEquation("@this.pi@", "@this.p@ -  @this.epaisseursecondaire@ - @usin.dosRainurePositionOffset@", Equation.CALCULATION_AUTO,equations) ;						
		}else if(parent instanceof Project3D && child instanceof Cuisine)
		{
			Cuisine suisine  = (Cuisine)child;
			Project3D project = (Project3D)parent;
			FILL_CUISINE(suisine, equations);
			ADDOrUpdateEquation("@this.li@", "@this.l@", Equation.CALCULATION_AUTO,equations) ;				
			ADDOrUpdateEquation("@this.hi@", "@this.h@ ", Equation.CALCULATION_AUTO,equations) ;
			ADDOrUpdateEquation("@this.pi@", "@this.p@ ", Equation.CALCULATION_AUTO,equations) ;						
		}else if(parent instanceof Piece2D && child instanceof Rainure) {
//			RainureDebitageFormulas formulas= new RainureDebitageFormulas();
//			formulas.FILL_DEBITAGE_FORMULAS((Piece2D)parent, child, equations);

		//Imed bug	0001217: ajouter le calcul des rainure et les trous d'usinage
		}else if(parent instanceof Piece2D && child instanceof Trou) {
			TrouDebitageFormulas formulas= new TrouDebitageFormulas();
			formulas.FILL_DEBITAGE_FORMULAS((Piece2D)parent, child, equations);
			
		//Imed bug	0001217: ajouter le calcul des rainure et les trous d'usinage	
		}else if(parent instanceof Piece2D && child instanceof Charniere) {
			Piece2D piece=(Piece2D)parent;
			PieceType pieceType = piece.getPiecetype();
			Charniere charniere=(Charniere) child;
			CharniereType charniereType=charniere.getCharniereType();
			
			FILL_CHARNIERE_FROM_PIECE2D(piece, equations);
			if(charniere.isCalculAuto()) {
				switch (charniereType) {
				case BAS:
					ADDOrUpdateEquation("@this.posy@", "@usin.charnierehtrouretrait@ - @Parent.posy@", Equation.CALCULATION_MANUAL,equations) ;
					ADDOrUpdateEquation("@this.posz@", "@Parent.p@ - @usin.charniereptrouretrait@", Equation.CALCULATION_MANUAL,equations) ;
					break;
				case HAUT:
					ADDOrUpdateEquation("@this.posy@", "@PParent.h@ - @Parent.posy@ - @usin.charnierehtrouretrait@ ", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "@Parent.p@ - @usin.charniereptrouretrait@", Equation.CALCULATION_MANUAL,equations) ;

					break;
				case MILIEU:
					ADDOrUpdateEquation("@this.posy@", "(@PParent.h@ / 2) - @Parent.posy@", Equation.CALCULATION_AUTO,equations) ;
					ADDOrUpdateEquation("@this.posz@", "@Parent.p@ - @usin.charniereptrouretrait@", Equation.CALCULATION_MANUAL,equations) ;

					break;	
				default:
					throw new DesignException(" interdie d'inclue un rainue dans cette piece");
				}
				
			}else {
				FILL_CHARNIERE_FROM_MOTHER(charniere, equations);
				ADDOrUpdateEquation("@this.hretrait@", ""+charniere.getRetraitH(), Equation.CALCULATION_MANUAL,equations) ;
				ADDOrUpdateEquation("@this.pretrait@", ""+charniere.getRetraitP(), Equation.CALCULATION_MANUAL,equations) ;

				switch (charniereType) {
				case BAS:
					ADDOrUpdateEquation("@this.posy@", "@this.hretrait@ + @Mother.posyABS@ -@Parent.posyABS@", Equation.CALCULATION_MANUAL,equations) ;
					break;
				case HAUT:
					ADDOrUpdateEquation("@this.posy@", "@Mother.h@ - @this.hretrait@ + @Mother.posyABS@ -@Parent.posyABS@", Equation.CALCULATION_AUTO,equations) ;
					break;
				case MILIEU:
					ADDOrUpdateEquation("@this.posy@", "(@Mother.h@ / 2) + @Mother.posyABS@ -@Parent.posyABS@", Equation.CALCULATION_AUTO,equations) ;
					break;	
				default:
					throw new DesignException(" interdie d'inclue un rainue dans cette piece");
				}
				ADDOrUpdateEquation("@this.posz@", "@Parent.p@ - @this.pretrait@", Equation.CALCULATION_MANUAL,equations) ;

			}
			switch (pieceType) {
			case GAUCHE_CUISSON:
				ADDOrUpdateEquation("@this.posx@", "@Parent.l@", Equation.CALCULATION_MANUAL,equations) ;
				break;
			case DROITE_CUISSON:
				ADDOrUpdateEquation("@this.posx@", "0", Equation.CALCULATION_MANUAL,equations) ;
				break;
	
			default:
				throw new DesignException(" interdie d'inclue un rainue dans cette piece");
			}
			
			
		}//Imed bug	0001217: ajouter le calcul des rainure et les trous d'usinage	
		else if (parent instanceof Piece2D && child instanceof SupportPorteBoteille)
		{
			Piece2D piece = (Piece2D) parent;
			PieceType pieceType = piece.getPiecetype();
			SupportPorteBoteille support = (SupportPorteBoteille) child;
			SupportPorteBoteilleType supportType = support.getSupportType();

			FILL_CHARNIERE_FROM_PIECE2D(piece, equations);
			switch (supportType) {
			case BAS:
				ADDOrUpdateEquation("@this.posy@", "@usin.SupportPorteBoteillehtrouretrait@",Equation.CALCULATION_MANUAL, equations);
				ADDOrUpdateEquation("@this.posz@", "@Parent.p@ - @usin.SupportPorteBoteilleprof@",Equation.CALCULATION_MANUAL, equations);
				break;
			case HAUT:
				ADDOrUpdateEquation("@this.posy@", "@usin.SupportPorteBoteillehautHretrait@",Equation.CALCULATION_AUTO, equations);
				ADDOrUpdateEquation("@this.posz@", "@Parent.p@ - @usin.SupportPorteBoteilleprof@",Equation.CALCULATION_MANUAL, equations);

				break;
			default:
				throw new DesignException(" interdie d'inclue un rainue dans cette piece");
			}
			switch (pieceType) {
			case GAUCHE_CUISSON:
				ADDOrUpdateEquation("@this.posx@", "@Parent.l@", Equation.CALCULATION_MANUAL, equations);
				break;
			case DROITE_CUISSON:
				ADDOrUpdateEquation("@this.posx@", "0", Equation.CALCULATION_MANUAL, equations);
				break;

			default:
				throw new DesignException(" interdie d'inclue un rainue dans cette piece");
			}
			

			ADDOrUpdateEquation("@this.l@", "0", Equation.CALCULATION_MANUAL,equations) ;				
			ADDOrUpdateEquation("@this.h@", "0", Equation.CALCULATION_FIRST_AUTO,equations) ;
			ADDOrUpdateEquation("@this.p@", "@usin.SupportPorteBoteilleprof@ - @usin.SupportPorteBoteilleptrouretrait@", Equation.CALCULATION_FIRST_AUTO,equations) ;	
			
			ADDOrUpdateEquation("@this.li@", "@this.l@ ", Equation.CALCULATION_AUTO,equations) ;				
			ADDOrUpdateEquation("@this.hi@", "@this.h@ ", Equation.CALCULATION_AUTO,equations) ;
			ADDOrUpdateEquation("@this.pi@", "@this.p@ ", Equation.CALCULATION_FIRST_AUTO,equations) ;

		}
		//Imed bug	0001866: ajouter les support pour les caisson bas 
		else if(parent instanceof Piece2D && child instanceof SupportMeubleBas) {
			SuportBasDebitageFormulas formulas= new SuportBasDebitageFormulas();
			formulas.FILL_DEBITAGE_FORMULAS((Piece2D)parent, child, equations);
					
		}
		//Imed bug	0001866: ajouter  les support de fixation pour les caisson haut	
		else if(parent instanceof Piece2D && child instanceof SupportMeubleHaut) {
			SuportHautDebitageFormulas formulas= new SuportHautDebitageFormulas();
			formulas.FILL_DEBITAGE_FORMULAS((Piece2D)parent, child, equations);
					
		}else if(parent instanceof Piece2D && child instanceof Cavity) {
			Piece2D piece=(Piece2D) parent;
			Cavity c1=(Cavity) child;
			Accessoire mother=(Accessoire) c1.getMother(); 
			if((piece.getPiecetype().equals(PieceType.DOS_INTERIEUR)||piece.getPiecetype().equals(PieceType.DOS_EXTERIRUR))
					&& mother instanceof SupportMeubleHaut) {
				ADDOrUpdateEquation("@this.l@", ""+mother.getLongeurext(), Equation.CALCULATION_MANUAL,equations) ;
				ADDOrUpdateEquation("@this.p@", ""+piece.getProfondeurext(), Equation.CALCULATION_MANUAL,equations) ;
				ADDOrUpdateEquation("@this.h@", ""+mother.getHauteurext(), Equation.CALCULATION_MANUAL,equations) ;
				//
				ADDOrUpdateEquation("@this.li@", ""+mother.getLongeurint(), Equation.CALCULATION_MANUAL,equations) ;
				ADDOrUpdateEquation("@this.pi@", ""+piece.getProfondeurint(), Equation.CALCULATION_MANUAL,equations) ;
				ADDOrUpdateEquation("@this.hi@", ""+mother.getHauteurint(), Equation.CALCULATION_MANUAL,equations) ;
				//
				ADDOrUpdateEquation("@this.posx@", ""+mother.getXpos(), Equation.CALCULATION_MANUAL,equations) ;
				ADDOrUpdateEquation("@this.posy@", ""+mother.getYpos(), Equation.CALCULATION_MANUAL,equations) ;
				ADDOrUpdateEquation("@this.posz@", ""+mother.getZpos(), Equation.CALCULATION_MANUAL,equations) ;
				
			}else
			{
				throw new DesignException("cavity sur un piece autre q'un Dos est non supporter");
			}
		}
		
		else
		{
			throw new DesignException("Unkown Debitage Formula");
		}
		
		FILL_CONSTARAINTS(equations);
	}
	//Imed bug 0001217 charger les mesure et les positions nécessaire du parent pour calculer les positions de charnière
	protected void FILL_CHARNIERE_FROM_PIECE2D(Piece2D piece2d,ArrayList<Equation> equations) {
		ADDOrUpdateEquation("@Parent.l@", ""+piece2d.getLongeurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.p@", ""+piece2d.getProfondeurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.h@", ""+piece2d.getHauteurext(), Equation.CALCULATION_MANUAL,equations) ;
		//
		ADDOrUpdateEquation("@Parent.li@", ""+piece2d.getLongeurint(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.pi@", ""+piece2d.getProfondeurint(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.hi@", ""+piece2d.getHauteurint(), Equation.CALCULATION_MANUAL,equations) ;
		//
		ADDOrUpdateEquation("@Parent.epaisseursecondaire@", ""+piece2d.getBackmaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.epaisseurprincipale@", ""+piece2d.getBasematerial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
		//
		ADDOrUpdateEquation("@Parent.posx@", ""+piece2d.getXpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.posy@", ""+piece2d.getYpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.posz@", ""+piece2d.getZpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@PParent.h@", ""+piece2d.getRootCaisson().getHauteurext(), Equation.CALCULATION_MANUAL,equations) ;
		//
		ADDOrUpdateEquation("@Parent.posxABS@", ""+piece2d.getXPosABS(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.posyABS@", ""+piece2d.getYPosABS(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.poszABS@", ""+piece2d.getZPosABS(), Equation.CALCULATION_MANUAL,equations) ;

	}
	protected void FILL_CHARNIERE_FROM_MOTHER(Charniere charniere,ArrayList<Equation> equations) throws DesignException {
		DesignObject3D mother= charniere.getMother();
		if(mother==null || !(mother instanceof Space3D)) {
			throw new DesignException("impossible d'accepter un charniere avec mother null");
		}
		ADDOrUpdateEquation("@Mother.l@", ""+mother.getLongeurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Mother.p@", ""+mother.getProfondeurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Mother.h@", ""+mother.getHauteurext(), Equation.CALCULATION_MANUAL,equations) ;
		//
		ADDOrUpdateEquation("@Mother.li@", ""+mother.getLongeurint(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Mother.pi@", ""+mother.getProfondeurint(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Mother.hi@", ""+mother.getHauteurint(), Equation.CALCULATION_MANUAL,equations) ;
		//
		ADDOrUpdateEquation("@Mother.epaisseursecondaire@", ""+mother.getBackmaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Mother.epaisseurprincipale@", ""+mother.getBasematerial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
		//
		ADDOrUpdateEquation("@Mother.posx@", ""+mother.getXpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Mother.posy@", ""+mother.getYpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Mother.posz@", ""+mother.getZpos(), Equation.CALCULATION_MANUAL,equations) ;
		//
		ADDOrUpdateEquation("@Mother.posxABS@", ""+mother.getXPosABS(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Mother.posyABS@", ""+mother.getYPosABS(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Mother.poszABS@", ""+mother.getZPosABS(), Equation.CALCULATION_MANUAL,equations) ;

	}

	
	protected  void FILL_PIECE2D_FROM_PARENT(Space3D space3d,ArrayList<Equation> equations)
	{
		ADDOrUpdateEquation("@Parent.l@", ""+space3d.getLongeurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.h@", ""+space3d.getHauteurext(), Equation.CALCULATION_MANUAL,equations);
		ADDOrUpdateEquation("@Parent.p@", ""+space3d.getProfondeurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.li@", ""+space3d.getLongeurint(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.hi@", ""+space3d.getHauteurint(), Equation.CALCULATION_MANUAL,equations);
		ADDOrUpdateEquation("@Parent.pi@", ""+space3d.getProfondeurint(), Equation.CALCULATION_MANUAL,equations) ;				
		ADDOrUpdateEquation("@Parent.posx@", ""+space3d.getXpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.posy@", ""+space3d.getYpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.posz@", ""+space3d.getZpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.epaisseurprincipale@", ""+space3d.getBasematerial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.epaisseursecondaire@", ""+space3d.getBackmaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;		
//		
		
	}
	private  void FILL_SEPRATOR_FROM_SPACE3d(Space3D space,ArrayList<Equation> equations)
	{
		ADDOrUpdateEquation("@Parent.l@", ""+space.getLongeurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.h@", ""+space.getHauteurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.p@", ""+space.getProfondeurext(), Equation.CALCULATION_MANUAL,equations) ;				
		ADDOrUpdateEquation("@Parent.li@", ""+space.getLongeurint(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.hi@", ""+space.getHauteurint(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.pi@", ""+space.getProfondeurint(), Equation.CALCULATION_MANUAL,equations) ;				
		ADDOrUpdateEquation("@Parent.posx@", ""+space.getXpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.posy@", ""+space.getYpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.posz@", ""+space.getZpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.epaisseurprincipale@", ""+space.getBasematerial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.epaisseursecondaire@", ""+space.getBackmaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;		
		
		
	}
	private  void FILL_SPACE3D_FROM_Seprator(Separator sep,ArrayList<Equation> equations)
	{

		ADDOrUpdateEquation("@ParentSPC.l@", ""+sep.getParentspace().getLongeurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@ParentSPC.h@", ""+sep.getParentspace().getHauteurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@ParentSPC.p@", ""+sep.getParentspace().getProfondeurext(), Equation.CALCULATION_MANUAL,equations) ;				
		ADDOrUpdateEquation("@ParentSPC.li@", ""+sep.getParentspace().getLongeurint(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@ParentSPC.hi@", ""+sep.getParentspace().getHauteurint(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@ParentSPC.pi@", ""+sep.getParentspace().getProfondeurint(), Equation.CALCULATION_MANUAL,equations) ;				
		ADDOrUpdateEquation("@ParentSPC.posx@", ""+sep.getParentspace().getXpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@ParentSPC.posy@", ""+sep.getParentspace().getYpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@ParentSPC.posz@", ""+sep.getParentspace().getZpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@ParentSPC.epaisseurprincipale@", ""+sep.getParentspace().getBasematerial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@ParentSPC.epaisseursecondaire@", ""+sep.getParentspace().getBackmaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;		
		ADDOrUpdateEquation("@Sep.l@", ""+sep.getLongeurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Sep.h@", ""+sep.getHauteurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Sep.p@", ""+sep.getProfondeurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Sep.position@", ""+sep.getSepposition() , Equation.CALCULATION_MANUAL,equations) ;		
		ADDOrUpdateEquation("@Sep.posy@", ""+sep.getYpos() , Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Sep.posx@", ""+sep.getXpos() , Equation.CALCULATION_MANUAL,equations) ;	
		ADDOrUpdateEquation("@Sep.posz@", ""+sep.getZpos() , Equation.CALCULATION_MANUAL,equations) ;	
		ADDOrUpdateEquation("@Sep.e@", ""+sep.getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
		
	}
	protected  void FILL_PIECE2D(Piece2D piece,ArrayList<Equation> equations)
	{
		ADDOrUpdateEquation("@this.hi@", "@this.h@", Equation.CALCULATION_AUTO,equations) ;
		ADDOrUpdateEquation("@this.pi@", "@this.p@", Equation.CALCULATION_AUTO,equations) ;
		ADDOrUpdateEquation("@this.li@", "@this.l@", Equation.CALCULATION_AUTO,equations) ;

	}
	private  void FILL_CAISSON_FROM_PARENT(Dressing dress,ArrayList<Equation> equations)
	{
		ADDOrUpdateEquation("@Parent.h@", ""+dress.getHauteurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.p@", ""+dress.getProfondeurext(), Equation.CALCULATION_MANUAL,equations) ;								
		ADDOrUpdateEquation("@Parent.posx@", ""+dress.getXpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.posy@", ""+dress.getYpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.posz@", ""+dress.getZpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.epaisseurprincipale@", ""+dress.getBasematerial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@Parent.epaisseursecondaire@", ""+dress.getBackmaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;		
		
	}
	protected  void FILL_CAISSONCUISINE(CaissonCuisine Caisson,ArrayList<Equation> equations)
	{
		ADDOrUpdateEquation("@this.h@", ""+Caisson.getHauteurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@this.p@", ""+Caisson.getProfondeurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@this.l@", ""+Caisson.getLongeurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@this.posx@", ""+Caisson.getXpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@this.posy@", ""+Caisson.getYpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@this.posz@", ""+Caisson.getZpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@this.epaisseurprincipale@", ""+Caisson.getBasematerial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@this.epaisseursecondaire@", ""+Caisson.getBackmaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;		
		
	}
	
	private  void FILL_DRESSING(Dressing dress,ArrayList<Equation> equations)
	{
		ADDOrUpdateEquation("@this.l@", ""+dress.getLongeurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@this.h@", ""+dress.getHauteurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@this.p@", ""+dress.getProfondeurext(), Equation.CALCULATION_MANUAL,equations) ;								
		ADDOrUpdateEquation("@this.posx@", ""+dress.getXpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@this.posy@", ""+dress.getYpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@this.posz@", ""+dress.getZpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@this.epaisseurprincipale@", ""+dress.getBasematerial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@this.epaisseursecondaire@", ""+dress.getBackmaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;		
		
	}
	private  void FILL_CUISINE(Cuisine cuisne,ArrayList<Equation> equations)
	{
		ADDOrUpdateEquation("@this.l@", ""+cuisne.getLongeurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@this.h@", ""+cuisne.getHauteurext(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@this.p@", ""+cuisne.getProfondeurext(), Equation.CALCULATION_MANUAL,equations) ;								
		ADDOrUpdateEquation("@this.posx@", ""+cuisne.getXpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@this.posy@", ""+cuisne.getYpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@this.posz@", ""+cuisne.getZpos(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@this.epaisseurprincipale@", ""+cuisne.getBasematerial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@this.epaisseursecondaire@", ""+cuisne.getBackmaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations) ;		
		
	}
	private  void FILL_CONSTARAINTS(ArrayList<Equation> equations)
	{

		ADDOrUpdateEquation("@cst.mincaissonHI@", ""+DressingCreator.MIN_CUISSON_HAUTEUR_INTERNE, Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@cst.mincaissonLI@", ""+DressingCreator.MIN_CUISSON_LONGEUR_INTERNE, Equation.CALCULATION_MANUAL,equations) ;								
		ADDOrUpdateEquation("@cst.mincaissonPI@", ""+DressingCreator.MIN_CUISSON_PROFONDEUR_INTERNE, Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@cst.minInterDistance@", ""+DressingCreator.MIN_ETAGERE_INTER_DISTANCE, Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@cst.minH@", ""+DressingCreator.MIN_HAUTEUR, Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@cst.minP@", ""+DressingCreator.MIN_PROFONDEUR, Equation.CALCULATION_MANUAL,equations) ;
		ADDOrUpdateEquation("@cst.maxPorteLongeur@", ""+DressingCreator.PORT_MAX_LONGEUR, Equation.CALCULATION_MANUAL,equations) ;
		
	

	}
	protected  void FILL_USINAGE(DesignObject3D parent,DesignObject3D child, ArrayList<Equation> equations)
	{

//		ADDOrUpdateEquation("@usin.jeuEtagereMobile@", ""+DressingCreator.ETAGERE_MOBILE_JEU , Equation.CALCULATION_MANUAL,equations) ;
//		ADDOrUpdateEquation("@usin.dosRainureProf@", ""+DressingCreator.RAINURE_DOS_DEPTH , Equation.CALCULATION_MANUAL,equations) ;
//		ADDOrUpdateEquation("@usin.porteJeu@", ""+DressingCreator.PORT_JEU , Equation.CALCULATION_MANUAL,equations) ;
//		ADDOrUpdateEquation("@usin.dosRainurePositionOffset@", ""+DressingCreator.RAINURE_DOS_POSITION_OFFSET , Equation.CALCULATION_MANUAL,equations) ;
//
//		ADDOrUpdateEquation("@usin.tiroirJeuCote@",""+UsinageParam.TIROIR_COTE_JEU_EXTERIEUR,Equation.CALCULATION_MANUAL,equations);
//		ADDOrUpdateEquation("@usin.tiroirRainureCote@",""+UsinageParam.TIROIR_COTE_RAINURE,Equation.CALCULATION_MANUAL,equations);
//		ADDOrUpdateEquation("@usin.tiroirjeuDeriere@",""+UsinageParam.TIROIR_DERIERE_JEU_EXTERIEUR,Equation.CALCULATION_MANUAL,equations);
//		ADDOrUpdateEquation("@usin.tiroirderiereRainure@",""+UsinageParam.TIROIR_DERIERE_RAINURE,Equation.CALCULATION_MANUAL,equations);
//		ADDOrUpdateEquation("@usin.tiroirjeuFacadeCote@",""+UsinageParam.DELTA_A,Equation.CALCULATION_MANUAL,equations);
//		ADDOrUpdateEquation("@usin.tiroirjeuFacadeBH@",""+UsinageParam.DELTA_B,Equation.CALCULATION_MANUAL,equations);
		if(child!=null&& child.getParams()!=null&& child.getParams().size()>0) {
			FILL_USINAGE(child.getParams(),equations);
		}else if(parent!=null&& parent.getParams()!=null&& parent.getParams().size()>0) {
			FILL_USINAGE(parent.getParams(),equations);
		}else {
			boolean executed=false; 
			DesignObject3D parentdesign=parent;
			while(parentdesign!=null && !(parentdesign instanceof Project3D)) {
				if(parentdesign!=null&& parentdesign.getParams()!=null&& parentdesign.getParams().size()>0) {
					FILL_USINAGE(parentdesign.getParams(),equations);
					executed=true;
					break;
				}else {
					parentdesign=parentdesign.getParentdesign();
					
				}
			}
			
			if(executed==false) {
				if(parentdesign!=null&& parentdesign instanceof Project3D
						&& parentdesign.getParams()!=null&& parentdesign.getParams().size()>0){
					FILL_USINAGE(parentdesign.getParams(),equations);
					executed=true;
				}else {
					FILL_USINAGE(ModelProvider.getListParam(),equations);
				}
			}
		}
		
	}
	private void FILL_USINAGE(ArrayList<dressing.model.Parameters> listParam,ArrayList<Equation> equations) {
		if(listParam!=null) {
			for(dressing.model.Parameters param:listParam) {
				if(param!=null&& param.getCode()!=null&& param.getValue()!=null) {
					ADDOrUpdateEquation(param.getCode(),param.getValue() ,Equation.CALCULATION_MANUAL,equations);
				}
				
			}
		}
		
	}

	private void ChaeckorUpdateSepTranseversale(Space3D parent,Separator separator, ArrayList<Equation> equations) throws DesignException {
		if(parent==null ) {
			throw new DesignException("il faut assigné le parent de ce separator");
		}
		ADDOrUpdateEquation("@this.e@", "" + separator.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations);
		ADDOrUpdateEquation("@this.sepretrait@", "" + separator.getSepRetrait(), Equation.CALCULATION_MANUAL,equations);
		ADDOrUpdateEquation("@this.sepretraitderiere@", "" + separator.getSepretraitderiere(), Equation.CALCULATION_MANUAL,equations);
		if (separator.getSepaxe().equals(SeprationAxe.YAXIS)) {
			if(separator.getIsSepIsometrique()) {
				ADDOrUpdateEquation("@this.sepposition@", "(@Parent.hi@ - @this.e@)/2" , Equation.CALCULATION_MANUAL,
						equations);
			}else if(separator.getPosclaculationtype().equals(PositionCalculationType.POURCENT)){
				ADDOrUpdateEquation("@this.seppourcentposition@", "" + separator.getSepposition(), Equation.CALCULATION_MANUAL,
						equations);
				ADDOrUpdateEquation("@this.sepposition@", "( ( (@Parent.hi@ - @this.e@) * @this.seppourcentposition@ ) / 100 )", Equation.CALCULATION_MANUAL,
						equations);
			}else {
				ADDOrUpdateEquation("@this.sepposition@", "" + separator.getSepposition(), Equation.CALCULATION_MANUAL,
						equations);
			}
		}	else if (separator.getSepaxe().equals(SeprationAxe.XAXIS)) {
			if(separator.getIsSepIsometrique()) {
				ADDOrUpdateEquation("@this.sepposition@", "(@Parent.li@ - @this.e@)/2" , Equation.CALCULATION_MANUAL,
						equations);
			}else if(separator.getPosclaculationtype().equals(PositionCalculationType.POURCENT)){
				ADDOrUpdateEquation("@this.seppourcentposition@", "" + separator.getSepposition(), Equation.CALCULATION_MANUAL,
						equations);
				ADDOrUpdateEquation("@this.sepposition@", "( ( (@Parent.li@ - @this.e@) * @this.seppourcentposition@ ) / 100 )", Equation.CALCULATION_MANUAL,
						equations);
			}
			else {
				ADDOrUpdateEquation("@this.sepposition@", "" + separator.getSepposition(), Equation.CALCULATION_MANUAL,
						equations);
			}
		} else {
			if(separator.getIsSepIsometrique()) {
				ADDOrUpdateEquation("@this.sepposition@", "(@Parent.pi@ - @this.e@)/2" , Equation.CALCULATION_MANUAL,
						equations);
			}else if(separator.getPosclaculationtype().equals(PositionCalculationType.POURCENT)){
				ADDOrUpdateEquation("@this.seppourcentposition@", "" + separator.getSepposition(), Equation.CALCULATION_MANUAL,
						equations);
				ADDOrUpdateEquation("@this.sepposition@", "( ( (@Parent.pi@ - @this.e@) * @this.seppourcentposition@ ) / 100 )", Equation.CALCULATION_MANUAL,
						equations);
			}else {
				ADDOrUpdateEquation("@this.sepposition@", "" + separator.getSepposition(), Equation.CALCULATION_MANUAL,
						equations);
			}
		}
		if(separator.getPosRefType() == null) {
			throw new DesignException("il faut assigné le reference de position de ce separator");
		}

		// Fromules de debitage
		// Horizonatle
		if (separator.getSepaxe().equals(SeprationAxe.YAXIS)) {
			ADDOrUpdateEquation("@this.h@", "@this.e@", Equation.CALCULATION_AUTO, equations);
			ADDOrUpdateEquation("@this.p@", "@Parent.pi@ - @this.sepretrait@ - @this.sepretraitderiere@", Equation.CALCULATION_AUTO, equations);
			ADDOrUpdateEquation("@this.l@", "@Parent.li@", Equation.CALCULATION_AUTO, equations);
			ADDOrUpdateEquation("@this.posx@", "@Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,
					equations);
			if(separator.getPosRefType().equals(PositionReferenceType.HAUT)) {
				ADDOrUpdateEquation("@this.posy@", "@Parent.hi@ - @this.sepposition@ -@this.e@ + @Parent.epaisseurprincipale@  ",
						Equation.CALCULATION_AUTO, equations);
			}else {
				ADDOrUpdateEquation("@this.posy@", "@this.sepposition@ + @Parent.epaisseurprincipale@ ",
						Equation.CALCULATION_AUTO, equations);
			}
		
			ADDOrUpdateEquation("@this.posz@", "@this.sepretraitderiere@", Equation.CALCULATION_AUTO, equations);
			ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,
					equations);
			ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,
					equations);
			
			
			FILL_CHANT_DIM("@this.l@","@this.p@","@this.l@","@this.p@",equations);
			FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","0","@ep.deuxmm@","0",equations);
			
			
		}
		// verticale
		else if (separator.getSepaxe().equals(SeprationAxe.XAXIS)) {
			ADDOrUpdateEquation("@this.l@", "@this.e@", Equation.CALCULATION_AUTO, equations);
			ADDOrUpdateEquation("@this.p@", "@Parent.pi@ - @this.sepretrait@ - @this.sepretraitderiere@", Equation.CALCULATION_AUTO, equations);
			ADDOrUpdateEquation("@this.h@", "@Parent.hi@", Equation.CALCULATION_AUTO, equations);
			if(separator.getPosRefType().equals(PositionReferenceType.HAUT)) {
				ADDOrUpdateEquation("@this.posx@", "@Parent.li@ - @this.sepposition@ -@this.e@ + @Parent.epaisseurprincipale@  ",
						Equation.CALCULATION_AUTO, equations);
			}else {
				ADDOrUpdateEquation("@this.posx@", "@this.sepposition@ + @Parent.epaisseurprincipale@ ",
						Equation.CALCULATION_AUTO, equations);
			}
			ADDOrUpdateEquation("@this.posy@", "@Parent.epaisseurprincipale@ ", Equation.CALCULATION_AUTO,
					equations);
			ADDOrUpdateEquation("@this.posz@", "@this.sepretraitderiere@", Equation.CALCULATION_AUTO, equations);
			ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.p@,@this.h@)", Equation.CALCULATION_AUTO,
					equations);
			ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.p@,@this.h@)", Equation.CALCULATION_AUTO,
					equations);
			
			FILL_CHANT_DIM("@this.h@","@this.p@","@this.h@","@this.p@",equations);
			FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","0","@ep.deuxmm@","0",equations);
			
		} else if(separator.getSepaxe().equals(SeprationAxe.ZAXIS)){
			ADDOrUpdateEquation("@this.l@", "@Parent.li@", Equation.CALCULATION_AUTO, equations);
			ADDOrUpdateEquation("@this.p@", "@this.e@", Equation.CALCULATION_AUTO, equations);
			ADDOrUpdateEquation("@this.h@", "@Parent.hi@", Equation.CALCULATION_AUTO, equations);
			ADDOrUpdateEquation("@this.posx@", "@Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,
					equations);
			ADDOrUpdateEquation("@this.posy@", "@Parent.epaisseurprincipale@ ", Equation.CALCULATION_AUTO,
					equations);
			if(separator.getPosRefType().equals(PositionReferenceType.HAUT)) {
				ADDOrUpdateEquation("@this.posz@", "@Parent.pi@ - @this.sepposition@ -@this.e@",
						Equation.CALCULATION_AUTO, equations);
			}else {
				ADDOrUpdateEquation("@this.posz@", "@this.sepposition@ ",
						Equation.CALCULATION_AUTO, equations);
			}
			ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.l@,@this.h@)", Equation.CALCULATION_AUTO,
					equations);
			ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.l@,@this.h@)", Equation.CALCULATION_AUTO,
					equations);
			
			FILL_CHANT_DIM("0","0","0","0",equations);
			FILL_CHANT_EPAISSEUR("0","0","0","0",equations);
			
		}

		FILL_PIECE2D(separator, equations);

	}
	private void ChaeckorUpdateSepNormale(Space3D parent,Separator separator, ArrayList<Equation> equations) throws DesignException {
		if(parent==null ) {
			throw new DesignException("il faut assigné le parent de ce separator");
		}
		if(separator==null ) {
			throw new DesignException("il faut insérée ce separator");
		}
		ADDOrUpdateEquation("@this.e@", "" + separator.getMaterial().getEpaisseur(), Equation.CALCULATION_MANUAL,equations);
		ADDOrUpdateEquation("@this.sepretrait@", "" + separator.getSepRetrait(), Equation.CALCULATION_MANUAL,equations);
		ADDOrUpdateEquation("@this.sepretraitderiere@", "" + separator.getSepretraitderiere(), Equation.CALCULATION_MANUAL,equations);
		if (separator.getSepaxe().equals(SeprationAxe.YAXIS)) {
			if(separator.getIsSepIsometrique()) {
				ADDOrUpdateEquation("@this.sepposition@", "(@Parent.hi@ - @this.e@)/2" , Equation.CALCULATION_MANUAL,
						equations);
			}else if(separator.getPosclaculationtype().equals(PositionCalculationType.POURCENT)){
				ADDOrUpdateEquation("@this.seppourcentposition@", "" + separator.getSepposition(), Equation.CALCULATION_MANUAL,
						equations);
				ADDOrUpdateEquation("@this.sepposition@", "( ( (@Parent.hi@ - @this.e@) * @this.seppourcentposition@ ) / 100 )", Equation.CALCULATION_MANUAL,
						equations);
			}else {
				ADDOrUpdateEquation("@this.sepposition@", "" + separator.getSepposition(), Equation.CALCULATION_MANUAL,
						equations);
			}
		}	else if (separator.getSepaxe().equals(SeprationAxe.XAXIS)) {
			if(separator.getIsSepIsometrique()) {
				ADDOrUpdateEquation("@this.sepposition@", "(@Parent.li@ - @this.e@)/2" , Equation.CALCULATION_MANUAL,
						equations);
			}else if(separator.getPosclaculationtype().equals(PositionCalculationType.POURCENT)){
				ADDOrUpdateEquation("@this.seppourcentposition@", "" + separator.getSepposition(), Equation.CALCULATION_MANUAL,
						equations);
				ADDOrUpdateEquation("@this.sepposition@", "( ( (@Parent.li@ - @this.e@) * @this.seppourcentposition@ ) / 100 )", Equation.CALCULATION_MANUAL,
						equations);
			}
			else {
				ADDOrUpdateEquation("@this.sepposition@", "" + separator.getSepposition(), Equation.CALCULATION_MANUAL,
						equations);
			}
		} else {
			if(separator.getIsSepIsometrique()) {
				ADDOrUpdateEquation("@this.sepposition@", "(@Parent.pi@ - @this.e@)/2" , Equation.CALCULATION_MANUAL,
						equations);
			}else if(separator.getPosclaculationtype().equals(PositionCalculationType.POURCENT)){
				ADDOrUpdateEquation("@this.seppourcentposition@", "" + separator.getSepposition(), Equation.CALCULATION_MANUAL,
						equations);
				ADDOrUpdateEquation("@this.sepposition@", "( ( (@Parent.pi@ - @this.e@) * @this.seppourcentposition@ ) / 100 )", Equation.CALCULATION_MANUAL,
						equations);
			}else {
				ADDOrUpdateEquation("@this.sepposition@", "" + separator.getSepposition(), Equation.CALCULATION_MANUAL,
						equations);
			}
		}
		if(separator.getPosRefType() == null) {
			throw new DesignException("il faut assigné le reference de position de ce separator");
		}
		// Fromules de debitage
		// Horizonatle
		if (separator.getSepaxe().equals(SeprationAxe.YAXIS)) {
			ADDOrUpdateEquation("@this.h@", "@this.e@", Equation.CALCULATION_AUTO, equations);
			ADDOrUpdateEquation("@this.l@", "@Parent.li@", Equation.CALCULATION_AUTO, equations);
			Boolean isParentHasDos=false;
			for(DesignObject3D piece:parent.getChilds()) {
				if(((Piece2D)piece).getPiecetype().equals(PieceType.DOS_INTERIEUR)) {
					isParentHasDos=true;
				}
			}
			if((!isParentHasDos )&& parent.getParentdesign()!=null && parent.getParentdesign()  instanceof Separator  ) {
				ADDOrUpdateEquation("@this.posz@", "@this.sepretraitderiere@", Equation.CALCULATION_AUTO, equations);
				ADDOrUpdateEquation("@this.p@", "@Parent.pi@ - @this.sepretrait@-@this.sepretraitderiere@", Equation.CALCULATION_AUTO, equations);

			}else
			{
				ADDOrUpdateEquation("@this.posz@", "@usin.dosRainurePositionOffset@ + @Parent.epaisseursecondaire@ + @usin.jeurainuredos@ + @this.sepretraitderiere@", Equation.CALCULATION_AUTO, equations);
				ADDOrUpdateEquation("@this.p@", "@Parent.pi@ - @this.sepretrait@ - @this.sepretraitderiere@ - @usin.dosRainurePositionOffset@ - @Parent.epaisseursecondaire@ - @usin.jeurainuredos@", Equation.CALCULATION_AUTO, equations);
			}
			if(separator.getPosRefType().equals(PositionReferenceType.HAUT)) {
				ADDOrUpdateEquation("@this.posy@", "@Parent.hi@ - @this.sepposition@ -@this.e@ + @Parent.epaisseurprincipale@  ",
						Equation.CALCULATION_AUTO, equations);
			}else {
				ADDOrUpdateEquation("@this.posy@", "@this.sepposition@ + @Parent.epaisseurprincipale@ ",
						Equation.CALCULATION_AUTO, equations);
			}
			ADDOrUpdateEquation("@this.posx@", "@Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations);
			ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations);
			ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.p@,@this.l@)", Equation.CALCULATION_AUTO,equations);
			
			//
			FILL_CHANT_DIM("@this.l@","@this.p@","@this.l@","@this.p@",equations);
			FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","0","@ep.deuxmm@","0",equations);
			//
		}
		// verticale
		else if (separator.getSepaxe().equals(SeprationAxe.XAXIS)) {
			ADDOrUpdateEquation("@this.l@", "@this.e@", Equation.CALCULATION_AUTO, equations);
			ADDOrUpdateEquation("@this.h@", "@Parent.hi@", Equation.CALCULATION_AUTO, equations);
			Boolean isParentHasDos=false;
			for(DesignObject3D piece:parent.getChilds()) {
				if(((Piece2D)piece).getPiecetype().equals(PieceType.DOS_INTERIEUR)) {
					isParentHasDos=true;
				}
			}
			if((!isParentHasDos )&& parent.getParentdesign()!=null && parent.getParentdesign()  instanceof Separator  ) {
				ADDOrUpdateEquation("@this.posz@", "@this.sepretraitderiere@", Equation.CALCULATION_AUTO, equations);
				ADDOrUpdateEquation("@this.p@", "@Parent.pi@ - @this.sepretraitderiere@ - @this.sepretrait@ ", Equation.CALCULATION_AUTO, equations);

			}else
			{
				ADDOrUpdateEquation("@this.posz@", "@usin.dosRainurePositionOffset@ + @Parent.epaisseursecondaire@ + @usin.jeurainuredos@ + @this.sepretraitderiere@", Equation.CALCULATION_AUTO, equations);
				ADDOrUpdateEquation("@this.p@", "@Parent.pi@ - @this.sepretrait@ - @this.sepretraitderiere@ - @usin.dosRainurePositionOffset@ - @Parent.epaisseursecondaire@ - @usin.jeurainuredos@", Equation.CALCULATION_AUTO, equations);
			}
			if(separator.getPosRefType().equals(PositionReferenceType.HAUT)) {
				ADDOrUpdateEquation("@this.posx@", "@Parent.li@ - @this.sepposition@ -@this.e@ + @Parent.epaisseurprincipale@  ",
						Equation.CALCULATION_AUTO, equations);
			}else {
				ADDOrUpdateEquation("@this.posx@", "@this.sepposition@ + @Parent.epaisseurprincipale@ ",
						Equation.CALCULATION_AUTO, equations);
			}
			ADDOrUpdateEquation("@this.posy@", "@Parent.epaisseurprincipale@ ", Equation.CALCULATION_AUTO,equations);
			ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.p@,@this.h@)", Equation.CALCULATION_AUTO,equations);
			ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.p@,@this.h@)", Equation.CALCULATION_AUTO,equations);
			
			//
			FILL_CHANT_DIM("@this.h@","@this.p@","@this.h@","@this.p@",equations);
			FILL_CHANT_EPAISSEUR("@ep.quatdixieme@","0","@ep.deuxmm@","0",equations);
			//
			
			//interieur
		} else {
			ADDOrUpdateEquation("@this.l@", "@Parent.li@", Equation.CALCULATION_AUTO, equations);
			ADDOrUpdateEquation("@this.p@", "@this.e@", Equation.CALCULATION_AUTO, equations);
			ADDOrUpdateEquation("@this.h@", "@Parent.hi@", Equation.CALCULATION_AUTO, equations);
			ADDOrUpdateEquation("@this.posx@", "@Parent.epaisseurprincipale@", Equation.CALCULATION_AUTO,equations);
			ADDOrUpdateEquation("@this.posy@", "@Parent.epaisseurprincipale@ ", Equation.CALCULATION_AUTO,equations);
			if(separator.getPosRefType().equals(PositionReferenceType.HAUT)) {
				ADDOrUpdateEquation("@this.posz@", "@Parent.pi@ - @this.sepposition@ -@this.e@  ",
						Equation.CALCULATION_AUTO, equations);
			}else {
				ADDOrUpdateEquation("@this.posz@", "@this.sepposition@",
						Equation.CALCULATION_AUTO, equations);
			}
			ADDOrUpdateEquation("@this.pieceL@", "Math.max(@this.l@,@this.h@)", Equation.CALCULATION_AUTO,equations);
			ADDOrUpdateEquation("@this.pieceH@", "Math.min(@this.l@,@this.h@)", Equation.CALCULATION_AUTO,equations);
			//
			FILL_CHANT_DIM("0","0","0","0",equations);
			FILL_CHANT_EPAISSEUR("0","0","0","0",equations);
			//
		}

		FILL_PIECE2D(separator, equations);
	}	
	
	/**
	 * Cette fonction retourne l'expressin si la dimension est indepandant des parents
	 * @param var
	 * @param expr
	 * @return
	 */
	private String getFreeExpression(String var,String expr)
	{
//		if(child instanceof Caisson)
		{
			if(child.isHauteurextfree() || child.isLongeurextfree() || child.isProfondeurextfree())
			{
				if(var.equalsIgnoreCase("@this.h@") && child.isHauteurextfree())
				{
					expr = ""+child.getHauteurext();
				}
				else if(var.equalsIgnoreCase("@this.l@") && child.isLongeurextfree())
				{
					expr = ""+child.getLongeurext();
				}
				else if(var.equalsIgnoreCase("@this.p@") && child.isProfondeurextfree())
				{
					expr = ""+child.getProfondeurext();
				}
			}
		    if (child.isBasematerialfree() )
			{
				if(var.equalsIgnoreCase("@ParentSPC.epaisseurprincipale@") || 
						var.equalsIgnoreCase("@Parent.epaisseurprincipale@") )
				{
					expr = ""+child.getBasematerial().getEpaisseur();
				}
			}
		
		    if (child.isBasematerialfree() )
			{
		    	if(var.equalsIgnoreCase("@ParentSPC.epaisseursecondaire@") || 
						var.equalsIgnoreCase("@Parent.epaisseursecondaire@") )
				{
					expr = ""+child.getBackmaterial().getEpaisseur();
				}
			}
		}

			return expr;
		
	}

	protected void FILL_CHANT_DIM(String chant1,String chant2,String chant3,String chant4,ArrayList<Equation> equations) {
		ADDOrUpdateEquation("@this.chant1@", chant1, Equation.CALCULATION_AUTO,equations);
		ADDOrUpdateEquation("@this.chant2@", chant2, Equation.CALCULATION_AUTO,equations);
		ADDOrUpdateEquation("@this.chant3@", chant3, Equation.CALCULATION_AUTO,equations);
		ADDOrUpdateEquation("@this.chant4@", chant4, Equation.CALCULATION_AUTO,equations);
	}
	protected void FILL_CHANT_EPAISSEUR(String epaisseur1,String epaisseur2,String epaisseur3,String epaisseur4,ArrayList<Equation> equations) {
		ADDOrUpdateEquation("@this.epaisseur1@", epaisseur1, Equation.CALCULATION_AUTO,equations);
		ADDOrUpdateEquation("@this.epaisseur2@", epaisseur2, Equation.CALCULATION_AUTO,equations);
		ADDOrUpdateEquation("@this.epaisseur3@", epaisseur3, Equation.CALCULATION_AUTO,equations);
		ADDOrUpdateEquation("@this.epaisseur4@", epaisseur4, Equation.CALCULATION_AUTO,equations);
	}
	
	protected static void FILL_USINAGE(EList<Parameters> eList,ArrayList<Equation> equations) {
		if(eList!=null) {
			for(Parameters param:eList) {
				if(param!=null&& param.getCode()!=null&& param.getValue()!=null) {
					ADDOrUpdateEquation(param.getCode(),param.getValue() ,Equation.CALCULATION_MANUAL,equations);
				}
				
			}
		}
		
	}
	
	protected static  void ADDOrUpdateEquation(String var,String expr,String mode,ArrayList<Equation> equations)
	{
		Equation equ = Equation.FIND_EQUATION(var, equations);
		if(equ!=null)
			equ.setExpr(expr);
		else
			equations.add(new Equation(var, expr, mode));
	}

	public static void EVALUATE(ArrayList<Equation> equations) throws GeometricEngineException
	{
		GeomtericEngine.getInstance().setEquations(equations);
		GeomtericEngine.getInstance().resolveAll();// evaluation globale pour faire un premier calcul
	}
	public void dispose() {
		if(geoengine!=null)geoengine.dispose();
		
	}
}
