package dressing.model.accessoire;

import dressing.model.Accessoire;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Piece2D;
import dressing.model.SupportMeubleBas;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.SupportPorteBoteilleType;
import dressing.model.types.TrouType;
import dressing.model.usinage.Direction;
import dressing.model.usinage.Trou;
import dressing.model.usinage.Usinage;

public class SupportPorteBoteille extends Accessoire {
	SupportPorteBoteilleType supportType = SupportPorteBoteilleType.BAS;	
	Direction direction =Direction.XMINUS;

	
	
	@Override
	public boolean canHold(DesignObject3D child) {
		if(child instanceof Usinage) {
			return true;
		}
		return false;
	}
	
	@Override
	public boolean isdrawable() {
		return false;
	}
	
	public SupportPorteBoteilleType getSupportType() {
		return supportType;
	}
	public void setSupportType(SupportPorteBoteilleType supportType) {
		SupportPorteBoteilleType oldValue = this.supportType;
		this.supportType = supportType;
		firePropertyChange("supportType", oldValue, supportType);
	}
	public Direction getDirection() {
		return direction;
	}

	public void setDirection(Direction direction) {
		Direction oldValue = this.direction;
		this.direction = direction;
		firePropertyChange("direction", oldValue, direction);
	}
	
	public SupportPorteBoteille clone() {

		SupportPorteBoteille support=new SupportPorteBoteille();
		support.setSupportType(getSupportType());
		support=(SupportPorteBoteille) this.copy(support);
		return support;
	}
	
	/**
	 * @author imed 
	 * @Bug 0001217 
	 * Créer les trous d'usinage necessaire pour cette Accessoire(Support Bas {@link SupportMeubleBas})
	 * créer les trous d'usinage 
	 */
	@Override
	public void createUsinage() throws GeometricEngineException, DesignException {
		
		Piece2D piece=(Piece2D) getParentdesign();

		Trou tr1=new Trou(getDirection());
		Trou tr2=new Trou(getDirection());
		
		tr1.setTrouType(TrouType.SUPPORT_PORTE_BOTEILLE_FRONT);
		tr2.setTrouType(TrouType.SUPPORT_PORTE_BOTEILLE_BACK);

		tr1.setMother(this); 
		tr2.setMother(this);
		
		tr1.setName("Trou Avant "+this.getName());
		tr2.setName("Trou Arriere "+this.getName());		
		
		tr1.setParentdesign(piece);
		tr2.setParentdesign(piece);

		
		tr1.constructDebitage();
		tr1.evaluate();
		
		tr2.constructDebitage();
		tr2.evaluate();
		
		piece.addElement(tr1);
		piece.addElement(tr2);

	}
}
