package dressing.handlers.cam;

import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

import dressing.io.IOUtilities;
import dressing.model.Caisson;
import dressing.model.DesignObject3D;
import dressing.model.Dressing;
import dressing.model.Kitchen;
import dressing.model.Piece2D;
import dressing.model.Project3D;
import dressing.model.Space3DFree;
import dressing.model.SuperCadProject;
import dressing.model.types.PieceType;
import dressing.cam.model.PlanUsinage;

/**
 *
 * @author Administrator
 */
public class GcodeFileManager {
	String extension = ".gcode";
	String filepath = "";

	public GcodeFileManager(String extension) {
		this.extension = extension;
	}

	private void savemodel(Piece2D piece, String filepath) throws Exception {
		int index = 1;
		PlanUsinage pl = PlanUsinage.FRONT;
		String s = filepath;
		s = s.replace("@DIM@", pl.name() + (int) piece.getWidth(pl) + "X" + (int) piece.getHight(pl));
		s = s.replace("@ITERATION@", "" + index);
		FileOutputStream fosFace = null;
		try {
			File file = new File(s);
			if (!file.exists()) {
				file.getParentFile().mkdirs();
				file.createNewFile();
			}
			fosFace = new FileOutputStream(file, false);
			String gcode = "";
			if (piece.get("gcode_face") != null)
				gcode = (String) piece.get("gcode_face");
			fosFace.write(gcode.getBytes());
		} catch (IOException ex) {
			ex.printStackTrace();
		} finally {
			if (fosFace != null)
				fosFace.close();
		}

		//
		PlanUsinage plb = PlanUsinage.BACK;
		String sb = filepath;
		sb = sb.replace("@DIM@", plb.name() + (int) piece.getWidth(pl) + "X" + (int) piece.getHight(plb));
		sb = sb.replace("@ITERATION@", "" + index);
		FileOutputStream fosBack = null;
		try {
			File file = new File(sb);
			if (!file.exists())
				file.createNewFile();
			fosBack = new FileOutputStream(file);
			String gcode = "";
			if (piece.get("gcode_back") != null)
				gcode = (String) piece.get("gcode_back");
			fosBack.write(gcode.getBytes());
		} catch (IOException ex) {
			ex.printStackTrace();
		} finally {
			if (fosBack != null)
				fosBack.close();
		}
		index++;
	}

	public String saveworkspace(Shell shell, DesignObject3D guilltinesolution) {

		if (filepath!=null && !filepath.isEmpty()) {
			try {
				if (guilltinesolution instanceof Piece2D) {
					this.savemodel((Piece2D) guilltinesolution, filepath);
				}
			} catch (Exception ex) {
				ex.printStackTrace();
			}
			return filepath;
		} else {
			try {
				Preferences preferences = InstanceScope.INSTANCE.getNode("com.dressing");
				Preferences projectpref = preferences.node("SuperCadProject");
				String defaultpath=projectpref.get("SaveAsdirectory", System.getProperty("user.home") + File.separator + "Desktop");
				String dirpath = projectpref.get("directoryWrite", defaultpath);

				FileDialog dialog = new FileDialog(shell);
				dialog.setFilterPath(dirpath);
				dialog.setFilterExtensions(new String[] { "*.gcode" });
				String filepath = dialog.open();
				if (filepath != null && !filepath.isEmpty()) {
					// Imed bug 0001710 changer l'exportation dxf dynamyque pour tout les design3D
					createDcodeFolder(filepath, guilltinesolution);
					File file = new File(filepath);
					dirpath = file.getParent();
					projectpref.put("directoryWrite", dirpath);
					try {
						projectpref.flush();
					} catch (BackingStoreException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
					Desktop.getDesktop().open(file);
					return filepath;
				}
				return "";

			} catch (Exception err) {
				err.printStackTrace();
			}
		}
		return "";

	}

	public void saveGcode(Kitchen kitchen, String path) {
		kitchen.generateElementsGcode();
		File dir = new File(path);
		if (dir.exists())
		{
			IOUtilities.deleteFolder(dir);
		}
		if (!dir.exists())
		{
			dir.mkdirs();
		}
		String root = "";
		List<DesignObject3D> elements=kitchen.getElementsWithoutFausseFacades();
		int index =1;
		for (DesignObject3D element : elements) {
			root = path + File.separator +'N'+( index)+"_"+ element.getName()+"_"+element.getLongeurext() +"_"+element.getProfondeurext()+"_"+element.getHauteurext();
			saveGcode(element, root);
			index++;
		}
	}
	public void saveGcode(SuperCadProject project, String path) {
		File dir = new File(path);
		if (!dir.exists())
			dir.mkdirs();
		String root = "";
		for (int i =0;i<project.getKitchens().size();i++) {
			Kitchen kitchen= project.getKitchens().get(i);
			root = path + File.separator + kitchen.getName() + " N" + i;
			saveGcode(kitchen, root);
		}
	}

	public void saveGcode(DesignObject3D element, String path) {
		File dir = new File(path);
		if (!dir.exists())
			dir.mkdirs();
		String root = "";
		for (DesignObject3D piece : element.getListPieces()) {
			if (piece instanceof Piece2D) {
				root = path + File.separator + piece.getName();
				saveGcode((Piece2D) piece, root);
			}
		}
	}

	public void saveGcode(Piece2D piece, String path) {
		File dir = new File(path);
		

		String code = "";
		if (piece.get("gcode_face") != null && !piece.get("gcode_face").toString().isEmpty()) {
			if (!dir.exists()) {
				dir.mkdirs();
			}
			code = (String) piece.get("gcode_face");
			FileOutputStream fosFace = null;
			File file=null;
			try {
				file = new File(path + File.separator + "face"+extension);
				if (!file.exists()) {
					file.getParentFile().mkdirs();
					file.createNewFile();
				}
				fosFace = new FileOutputStream(file, false);
				fosFace.write(code.getBytes());
			} catch (IOException ex) {
				System.err.println("path not found"+file.getAbsolutePath());
				ex.printStackTrace();
			} finally {
				if (fosFace != null)
					try {
						fosFace.close();
					} catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
			}
		}

		if (piece.get("gcode_back") != null && !piece.get("gcode_back").toString().isEmpty()) {
			if (!dir.exists()) {
				dir.mkdirs();
			}
			code = (String) piece.get("gcode_back");
			FileOutputStream fosBack = null;
			try {
				File file = new File(path + File.separator + "back"+extension);
				if (!file.exists())
					file.createNewFile();
				fosBack = new FileOutputStream(file);
				fosBack.write(code.getBytes());
			} catch (IOException ex) {
				ex.printStackTrace();
			} finally {
				if (fosBack != null)
					try {
						fosBack.close();
					} catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
			}
		}
	}

	/**
	 * @author Imed
	 * @bug 0001710
	 * @param filepath
	 *            le path de dossier donner par l'utilisateur
	 * @param design
	 *            la racine d'arbre des piece a exporter vers dxf méthode récurive
	 *            pour créer l'arbre des dossier pour l'objet spécifier et ces fisse
	 * @throws Exception
	 */
	public void createDcodeFolder(String filepath, DesignObject3D design) throws Exception {
		if (filepath != null && !filepath.isEmpty() && design != null) {
			if (design instanceof Piece2D) {
				File file = new File(filepath);
				if (!file.exists()) {
					file.mkdirs();
				}

				File file2 = new File(file, design.getName());
				file2.mkdirs();
				String monFichier = new String(file2.getAbsolutePath().replaceAll("." + extension, "")) + File.separator
						+ "@DIM@_P_@ITERATION@" + extension; // Récupérer le chemin du fichier spécifié
				this.savemodel((Piece2D) design, monFichier);
				if (((Piece2D) design).getPiecetype().equals(PieceType.SEPRATEUR_NORMAL)
						|| ((Piece2D) design).getPiecetype().equals(PieceType.SEPRATEUR_TRANSVERSANT)) {
					for (DesignObject3D sapce : design.getChilds()) {
						createDcodeFolder(file2.getAbsolutePath(), sapce);
					}
				}
			} else if ((design instanceof Project3D || design instanceof Dressing || design instanceof Caisson
					|| design instanceof Space3DFree)) {
				File file = new File(filepath);
				if (!file.exists()) {
					file.mkdirs();
				}
				File file2 = new File(file, design.getName());
				file2.mkdir();
				for (DesignObject3D sapce : design.getChilds()) {
					createDcodeFolder(file2.getAbsolutePath(), sapce);
				}
			} else {
				for (DesignObject3D sapce : design.getChilds()) {
					createDcodeFolder(filepath, sapce);
				}
			}

		}
	}

	public String getFilepath() {
		return filepath;
	}

	public void setFilepath(String filepath) {
		this.filepath = filepath;
	}

}
