package dressing.ui.dos;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import dressing.controller.DressingCreator;
import dressing.controller.Piece2DCreator;
import dressing.model.DesignException;
import dressing.model.Dressing;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.DosType;
import dressing.model.types.PieceType;
import dressing.model.types.PortType;

public class DosWelcomePage extends WizardPage{

	Piece2DCreator piecesfactory ;
	PropertyChangeListener pcl;
	boolean errorfound=false;
	protected DosWelcomePage(String pageName,Piece2DCreator piece) {
		super(pageName);
		this.piecesfactory = piece;
		setTitle("Ajouter une porte");
		setDescription("Veuillez renseigner le type de porte");		
		// TODO Auto-generated constructor stub
	}


	@Override
	public void createControl(Composite parent) {
		// TODO Auto-generated method stub
		DosCompositeWizard compo1 = new DosCompositeWizard(parent, SWT.NONE,piecesfactory);
		setControl(compo1);
		pcl = new PropertyChangeListener() {
			
			@Override
			public void propertyChange(PropertyChangeEvent evt) {
				// TODO Auto-generated method stub
				if(!evt.getPropertyName().startsWith("project.")) //seulemnt les proprietes de javabean
				{
					try {										
						if(piecesfactory.getDostype().equals(DosType.DOSINTERIEUR))
						{
							piecesfactory.setPiecetype(PieceType.DOS_INTERIEUR);
						

						}
						else if(piecesfactory.getDostype().equals(DosType.DOSEXTERIEUR))
						{
							piecesfactory.setPiecetype(PieceType.DOS_EXTERIRUR);

						}
						else
						{
							throw new DesignException("Type dos non supporté");
						}		
						piecesfactory.create();
						setErrorMessage(null);	
						errorfound = false;
						setMessage("Vous pouvez ajouter votre porte", WizardPage.INFORMATION);
					} catch (DesignException  | GeometricEngineException e) {
						setErrorMessage(e.getMessage());	
						errorfound = true;
					}
					getWizard().getContainer().updateButtons();
				}

			}
		};
		piecesfactory.addPropertyChangeListener(pcl);
	}
@Override
public boolean isPageComplete() {
	// TODO Auto-generated method stub
	boolean b = !errorfound;
	return b;
}
public void clearlistners() {
	piecesfactory.removePropertyChangeListener(pcl);
}
}
