package supercad.p2.update;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;

public class ConfigurationManager {
	private static Properties properties = new Properties();

	static {
		try {
			String executionPath = System.getProperty("user.dir");
			Path configPath = Paths.get(executionPath, "configuration", "config.ini");
			File configFile = configPath.toFile();

			if (System.getProperty("osgi.dev") != null) {
				InputStream input = ConfigurationManager.class.getClassLoader()
						.getResourceAsStream("config.properties");
				if (input != null) {
					properties.load(input);
				} else {
					System.err.println("ERREUR: Fichier config.proprietes non trouvé dans le classpath!");
				}

			} else {
				if (configFile.exists()) {
					properties.load(new FileInputStream(configFile));
				}else {
					System.err.println("ERREUR: Fichier Config.ini not found!");
				}
			}

		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	public static String getProperty(String key) {
		return properties.getProperty(key);
	}
}
