package dressing.ui.util;

import org.eclipse.swt.widgets.Shell;
import com.badlogic.gdx.math.Vector3;

import dressing.mathutils.Edge;
import dressing.mathutils.Surface;
import dressing.mathutils.Vector4;
import dressing.model.DesignObject3D;
import dressing.model.Space3DFree;
import dressing.ui.ChangeCommand;
import dressing.ui.ChangeCommandController;
import dressing.ui.CommandStack;
import dressing.ui.MoveCommand;
import dressing.ui.RotateCommand;
import dressing.ui.ScaleCommand;
import dressing.ui.parts.GdxPart;
import gdxapp.Commun.AbstractScreen;
import gdxapp.Commun.Measure;
import gdxapp.object3d.Object2D;
import gdxapp.object3d.WorldObject;
import gdxapp.object3d.WorldObject.ObjectType;
import gdxapp.scenes.Scene;
import gdxapp.screens.room.RoomController;
import gdxapp.screens.wall.SurfaceController;
import gdxapp.ui.Note;
import param.MechanicDesign;
import param.MechanicPublicParam;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.graphics.Rectangle;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.wb.swt.SWTResourceManager;
import org.eclipse.swt.widgets.Text;

public abstract class EditorWindow extends org.eclipse.jface.window.Window{

	
	public EditorWindow(Shell parentShell) {
		super(parentShell);
		setShellStyle(SWT.SHELL_TRIM| SWT.APPLICATION_MODAL);
		setBlockOnOpen(true);
	}

	public Shell shell;
	public List<Action> actions;
	
	private static EditorWindow instance;
	private Button btnRun;
	private Button btnFermer;
	private Composite buttonAreaComposite;
	private Composite cleantAreaComposite;
	
	public List<Action> getActions() {
		return actions;
	}
	public void setActions(List<Action> actions) {
		this.actions = actions;
	}
	@Override
	protected boolean canHandleShellCloseEvent() {
		return true;
	}
	@Override
	protected void handleShellCloseEvent() {
		setReturnCode(CANCEL);
		hide();
	}
	

	@Override
	public void create() {
		// TODO Auto-generated method stub
		super.create();
		constrainShellSize();
	}
	/**  
	 * Create contents of the window.
	 * @return 
	 */
	protected Control createContents(Composite parent) {
		parent.setTouchEnabled(true);
		this.shell=parent.getShell();
		parent.getShell().setText("Mesure");
		shell.addShellListener(getShellListener());

		Composite composite = new Composite(parent, SWT.FILL);
		composite.setTouchEnabled(true);
		composite.setLayout(new GridLayout(1, false));
		
		cleantAreaComposite = createClientArea(composite);
		GridData gd_composite_1 = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		gd_composite_1.widthHint = 266;
//		gd_composite_1.heightHint = 192;
		cleantAreaComposite.setLayoutData(gd_composite_1);
		
		buttonAreaComposite = createButtonArea(composite);
		GridData gd_composite_2 = new GridData(SWT.FILL, SWT.BOTTOM, true, false, 1, 1);
		gd_composite_2.heightHint = 39;
		buttonAreaComposite.setLayoutData(gd_composite_2);
		//
		composite.setTabList(new Control[]{cleantAreaComposite, buttonAreaComposite});

		ControlAdapter adaptor=new ControlAdapter() {

			@Override
			public void controlResized(ControlEvent e) {
				 Rectangle area2= EditorWindow.this.getShell().getClientArea();
			     composite.setBounds(area2);
			}
			
		};
		parent.addControlListener(adaptor);
		composite.addControlListener(adaptor);
		getShell().addControlListener(adaptor);		
				
		return composite;

	}
	
	
	
	protected abstract Composite createClientArea(Composite parent);
	protected Composite createButtonArea(Composite parent) {
		Composite composite= new Composite(parent, SWT.NONE);
		GridLayout gl_composite_2 = new GridLayout(2, false);
		gl_composite_2.horizontalSpacing = 0;
		composite.setLayout(gl_composite_2);
		
		btnRun = new Button(composite, SWT.NONE);
		btnRun.setImage(ResourceManager.getPluginImage("Dressing", "icons/Calculer.png"));
		GridData gd_btnRun = new GridData(SWT.FILL, SWT.BOTTOM, true, true, 1, 1);
		gd_btnRun.heightHint = 31;
		btnRun.setLayoutData(gd_btnRun);

		btnRun.setText("Terminer");
		btnFermer = new Button(composite, SWT.NONE);
		GridData gd_btnFermer = new GridData(SWT.FILL, SWT.BOTTOM, true, true, 1, 1);
		gd_btnFermer.heightHint = 31;
		btnFermer.setLayoutData(gd_btnFermer);
		btnFermer.setText("Fermer");
		
		btnFermer.addSelectionListener(new SelectionAdapter() {
		
					@Override
					public void widgetSelected(SelectionEvent e) {
						// TODO Auto-generated method stub
						fermer();
					}
					
				});
		btnRun.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(SelectionEvent e) {
						terminer();
						hide();
					}
					
				});
		return composite;
	}
	public synchronized void  show() {
		if(!shell.isDisposed())
		{
			EditorWindow.this.shell.setVisible(true);
			EditorWindow.this.shell.setActive();

		}

	}
	public synchronized void hide() {
		if(!shell.isDisposed())
		{
			
			EditorWindow.this.shell.setVisible(false);
		}

	}
	
	public Shell getShell() {
		return shell;
	}
	public void setShell(Shell shell) {
		this.shell = shell;
	}
	public Button getBtnRun() {
		return btnRun;
	}
	public void setBtnRun(Button btnRun) {
		this.btnRun = btnRun;
	}
	public Button getBtnFermer() {
		return btnFermer;
	}
	public void setBtnFermer(Button btnFermer) {
		this.btnFermer = btnFermer;
	}
	public abstract void terminer();

	protected void fermer() {
		hide();
	}
	
	public void createController() {
		
	}
	
	
}
