package dressing.ui.engine3d.sceneconfig;

import org.eclipse.swt.widgets.Composite;
import swing2swt.layout.BorderLayout;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wb.swt.SWTResourceManager;

import dressing.config.UserPreference;
import dressing.model.ModelProvider;
import dressing.model.ProjectManager;
import dressing.ui.engine3d.SceneTexture;
import dressing.ui.util.SingleImageItemLabelProvider;
import gdxapp.scenes.Scene;
import gdxapp.scenes.ScenePreferences;

import org.eclipse.nebula.widgets.tablecombo.TableCombo;

import javax.inject.Inject;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import swing2swt.layout.BoxLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.custom.CBanner;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;

public class SceneConfigComposite extends Composite {
	
	@Inject
	IEclipseContext eclipsecontext;
	@Inject
	private ESelectionService selectionService;
	@Inject
	private EHandlerService handlerService;
	@Inject
	private ECommandService commandService;
	
	private ScenePreferences scenePreferences;
	private UserPreference userPreferences;

	private DataBindingContext bindingContext;
	
	private TableComboViewer tcvWalls;
	private TableComboViewer tcvFloors;
	private TableComboViewer tcvMarbles;
	private TableComboViewer tcvColors;
	private TableComboViewer tcvCeilings;
	private TableComboViewer tcvFacades;
	private TableComboViewer tcvElement;
	private Button btnOmbres;
	private Button btnAutomatiquement;
	private Spinner spinner;
	private Spinner spinner_1;
	private Spinner spnWallWidth;
	private Button btnPerformanceMode;
	


	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 */
	
	public SceneConfigComposite(Composite parent, int style) {
		super(parent, style);
		this.userPreferences = UserPreference.getPreference();
		RowLayout rowLayout = new RowLayout(SWT.VERTICAL);
		rowLayout.justify = true;
		rowLayout.fill = true;
		setLayout(rowLayout);
		
		CBanner banner = new CBanner(this, SWT.NONE);
		
		SashForm sashForm = new SashForm(banner, SWT.VERTICAL);
		banner.setLeft(sashForm);
		
		Group grpPrferenceDeScne = new Group(sashForm, SWT.NONE);
		grpPrferenceDeScne.setText("Préference de scéne");
		grpPrferenceDeScne.setLayout(new GridLayout(2, false));
		
		Label lblSol = new Label(grpPrferenceDeScne, SWT.NONE);
		lblSol.setText("Sol");
		
		tcvFloors = new TableComboViewer(grpPrferenceDeScne, SWT.CENTER);
		TableCombo tableCombo_floor = tcvFloors.getTableCombo();
		tableCombo_floor.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tcvFloors.getTableCombo().defineColumns(new String[] { "texture" });
		tcvFloors.getTableCombo().getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		// do not allow editable
		tcvFloors.getTableCombo().setEditable(false);
		// set the content provider
		tcvFloors.setContentProvider(ArrayContentProvider.getInstance());
		// set the label provider
		tcvFloors.setLabelProvider(new SingleImageItemLabelProvider(this));
		// load the data
		tcvFloors.setInput(ModelProvider.getTextures());
		
		
		Label lblNewLabel = new Label(grpPrferenceDeScne, SWT.NONE);
		lblNewLabel.setText("Plafond");
		
		tcvCeilings = new TableComboViewer(grpPrferenceDeScne, SWT.NONE);
		TableCombo tableCombo_ceiling = tcvCeilings.getTableCombo();
		tableCombo_ceiling.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tcvCeilings.getTableCombo().defineColumns(new String[] { "texture" });
		tcvCeilings.getTableCombo().getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		// do not allow editable
		tcvCeilings.getTableCombo().setEditable(false);
		// set the content provider
		tcvCeilings.setContentProvider(ArrayContentProvider.getInstance());
		// set the label provider
		tcvCeilings.setLabelProvider(new SingleImageItemLabelProvider(this));
		// load the data
		tcvCeilings.setInput(ModelProvider.getTextures());
		
		Label lblMur = new Label(grpPrferenceDeScne, SWT.NONE);
		lblMur.setText("Mur");
		
		tcvWalls = new TableComboViewer(grpPrferenceDeScne, SWT.NONE);
		TableCombo tableCombo_wall = tcvWalls.getTableCombo();
		tableCombo_wall.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tcvWalls.getTableCombo().defineColumns(new String[] { "texture" });
		tcvWalls.getTableCombo().getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		// do not allow editable
		tcvWalls.getTableCombo().setEditable(false);
		// set the content provider
		tcvWalls.setContentProvider(ArrayContentProvider.getInstance());
		// set the label provider
		tcvWalls.setLabelProvider(new SingleImageItemLabelProvider(this));
		// load the data
		tcvWalls.setInput(ModelProvider.getTextures());
		
		Label lblMarble = new Label(grpPrferenceDeScne, SWT.NONE);
		lblMarble.setText("Marble");
		
		tcvMarbles = new TableComboViewer(grpPrferenceDeScne, SWT.NONE);
		TableCombo tableCombo_marble = tcvMarbles.getTableCombo();
		tableCombo_marble.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tcvMarbles.getTableCombo().defineColumns(new String[] { "texture" });
		tcvMarbles.getTableCombo().getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		// do not allow editable
		tcvMarbles.getTableCombo().setEditable(false);
		// set the content provider
		tcvMarbles.setContentProvider(ArrayContentProvider.getInstance());
		// set the label provider
		tcvMarbles.setLabelProvider(new SingleImageItemLabelProvider(this));
		// load the data
		tcvMarbles.setInput(ModelProvider.getTextures());
		
		Label lblFacade = new Label(grpPrferenceDeScne, SWT.NONE);
		lblFacade.setText("Façade");
		
		tcvFacades = new TableComboViewer(grpPrferenceDeScne, SWT.NONE);
		TableCombo tableCombo_facade = tcvFacades.getTableCombo();
		tableCombo_facade.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tcvFacades.getTableCombo().defineColumns(new String[] {"texture"});
		tcvFacades.getTableCombo().getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		// do not allow editable
		tcvFacades.getTableCombo().setEditable(false);
		// set the content provider
		tcvFacades.setContentProvider(ArrayContentProvider.getInstance());
		// set the label provider
		tcvFacades.setLabelProvider(new SingleImageItemLabelProvider(this));
		// load the data
		tcvFacades.setInput(ModelProvider.getTextures());
		
		Label lblElement = new Label(grpPrferenceDeScne, SWT.NONE);
		lblElement.setText("Element");
		
		tcvElement = new TableComboViewer(grpPrferenceDeScne, SWT.NONE);
		TableCombo tableCombo_Element = tcvElement.getTableCombo();
		tableCombo_Element.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tcvElement.getTableCombo().defineColumns(new String[] {"texture"});
		tcvElement.getTableCombo().getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		// do not allow editable
		tcvElement.getTableCombo().setEditable(false);
		
		
		Group grpHandlers = new Group(sashForm, SWT.NONE);
		grpHandlers.setText("Handlers");
		grpHandlers.setLayout(new GridLayout(2, false));
		
		Label lblMotif = new Label(grpHandlers, SWT.NONE);
		lblMotif.setText("motif:");
		
		TableComboViewer tableComboViewer_3 = new TableComboViewer(grpHandlers, SWT.NONE);
		TableCombo tableCombo_handlers = tableComboViewer_3.getTableCombo();
		tableCombo_handlers.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblCouleur = new Label(grpHandlers, SWT.NONE);
		lblCouleur.setText("couleur");
		
		TableComboViewer tableComboViewer_4 = new TableComboViewer(grpHandlers, SWT.NONE);
		TableCombo tableCombo_handlersColor = tableComboViewer_4.getTableCombo();
		tableCombo_handlersColor.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		//this.preferences = new ScenePreferences();
		
		Group grpMesures = new Group(sashForm, SWT.NONE);
		grpMesures.setText("Mesures");
		grpMesures.setLayout(new GridLayout(2, false));
		
		Label lblHauteurDesMures = new Label(grpMesures, SWT.NONE);
		lblHauteurDesMures.setText("Hauteur des murs");
		
		spinner = new Spinner(grpMesures, SWT.BORDER);
		spinner.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spinner.setPageIncrement(100);
		spinner.setIncrement(10);
		spinner.setMaximum(500000);
		
		Label lblPronfondeurDesMures = new Label(grpMesures, SWT.NONE);
		lblPronfondeurDesMures.setText("Pronfondeur des murs");
		
		spnWallWidth = new Spinner(grpMesures, SWT.BORDER);
		spnWallWidth.setMaximum(10000000);
		spnWallWidth.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		
		Label lblHauteurDePlynthe = new Label(grpMesures, SWT.NONE);
		lblHauteurDePlynthe.setText("Hauteur de plinthe");
		
		spinner_1 = new Spinner(grpMesures, SWT.BORDER);
		spinner_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spinner_1.setMaximum(300000);
		
		Group grpRendering = new Group(sashForm, SWT.NONE);
		grpRendering.setText("Rendering");
		grpRendering.setLayout(new GridLayout(1, false));
		
		btnOmbres = new Button(grpRendering, SWT.CHECK);
		btnOmbres.setText("ombres");
		
		btnAutomatiquement = new Button(grpRendering, SWT.CHECK);
		btnAutomatiquement.setText("géneration marble auto");
		btnAutomatiquement.setText("géneration marble auto");
		btnAutomatiquement.setText("géneration marble auto");
		btnAutomatiquement.setText("génerer marbles automatiquement");
		
		btnPerformanceMode = new Button(grpRendering, SWT.CHECK);
		btnPerformanceMode.setText("mode performance");
		// set the content provider
		tcvElement.setContentProvider(ArrayContentProvider.getInstance());
		// set the label provider
		tcvElement.setLabelProvider(new SingleImageItemLabelProvider(this));
		// load the data
		tcvElement.setInput(ModelProvider.getTextures());
		sashForm.setWeights(new int[] {1, 1, 1, 1});
		
		Composite composite = new Composite(banner, SWT.NONE);
		banner.setRight(composite);
		GridLayout gl_composite = new GridLayout(1, false);
		gl_composite.marginBottom = 15;
		gl_composite.marginHeight = 15;
		gl_composite.marginLeft = 15;
		gl_composite.marginRight = 15;
		gl_composite.marginTop = 15;
		gl_composite.marginWidth = 15;
		composite.setLayout(gl_composite);
		
		Label lblImage = new Label(composite, SWT.CENTER);
		lblImage.setText("image");
		lblImage.setSize(200, 200);
		
		Label lblName = new Label(composite, SWT.NONE);
		lblName.setText("name");
		if(scenePreferences!=null) {
			this.bindingContext = initDataBindings();
		}

	}

	public ScenePreferences getPreferences() {
		return scenePreferences;
	}

	public void setPreferences(ScenePreferences preferences) {
		this.scenePreferences = preferences;
		if (bindingContext != null) {
			bindingContext.dispose();
			bindingContext = null;
		}
		if (preferences != null) {
			bindingContext = initDataBindings();
		}
	}

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeSingleSelectionTcvFloors = ViewerProperties.singleSelection().observe(tcvFloors);
		IObservableValue floorTexturePreferencesObserveValue = BeanProperties.value("floorTexture").observe(scenePreferences);
		bindingContext.bindValue(observeSingleSelectionTcvFloors, floorTexturePreferencesObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionTcvCeilings = ViewerProperties.singleSelection().observe(tcvCeilings);
		IObservableValue ceilingTexturePreferencesObserveValue = BeanProperties.value("ceilingTexture").observe(scenePreferences);
		bindingContext.bindValue(observeSingleSelectionTcvCeilings, ceilingTexturePreferencesObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionTcvWalls = ViewerProperties.singleSelection().observe(tcvWalls);
		IObservableValue wallTexturePreferencesObserveValue = BeanProperties.value("wallTexture").observe(scenePreferences);
		bindingContext.bindValue(observeSingleSelectionTcvWalls, wallTexturePreferencesObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionTcvMarbles = ViewerProperties.singleSelection().observe(tcvMarbles);
		IObservableValue marbleTexturePreferencesObserveValue = BeanProperties.value("marbleTexture").observe(scenePreferences);
		bindingContext.bindValue(observeSingleSelectionTcvMarbles, marbleTexturePreferencesObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionTcvFacades = ViewerProperties.singleSelection().observe(tcvFacades);
		IObservableValue facadeTexturePreferencesObserveValue = BeanProperties.value("facadeTexture").observe(scenePreferences);
		bindingContext.bindValue(observeSingleSelectionTcvFacades, facadeTexturePreferencesObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionTcvElement = ViewerProperties.singleSelection().observe(tcvElement);
		IObservableValue boxTexturePreferencesObserveValue = BeanProperties.value("boxTexture").observe(scenePreferences);
		bindingContext.bindValue(observeSingleSelectionTcvElement, boxTexturePreferencesObserveValue, null, null);
		//
		IObservableValue observeSelectionSpinnerObserveWidget = WidgetProperties.widgetSelection().observe(spinner);
		IObservableValue wallHeightPreferencesObserveValue = BeanProperties.value("wallHeight").observe(scenePreferences);
		bindingContext.bindValue(observeSelectionSpinnerObserveWidget, wallHeightPreferencesObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnOmbresObserveWidget = WidgetProperties.widgetSelection().observe(btnOmbres);
		IObservableValue renderShadowsPreferencesObserveValue = BeanProperties.value("renderShadows").observe(scenePreferences);
		bindingContext.bindValue(observeSelectionBtnOmbresObserveWidget, renderShadowsPreferencesObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnAutomatiquementObserveWidget = WidgetProperties.widgetSelection().observe(btnAutomatiquement);
		IObservableValue autogenerateMarblePreferencesObserveValue = BeanProperties.value("autogenerateMarble").observe(scenePreferences);
		bindingContext.bindValue(observeSelectionBtnAutomatiquementObserveWidget, autogenerateMarblePreferencesObserveValue, null, null);
		//
		IObservableValue observeSelectionSpinner_1ObserveWidget = WidgetProperties.widgetSelection().observe(spinner_1);
		IObservableValue bottomFakeFacadeHeightPreferencesObserveValue = BeanProperties.value("bottomFakeFacadeHeight").observe(scenePreferences);
		bindingContext.bindValue(observeSelectionSpinner_1ObserveWidget, bottomFakeFacadeHeightPreferencesObserveValue, null, null);
		//
		IObservableValue observeSelectionSpnWallWidthObserveWidget = WidgetProperties.widgetSelection().observe(spnWallWidth);
		IObservableValue wallwidthPreferencesObserveValue = BeanProperties.value("wallwidth").observe(scenePreferences);
		bindingContext.bindValue(observeSelectionSpnWallWidthObserveWidget, wallwidthPreferencesObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnPerformanceModeObserveWidget = WidgetProperties.widgetSelection().observe(btnPerformanceMode);
		IObservableValue performanceModeUserPreferencesObserveValue = PojoProperties.value("performanceMode").observe(userPreferences);
		bindingContext.bindValue(observeSelectionBtnPerformanceModeObserveWidget, performanceModeUserPreferencesObserveValue, null, null);
		//
		return bindingContext;
	}
}
