package dressing.ui.caisson;

import java.util.ArrayList;
import java.util.List;

import javax.inject.Inject;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

import dressing.controller.CaissonCreator;
import dressing.model.Caisson;
import dressing.model.DesignException;
import dressing.model.Dressing;
import dressing.model.Materiaux;
import dressing.model.Project3D;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.PortType;
import dressing.ui.dressing.DressingWelcomePage;

public class CaissonWizard extends Wizard{

	//L injection ne peut etre en marche que si on creer l objet avec contextfactory et non pas avec l objet new
	@Inject
	IEclipseContext  eclipsecontext;

	@Inject
	private EHandlerService handlerService;
	
	@Inject
	private ECommandService commandService;


	Dressing dress ;
	CaissonCreator caisson = new CaissonCreator();
	CaissonWizardPage wizardpage;
	public CaissonWizard () {
		setWindowTitle("Nouveau caisson");		
	}

	@Override
	public void addPages() {
		
		wizardpage = new CaissonWizardPage("WelcomePage",caisson);
		addPage(wizardpage);	
	}

	@Override
	public boolean performFinish() {
		try {	
			try {
				caisson.create();

				wizardpage.clearlistners();
				dress.addElement(caisson.getCaissonInstance());
				
			} catch (GeometricEngineException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			return true;
		} catch (DesignException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return false;
		}
		

	}
	public void setDressing(Dressing dress) {
		this.dress = dress;
		caisson.setParent(dress);
		caisson.setLongeur(0);
		caisson.setHauteur(dress.getHauteurext());
		caisson.setProfondeur(dress.getProfondeurext());
		caisson.setBackmaterial(dress.getBackmaterial());
		caisson.setBasematerial(dress.getBasematerial());
		caisson.setPorttype(dress.getPorttype());
		caisson.setCaissonMontageType(dress.getCaissonmontageType());
		caisson.setDostype(dress.getDostype());
	}	
	@Override
	public boolean canFinish() {
		IWizardPage[] pages = getPages();
		for (IWizardPage page : pages) {
			if (!page.isPageComplete()) {
				return false;
			}
		}
		return true;
	}
}