
package dressing.handlers.reporting;

import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import com.badlogic.gdx.Gdx;

import dressing.io.IOUtilities;
import dressing.model.ProjectManager;
import gdxapp.object3d.KitchenElement;
import gdxapp.screens.room3d.Room3DController;
import reporting.ReportWindow;
import reporting.htmlReporting.ProjectReport;
import java.io.File;
import java.io.IOException;
import java.util.List;

import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.di.annotations.CanExecute;

public class FicheDebitReportHandler {
	boolean showUsin = false;
	boolean showUsinCotes = false;
	boolean groupedPiece = false;

	ReportWindow window;

	@Execute
	public void execute(Shell shell, ParameterizedCommand cmd) {
		FileDialog fileDialog = new FileDialog(shell, SWT.SINGLE);
		fileDialog.setText("Choisir Image pour la Cuisine");
		fileDialog.setFilterExtensions(new String[] { "*.png", "*.jpg", "*.jpeg", "*.gif" });
		String result = fileDialog.open();
		if (result == null || result.isEmpty())
			return;
		File file = new File(result);
		String destination = ProjectManager.getManager().getCurrentProject().getProjectDirectory();
		destination = destination + File.separator + "reporting" + File.separator + "screenshot.png";
		File destFile = new File(destination);
		destFile.getParentFile().mkdirs();
		try {
			destFile.createNewFile();
			IOUtilities.copyFileUsingChannel(file, destFile);
		} catch (IOException e) {
			e.printStackTrace();
		}
		Gdx.app.postRunnable(new Runnable() {
			@Override
			public void run() {
				try {
					for (KitchenElement element : ProjectManager.getManager().getCurrentScene().getKitchenElements()) {
						element.generateImages();
					}
					List<String> wallViewsUrls = Room3DController.getInstance().takeWallViews();
					ProjectReport report = new ProjectReport(ProjectManager.getManager().getCurrentProject(), destFile.getPath(),
							wallViewsUrls);
					report.generate(true);

				} catch (Exception e) {
					Display.getDefault().asyncExec(new Runnable() {
						@Override
						public void run() {
							MessageDialog.openError(shell, "error", "failed to create report!\n" + e.getMessage());
							e.printStackTrace();
						}
					});
				}
			}
		});
	}

	@CanExecute
	public boolean canExecute() {
		return ProjectManager.getManager().getCurrentProject().getCurrentKitchen().getElements().size() > 0;
	}

}