package dressing.handlers;

import javax.inject.Inject;

import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

import dressing.model.Dressing;
import dressing.model.Project3D;
import dressing.ui.caisson.CaissonWizard;

public class AddCuissonWizardHandler {

	@Inject ESelectionService selectionService;
	
	@Inject
	IEclipseContext  eclipsecontext;
	@Execute
	public void execute(Shell shell){

		Object o = selectionService.getSelection("dressing.part.tree");
		//Voire l element de l arbre selectionne
		if(o!=null && o instanceof Dressing)
		{
			CaissonWizard cuissonwizrad = ContextInjectionFactory.make(CaissonWizard.class,eclipsecontext);
			cuissonwizrad.setDressing((Dressing) o);
			WizardDialog dialog = new WizardDialog(shell, cuissonwizrad);
			dialog.open();		
		}	
	}
	@CanExecute
	public boolean check()
	{
		Object o = selectionService.getSelection("dressing.part.tree");
		//Voire l element de l arbre selectionne
		if(o!=null && o instanceof Dressing)
		{
			return true;
		}	
		return false;
	}
}