/*
 * Decompiled with CFR 0.152.
 */
package org.frs.perspectiveswitcher.tools;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.frs.perspectiveswitcher.tools.E4Util;
import org.frs.perspectiveswitcher.tools.EPerspectiveSwitcher;
import org.frs.perspectiveswitcher.tools.IPerspectiveSwitcherControl;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class PerspectiveSwitcherSwtTrim
implements IPerspectiveSwitcherControl {
    @Inject
    private Logger logger;
    @Inject
    private EModelService modelService;
    @Inject
    private EPartService partService;
    @Inject
    private ECommandService commandService;
    @Inject
    private EHandlerService handlerService;
    @Inject
    private IResourceUtilities<?> resourceUtilities;
    @Inject
    private MWindow window;
    @Inject
    EPerspectiveSwitcher perspectiveSwitcher;
    Composite composite;
    ToolBar toolBar;
    @Inject
    @Preference(value="perspective_switcher_show_text", nodePath="org.frs.perspectiveswitcher")
    private boolean showShortcutText;
    static String _null = "";
    static RGB defaultContainerCurveColor = new RGB(0, 0, 0);
    Image openPerspectiveImage;
    Color internalCrvColor;
    Color containerCurveColor;

    @PreDestroy
    void cleanUp() {
        if (this.perspectiveSwitcher != null) {
            this.perspectiveSwitcher.setControlProvider(null);
        }
        this.perspectiveSwitcher = null;
        this.disposeToolBarImages();
        this.dispose();
    }

    @PostConstruct
    void createControl(Composite parent, MToolControl control) {
        this.perspectiveSwitcher.setControlProvider(this);
        this.composite = new Composite(parent, 0);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.marginRight = 8;
        rowLayout.marginLeft = 8;
        rowLayout.marginTop = 6;
        rowLayout.marginBottom = 4;
        this.composite.setLayout((Layout)rowLayout);
        this.composite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                PerspectiveSwitcherSwtTrim.this.paintContainer(event);
            }
        });
        this.composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                PerspectiveSwitcherSwtTrim.this.dispose();
            }
        });
        this.toolBar = new ToolBar(this.composite, 8519744);
        this.toolBar.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent event) {
                ToolBar tb = (ToolBar)event.widget;
                Point p = new Point(event.x, event.y);
                p = PerspectiveSwitcherSwtTrim.this.toolBar.getDisplay().map(null, (Control)PerspectiveSwitcherSwtTrim.this.toolBar, p);
                ToolItem item = tb.getItem(p);
                if (item != null && item.getData() != null) {
                    PerspectiveSwitcherSwtTrim.this.openMenuFor(item, (MPerspective)item.getData());
                } else if (item == null) {
                    PerspectiveSwitcherSwtTrim.this.logger.debug("No item found");
                } else {
                    PerspectiveSwitcherSwtTrim.this.logger.debug("Perspective not associated with item");
                }
            }
        });
        this.toolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                PerspectiveSwitcherSwtTrim.this.disposeToolBarImages();
            }
        });
        this.toolBar.getAccessible().addAccessibleListener(new AccessibleListener(){

            public void getName(AccessibleEvent e) {
            }

            public void getKeyboardShortcut(AccessibleEvent e) {
            }

            public void getHelp(AccessibleEvent e) {
            }

            public void getDescription(AccessibleEvent e) {
            }
        });
        List<MPerspectiveStack> appPerspectiveStacks = E4Util.getMatchingChildren(this.window, MPerspectiveStack.class);
        if (appPerspectiveStacks.size() > 0) {
            for (MPerspectiveStack stack : appPerspectiveStacks) {
                for (MPerspective perspective : stack.getChildren()) {
                    if (!perspective.isToBeRendered()) continue;
                    this.addPerspectiveShortcut(perspective);
                }
            }
        }
    }

    void paintContainer(PaintEvent event) {
        GC gc = event.gc;
        gc.setAdvanced(true);
        if (gc.getAdvanced()) {
            gc.setAntialias(1);
        }
        Point size = this.composite.getSize();
        int h = size.y;
        int[] nArray = new int[10];
        nArray[1] = h - 1;
        nArray[2] = 1;
        nArray[3] = h - 1;
        nArray[4] = 2;
        nArray[5] = h - 2;
        nArray[6] = 2;
        nArray[7] = 1;
        nArray[8] = 3;
        int[] simpleCurve = nArray;
        gc.setForeground(this.getContainerCurveColor(event));
        gc.drawPolyline(simpleCurve);
        Rectangle bounds = ((Control)event.widget).getBounds();
        bounds.y = 0;
        bounds.x = 0;
        Region r = new Region();
        r.add(bounds);
        int[] simpleCurveClose = new int[simpleCurve.length + 4];
        System.arraycopy(simpleCurve, 0, simpleCurveClose, 0, simpleCurve.length);
        int index = simpleCurve.length;
        simpleCurveClose[index++] = bounds.width;
        simpleCurveClose[index++] = 0;
        simpleCurveClose[index++] = bounds.width;
        simpleCurveClose[index++] = bounds.height;
        r.subtract(simpleCurveClose);
        Region clipping = new Region();
        gc.getClipping(clipping);
        r.intersect(clipping);
        gc.setClipping(r);
        clipping.dispose();
        r.dispose();
    }

    void openMenuFor(ToolItem item, MPerspective perspective) {
        final Menu menu = new Menu((Control)this.toolBar);
        menu.setData((Object)perspective);
        if (E4Util.isSelectedElement((MUIElement)perspective)) {
            this.addSaveAsMenuItem(menu);
            this.addResetMenuItem(menu);
        }
        if (perspective.isVisible()) {
            this.addCloseMenuItem(menu);
        }
        new MenuItem(menu, 2);
        this.addShowTextMenuItem(menu);
        Rectangle bounds = item.getBounds();
        Point point = this.toolBar.toDisplay(bounds.x, bounds.y + bounds.height);
        menu.setLocation(point);
        menu.setVisible(true);
        menu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
            }

            public void menuHidden(MenuEvent e) {
                PerspectiveSwitcherSwtTrim.this.toolBar.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        menu.dispose();
                    }
                });
            }
        });
    }

    void openPerspectiveDialog() {
        ParameterizedCommand command = this.commandService.createCommand("org.eclipse.e4.ui.perspectives.showPerspective", Collections.EMPTY_MAP);
        this.handlerService.executeHandler(command);
    }

    @Override
    public void addPerspectiveShortcut(MPerspective perspective) {
        ToolItem shortcut = new ToolItem(this.toolBar, 16);
        shortcut.setData((Object)perspective);
        ImageDescriptor descriptor = this.getIconFor(perspective.getIconURI());
        if (descriptor != null) {
            Image icon = descriptor.createImage();
            shortcut.setImage(icon);
        }
        if (descriptor == null || this.showShortcutText) {
            String label = perspective.getLocalizedLabel();
            shortcut.setText(label != null ? label : _null);
            shortcut.setToolTipText(perspective.getLocalizedTooltip());
        } else {
            shortcut.setText(_null);
            shortcut.setToolTipText(perspective.getLocalizedLabel());
        }
        shortcut.setSelection(E4Util.isSelectedElement((MUIElement)perspective));
        shortcut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MPerspective perspective = (MPerspective)event.widget.getData();
                E4Util.setWindowSelectedElement((MUIElement)perspective);
            }
        });
    }

    @Override
    public void removePerspectiveShortcut(MPerspective perspective) {
        ToolItem item = this.getToolItemFor(perspective);
        if (item == null || item.isDisposed()) {
            return;
        }
        Image icon = item.getImage();
        if (icon != null) {
            item.setImage(null);
            icon.dispose();
            icon = null;
        }
        item.dispose();
    }

    @Override
    public void setSelectedElement(MPerspective perspective) {
        ToolItem[] toolItemArray = this.toolBar.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem item;
            item.setSelection((item = toolItemArray[n2]).getData() == perspective);
            ++n2;
        }
    }

    @Override
    public void updateAttributeFor(MPerspective perspective, String attName, Object newValue) {
        ToolItem item = this.getToolItemFor(perspective);
        if (this.showShortcutText && "label".equals(attName)) {
            String newName = (String)newValue;
            item.setText(newName != null ? newName : _null);
        } else if ("tooltip".equals(attName)) {
            String newTip = (String)newValue;
            item.setToolTipText(newTip);
        } else if ("iconURI".equals(attName)) {
            ImageDescriptor descriptor = this.getIconFor((String)newValue);
            Image newIcon = null;
            Image oldIcon = item.getImage();
            if (descriptor != null) {
                newIcon = descriptor.createImage();
            }
            item.setImage(newIcon);
            if (oldIcon != null) {
                oldIcon.dispose();
                oldIcon = null;
            }
            if (!this.showShortcutText) {
                String label = null;
                label = item.getData() instanceof MPerspective ? ((MPerspective)item.getData()).getLocalizedLabel() : item.getText();
                item.setText(item.getImage() == null ? label : _null);
            }
        }
    }

    @Inject
    void setShowText(@Preference(value="perspective_switcher_show_text", nodePath="org.frs.perspectiveswitcher") boolean showShortcutText) {
        this.showShortcutText = showShortcutText;
        if (this.toolBar == null || this.toolBar.isDisposed()) {
            return;
        }
        ToolItem[] toolItemArray = this.toolBar.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem item = toolItemArray[n2];
            if (item.getData() instanceof MPerspective) {
                MPerspective perspective = (MPerspective)item.getData();
                if (item.getImage() == null || this.showShortcutText) {
                    String label = perspective.getLocalizedLabel();
                    item.setText(label != null ? label : _null);
                    item.setToolTipText(perspective.getLocalizedTooltip());
                } else {
                    item.setText(_null);
                    item.setToolTipText(perspective.getLocalizedLabel());
                }
            }
            ++n2;
        }
    }

    ToolItem getToolItemFor(MPerspective perspective) {
        if (this.toolBar == null || this.toolBar.isDisposed()) {
            return null;
        }
        ToolItem toolItem = null;
        int i = 2;
        while (i < this.toolBar.getItems().length && toolItem == null) {
            if (this.toolBar.getItem(i).getData() == perspective) {
                toolItem = this.toolBar.getItem(i);
            }
            ++i;
        }
        return toolItem;
    }

    ImageDescriptor getIconFor(String iconURI) {
        ImageDescriptor descriptor = null;
        try {
            URI uri = URI.createURI((String)iconURI);
            descriptor = (ImageDescriptor)this.resourceUtilities.imageDescriptorFromURI(uri);
        }
        catch (RuntimeException ex) {
            this.logger.debug((Throwable)ex, "icon uri=" + iconURI);
        }
        return descriptor;
    }

    Image getOpenPerspectiveImage() {
        if (this.openPerspectiveImage == null || this.openPerspectiveImage.isDisposed()) {
            Bundle bundle = FrameworkUtil.getBundle(this.getClass());
            URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/full/eview16/new_persp.gif"), null);
            ImageDescriptor imageDescr = ImageDescriptor.createFromURL((URL)url);
            return imageDescr.createImage();
        }
        return null;
    }

    Color getContainerCurveColor(PaintEvent event) {
        Color curveColor = this.containerCurveColor;
        if (curveColor == null) {
            curveColor = this.internalCrvColor != null ? this.internalCrvColor : new Color((Device)event.display, defaultContainerCurveColor);
        }
        return curveColor;
    }

    private void dispose() {
        if (this.internalCrvColor != null) {
            this.internalCrvColor.dispose();
            this.internalCrvColor = null;
        }
    }

    private void disposeToolBarImages() {
        if (this.toolBar == null || this.toolBar.isDisposed()) {
            return;
        }
        ToolItem[] toolItemArray = this.toolBar.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem item = toolItemArray[n2];
            Image icon = item.getImage();
            if (icon != null) {
                item.setImage(null);
                icon.dispose();
                icon = null;
            }
            ++n2;
        }
    }

    private void addSaveAsMenuItem(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 26);
        menuItem.setText("Save &As...");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ParameterizedCommand command = PerspectiveSwitcherSwtTrim.this.commandService.createCommand("org.eclipse.e4.ui.perspectives.saveAs", Collections.EMPTY_MAP);
                PerspectiveSwitcherSwtTrim.this.handlerService.executeHandler(command);
            }
        });
    }

    private void addResetMenuItem(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 26);
        menuItem.setText("&Reset");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ParameterizedCommand command = PerspectiveSwitcherSwtTrim.this.commandService.createCommand("org.eclipse.e4.ui.perspectives.reset", Collections.EMPTY_MAP);
                PerspectiveSwitcherSwtTrim.this.handlerService.executeHandler(command);
            }
        });
    }

    private void addCloseMenuItem(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 26);
        menuItem.setText("&Close");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ParameterizedCommand command = PerspectiveSwitcherSwtTrim.this.commandService.createCommand("org.eclipse.e4.ui.perspectives.close", Collections.EMPTY_MAP);
                PerspectiveSwitcherSwtTrim.this.handlerService.executeHandler(command);
            }
        });
    }

    private void addShowTextMenuItem(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 58);
        menuItem.setText("Show &Text");
        menuItem.setSelection(this.showShortcutText);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                HashMap parameters = new HashMap(3);
                ParameterizedCommand command = PerspectiveSwitcherSwtTrim.this.commandService.createCommand("org.eclipse.e4.ui.perspectives.showText", parameters);
                PerspectiveSwitcherSwtTrim.this.handlerService.executeHandler(command);
            }
        });
    }
}

