package gdxapp.tests;

import java.util.ArrayList;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Cubemap;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.Pixmap.Format;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.*;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.FloatAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.utils.CameraInputController;
import com.badlogic.gdx.graphics.g3d.utils.DefaultShaderProvider;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;

import gdxapp.assets.AssetsTextures;
import gdxapp.shaders.DepthMapShader;
import gdxapp.shaders.DirectionalLight;
import gdxapp.shaders.Light;
import gdxapp.shaders.SceneShader;


public class ShaderTest implements Screen {

	 ModelBuilder modelBuilder;
	    ArrayList<ModelInstance> sceneObjects;
	    PerspectiveCamera camera;
	    ModelBatch depthBatch;
	    ModelBatch modelBatch;
	    ModelBatch skyBatch;
	    CameraInputController cameraInputController;
	    Texture texture;
	    Cubemap cubemap;
	    ModelInstance skybox;
	    public final static int DEPTHMAPSIZE = 2048;
	    ModelInstance polygon3D;
	   // EnvironmentCubemap cmap;

	    DepthMapShader depthShader;
	    SceneShader sceneShader;
	   // SkyBoxShader skyboxShader;
	    ArrayList<Texture> depthMaps = new ArrayList<>();
	    FrameBuffer frameBuffer;

	    ArrayList<Light> lights;



	    public ShaderTest(){
	        init();
	    }

	    public ShaderTest(ArrayList<Vector2> vertices){
	        init();
	       // createPolygon3D(vertices);
	    }

//	    private void createPolygon3D(ArrayList<Vector2> vertices) {
//	        Material material = new Material();
//	        material.set(TextureAttribute.createDiffuse(texture));
//	        ColorAttribute specularAttribute = ColorAttribute.createSpecular(new Color(0.5f,0.5f,0.5f,1.0f));
//	        material.set(specularAttribute);
//	        FloatAttribute shininessAttribute = FloatAttribute.createShininess(32);
//	        material.set(shininessAttribute);
//	        FloatAttribute opacityAttribute = FloatAttribute.createAlphaTest(1.0f);
//	        material.set(opacityAttribute);
//	        modelBuilder.begin();
//	        PolygonBuilder.createPolygoneNode(modelBuilder,"poly",vertices,new Vector3(),material);
//	        Model model = modelBuilder.end();
//	        polygon3D = new ModelInstance(model);
//	        this.sceneObjects.add(polygon3D);
//	    }

	    public void init(){
	        texture = AssetsTextures.getInstance().getTexture("bbb");
	        texture.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
	        camera = new PerspectiveCamera(60, Gdx.graphics.getWidth(),Gdx.graphics.getHeight());
	        camera.near = 1.0f;
	        camera.far = 50;
	        camera.up.set(0,1,0);
	        camera.position.set(0,1,-5);
	        camera.lookAt(0,1,1);
	        camera.update();
	        cameraInputController = new CameraInputController(camera);
	        modelBuilder = new ModelBuilder();
	        buildScene();
	        depthShader = new DepthMapShader();
	        depthShader.init();
	        depthBatch = new ModelBatch(new DefaultShaderProvider(){
	            @Override
	            protected Shader createShader(Renderable renderable) {
	                return depthShader;
	            }
	        });
	        sceneShader = new SceneShader();
	        sceneShader.init();
	        modelBatch = new ModelBatch(new DefaultShaderProvider(){
	            @Override
	            protected Shader createShader(Renderable renderable) {
	                return sceneShader;
	            }
	        });
//	        skyboxShader = new SkyBoxShader(cubemap);
//	        skyboxShader.init();
//	        skyBatch = new ModelBatch(new DefaultShaderProvider(){
//	            @Override
//	            protected Shader createShader(Renderable renderable) {
//	                return  skyboxShader;
//	            }
//	        });

	        prepareLights();
	    }

	    private void buildScene() {
	        int attr = VertexAttributes.Usage.Position | VertexAttributes.Usage.Normal | VertexAttributes.Usage.TextureCoordinates;
	        Material material = new Material();
	        material.set(TextureAttribute.createDiffuse(texture));
	        ColorAttribute specularAttribute = ColorAttribute.createSpecular(new Color(0.5f,0.5f,0.5f,1.0f));
	        material.set(specularAttribute);
	        FloatAttribute shininessAttribute = FloatAttribute.createShininess(32);
	        material.set(shininessAttribute);
	        FloatAttribute opacityAttribute = FloatAttribute.createAlphaTest(1.0f);
	        material.set(opacityAttribute);
	        this.sceneObjects = new ArrayList<ModelInstance>();
	        Model cube = modelBuilder.createBox(20,0.5f,20, material, attr);
	        Model sphere = modelBuilder.createSphere(2,2,2, 40,40, material, attr);
	        ModelInstance sphereInstance = new ModelInstance(sphere);
	        sphereInstance.transform.setToTranslation(1,1,0);
	        ModelInstance cubeInstance = new ModelInstance(cube);
	        cubeInstance.transform.setToTranslation(-1,0,0);
	        ModelInstance ground = new ModelInstance(cube);
	        //ground.transform.translate(0,-1,0);
	        sceneObjects.add(sphereInstance);
	       //sceneObjects.add(cubeInstance);
	        sceneObjects.add(ground);
	        //loadCubemaps();
	       // this.skybox = createSkyBox();
	    }

	    @Override
	    public void show() {
	        Gdx.input.setInputProcessor(cameraInputController);

	    }

	    @Override
	    public void render(float delta) {
	        cameraInputController.update();
	        //cmap.render(camera);
	        renderLights();
	        renderFinalPass();
	    }

	    private void renderFinalPass() {
	        Gdx.gl20.glClearColor(0/255f, 0/255,0/255, 1.0f);
	        Gdx.gl.glClear(GL20.GL_COLOR_BUFFER_BIT | GL20.GL_DEPTH_BUFFER_BIT | (Gdx.graphics.getBufferFormat().coverageSampling ? GL20.GL_COVERAGE_BUFFER_BIT_NV : 0));
	        sceneShader.setLights(this.lights);
	        modelBatch.begin(camera);
	        for(ModelInstance instance: sceneObjects){
	            modelBatch.render(instance);
	        }
	        modelBatch.end();
	    }

	    public void renderLights(){
	        if (frameBuffer == null)
	        {
	            frameBuffer = new FrameBuffer(Format.RGBA8888, DEPTHMAPSIZE, DEPTHMAPSIZE, true);
	        }
	        frameBuffer.begin();
	        for(Light light: lights){
	            Gdx.gl.glClearColor(0, 0, 0, 1);
	            Gdx.gl.glClear(GL20.GL_COLOR_BUFFER_BIT | GL20.GL_DEPTH_BUFFER_BIT | (Gdx.graphics.getBufferFormat().coverageSampling ? GL20.GL_COVERAGE_BUFFER_BIT_NV : 0));
	            if(light instanceof DirectionalLight) {
	            	 depthBatch.begin(((DirectionalLight) light).getCamera());
	 	            for(ModelInstance instance: this.sceneObjects) {
	 	                depthBatch.render(instance);
	 	            }
	 	            depthBatch.end();
	 	            ((DirectionalLight) light).setDepthMap(frameBuffer.getColorBufferTexture());
	            }
	           
	        }
	        frameBuffer.end();
	    }

	    @Override
	    public void resize(int width, int height) {

	    }

	    @Override
	    public void pause() {

	    }

	    @Override
	    public void resume() {

	    }

	    @Override
	    public void hide() {

	    }

	    @Override
	    public void dispose() {

	        modelBatch.dispose();
	        texture.dispose();
	    }

	    public ModelInstance createSkyBox(){
	        Model cube = modelBuilder.createBox(2,2,2,new Material(), VertexAttributes.Usage.Position);
	        return new ModelInstance(cube);
	    }

//	    public void loadCubemaps() {
//	        Pixmap[] faces = new Pixmap[6];
//	        String[] sides = new String[]{
//	                    "posx", "negx", "posy", "negy", "posz", "negz"};
//	        for(int i = 0; i < 6 ; i++) {
//	            faces[i] = new Pixmap(Gdx.files.internal("Yokohama2" + File.separator + sides[i]+ ".jpg"));
//	        }
//	        cubemap = new Cubemap(faces[0], faces[1], faces[2], faces[3], faces[4], faces[5]);
//	        cubemap.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
//	        cubemap.setWrap(Texture.TextureWrap.ClampToEdge, Texture.TextureWrap.ClampToEdge);
//	        cmap = new EnvironmentCubemap(faces[0],faces[1],faces[2],faces[3],faces[4],faces[5]);
//	    }

	    public void prepareLights(){
	    	DirectionalLight light_1 = new DirectionalLight();
	        light_1.setPosition(new Vector3(2,4,2));
	        light_1.setDirection(light_1.getPosition().cpy().scl(-1).nor());
	        light_1.setIntensity(new Vector3(0.5f,0.3f,0.3f));
	        DirectionalLight light_2 = new DirectionalLight();
	        light_2.setPosition(new Vector3(-2,4,2));
	        light_2.setDirection(light_2.getPosition().cpy().scl(-1).nor());
	        light_2.setIntensity(new Vector3(0.3f,0.5f,0.3f));
	        if(lights == null)
	            lights = new ArrayList<>();
	        lights.add(light_1);
	        lights.add(light_2);

	    }
}
