package dressing.ui.update;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CBanner;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Label;
import update.FRSUpdateManager;
import update.UpdatorException;

import org.eclipse.swt.widgets.Button;
import swing2swt.layout.BorderLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.ProgressBar;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Text;

import com.google.inject.Inject;

public class UpdateComposite extends Composite {

	@Inject UISynchronize sync;
	FRSUpdateManager updateManager;
	private Label lblProduct;
	private Label lblVersion;
	private Label lblInstalled;
	private String logger;
	private Text text;
	Button btnSearchUpdate;
	private DataBindingContext m_bindingContext;
	private IWorkbench workbench;
	private String lastRelease;
	private UpdateProductWizard parentWizard;

	public UpdateComposite(Composite parent, int style) {
		super(parent, style);
		if(updateManager == null)
			updateManager = FRSUpdateManager.getInstance();
		updateManager.setWorkbench(getWorkbench());
		setLayout(new FillLayout(SWT.HORIZONTAL));
		
		Composite composite = new Composite(this, SWT.NONE);
		composite.setLayout(new FillLayout(SWT.HORIZONTAL));
		
		CBanner banner = new CBanner(composite, SWT.NONE);
		banner.setEnabled(true);
		banner.setRightWidth(200);
		banner.setRightMinimumSize(new Point(200, 200));
		
		Composite composite_1 = new Composite(banner, SWT.NONE);
		banner.setRight(composite_1);
		composite_1.setLayout(new GridLayout(2, false));
		new Label(composite_1, SWT.NONE);
		new Label(composite_1, SWT.NONE);
		
		Label lblNewLabel = new Label(composite_1, SWT.NONE);
		lblNewLabel.setText("produit:");
		
		lblProduct = new Label(composite_1, SWT.NONE);
		lblProduct.setText("product");
		lblProduct.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		
		Label lblNewLabel_2 = new Label(composite_1, SWT.NONE);
		lblNewLabel_2.setText("version:");
		
		lblVersion = new Label(composite_1, SWT.NONE);
		lblVersion.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblVersion.setText("version");
		
		Label lblNewLabel_4 = new Label(composite_1, SWT.NONE);
		lblNewLabel_4.setText("date d'installation");
		
		lblInstalled = new Label(composite_1, SWT.NONE);
		lblInstalled.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblInstalled.setText("date");
		
		Composite composite_2 = new Composite(banner, SWT.NONE);
		banner.setLeft(composite_2);
		composite_2.setLayout(new BorderLayout(0, 0));
		
		btnSearchUpdate = new Button(composite_2, SWT.NONE);
		btnSearchUpdate.setLayoutData(BorderLayout.SOUTH);
		btnSearchUpdate.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseDown(MouseEvent e) {
				text.setText("searchnig for updates in local system..");
			
				boolean updateAvailable = updateManager.checkLocal();
				if(updateAvailable) {
					MessageDialog.openQuestion(parent.getShell(), "mise à jour trouvé", "un mise à jour est en attente d'etre installé \n"
							+ "voulez vous l'installez maintenant?");
				}else {
					Job job = Job.create("download Update", (ICoreRunnable) monitor -> {
						try {
							updateManager.downloadUpdate();
						} catch (UpdatorException e1) {
							// TODO Auto-generated catch block
							e1.printStackTrace();
						}
					});
					job.schedule();
					parentWizard.getShell().close();
				}
			}});
		btnSearchUpdate.setText("télecharger et installer");
		btnSearchUpdate.setEnabled(false);

	ProgressBar progressBar = new ProgressBar(composite_2, SWT.NONE);progressBar.setLayoutData(BorderLayout.CENTER);

	text=new Text(composite_2,SWT.BORDER|SWT.MULTI);text.setLayoutData(BorderLayout.NORTH);text.setEditable(false);
	Composite composite_3 = new Composite(banner,
			SWT.NONE);banner.setBottom(composite_3);composite_3.setLayout(new RowLayout(SWT.HORIZONTAL));

	Label lblForRightSolution = new Label(composite_3,
			SWT.NONE);lblForRightSolution.setAlignment(SWT.RIGHT);lblForRightSolution.setText("For Right Solution 2021");

	m_bindingContext=

	initDataBindings();

	checkForUpdate();if(lastRelease!=null)

	{
		text.setText("une nouvelle version v-" + lastRelease + " est disponible");
	}else
	{
		text.setText("le logiciel est à jour");
	}
	// TODO Auto-generated constructor stub
	}

	public String getLogger() {
		return logger;
	}

	public void setLogger(String logger) {
		this.logger = logger;
	}

	public IWorkbench getWorkbench() {
		return workbench;
	}

	public void setWorkbench(IWorkbench workbench) {
		this.workbench = workbench;
	}
	
	

	public UpdateProductWizard getParentWizard() {
		return parentWizard;
	}

	public void setParentWizard(UpdateProductWizard parent) {
		this.parentWizard = parent;
	}

	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeTextLblProductObserveWidget = WidgetProperties.text().observe(lblProduct);
		IObservableValue pRODUCTUpdateManagerObserveValue = BeanProperties.value("PRODUCT").observe(updateManager);
		bindingContext.bindValue(observeTextLblProductObserveWidget, pRODUCTUpdateManagerObserveValue, null, null);
		//
		IObservableValue observeTextLblVersionObserveWidget = WidgetProperties.text().observe(lblVersion);
		IObservableValue currentversionUpdateManagerObserveValue = BeanProperties.value("currentversion")
				.observe(updateManager);
		bindingContext.bindValue(observeTextLblVersionObserveWidget, currentversionUpdateManagerObserveValue, null,
				null);
		//
		IObservableValue observeTextLblInstalledObserveWidget = WidgetProperties.text().observe(lblInstalled);
		IObservableValue releaseDateUpdateManagerObserveValue = BeanProperties.value("releaseDate")
				.observe(updateManager);
		bindingContext.bindValue(observeTextLblInstalledObserveWidget, releaseDateUpdateManagerObserveValue, null,
				null);
		//
		return bindingContext;
	}

	public void checkForUpdate() {
		if (this.updateManager.lookupForUpdates())
			lastRelease = this.updateManager.getLastRelease();
			btnSearchUpdate.setEnabled(true);
	}
}
