package dressing.model;

import java.util.ArrayList;
import java.util.List;

import dressing.model.debitage.DebitageFormulas;
import dressing.model.debitage.SuportBasDebitageFormulas;
import dressing.model.debitage.SuportHautDebitageFormulas;
import dressing.model.evalutor.Equation;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.CharniereType;
import dressing.model.types.SupportMeubleHautType;
import dressing.model.types.TrouType;
import dressing.model.usinage.Direction;
import dressing.model.usinage.Trou;
import dressing.model.usinage.Usinage;
import tech.frsdev.solids.Solide3D;

/**
 * @Bug 0001866: ajouter les support pour les caisson bas 
 *  {@link SupportMeubleHaut}  est le model Accessoire du support des caisson haut
 * @author Imed
 *
 */
public class SupportMeubleHaut extends Accessoire {

	SupportMeubleHautType supportType=SupportMeubleHautType.LEFT;	
			
	@Override
	public boolean canHold(DesignObject3D child) {
		if(child instanceof Usinage) {
			return true;
		}
		return false;
	}
	
	@Override
	public boolean isdrawable() {
		return false;
	}
	
	@Override
	public List getChildren() {
		if(childs==null ) {
			childs =new ArrayList<DesignObject3D>();
		}
		return childs;
	}
	
	public SupportMeubleHautType getSupportType() {
		return supportType;
	}
	public void setSupportType(SupportMeubleHautType supportType) {
		SupportMeubleHautType oldValue = this.supportType;
		this.supportType = supportType;
		firePropertyChange("supportType", oldValue, supportType);
	}

	@Override
	public SupportMeubleHaut clone() {

		SupportMeubleHaut support=new SupportMeubleHaut();
		support.setSupportType(getSupportType());
		support=(SupportMeubleHaut) this.copy(support);
		return support;
	}
	
	/**
	 * @author imed 
	 * @Bug 0001217 
	 * Créer les usinage necessaire pour cette Accessoire(Support Bas {@link SupportMeubleHaut})
	 * créer les trous d'usinage 
	 */
	@Override
	public void createUsinage() throws GeometricEngineException, DesignException {
		Piece2D piece=(Piece2D) getParentdesign();

		Cavity c1 = new Cavity();

		c1.setName("cavité " + getName());
		c1.setMother(this);
		c1.setParentdesign(piece);
		
		c1.constructDebitage();
		c1.evaluate();
		piece.addElement(c1);

 	}
	
	@Override
	public DebitageFormulas getDebitageFormulas() {
		if(formulas==null|| !(formulas instanceof SuportHautDebitageFormulas)) {
			formulas = new SuportHautDebitageFormulas();
		}
		return formulas; 
	}
}
