package reporting.htmlReporting;

import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.frs.html.JavaCodeEvaluator;

import dressing.config.WorkspaceConfiguration;
import dressing.io.IOUtilities;
import dressing.model.DesignObject3D;
import dressing.model.Kitchen;
import dressing.model.ModelProvider;
import dressing.model.ProjectManager;
import dressing.model.SuperCadProject;
import dressing.reporting.data.handle.ProjectCoupe;
import gdxapp.object3d.KitchenElement;
import gdxapp.screens.room3d.Room3DController;

public class ProjectReport extends HtmlReport{
	
	
	private SuperCadProject project;
	private Map<KitchenElement, String[]> picturesPath = new HashMap<KitchenElement, String[]>();
	private List<String> wallViewsUrl;
	private final String template_path = "src/reporting/htmlReporting/templates/ProjectReport.html";
	private HashMap<DesignObject3D, ElementReport> elementsReport;
	private HashMap<ElementReport, String> links;
	private ProjectCoupe projectCoupe;
	private String screenShotURI;
	private String reportDir;

	
	public ProjectReport(SuperCadProject project, String screenshot, List<String> wallViews) {
		super();
		this.project = project;
		this.wallViewsUrl = wallViews;
		this.projectCoupe = new ProjectCoupe(false, project);
		this.screenShotURI = screenshot;
		this.reportDir = project.getProjectDirectory() + File.separator + "reporting";
		createURI();
		bind();
	}

	public void createURI() {
		String host = WorkspaceConfiguration.JETTY_HOST;
		//screenshot
		File file = new File(this.screenShotURI);
		this.screenShotURI = host + "/" + file.getName();		
		//elements pictures
		picturesPath.clear();
		for(KitchenElement element: ProjectManager.getManager().getCurrentScene().getKitchenElements()) {
			String[] paths= new String[2];
			File  imgFile  = new File(element.getPathToBackImage());
			paths[0] = host + File.separator + imgFile.getName();
			imgFile = new File(element.getPathToFrontImage());
			paths[1] = host + File.separator + imgFile.getName();
			picturesPath.put(element, paths);
		}
	}
	
	public void bind() {
		File logoFile = new File(ModelProvider.getModelroot().getConfig().getLogoPath());
		File logoDestination = new File(reportDir + File.separator + "logo.png"); 
		try {
			IOUtilities.copyFileUsingChannel(logoFile, logoDestination);
			binding.put("$logo$", WorkspaceConfiguration.JETTY_HOST + "/" + logoDestination.getName());
		} catch (IOException e) {
			e.printStackTrace();
		}
		binding.put("$project$", this.project);
		binding.put("$creation_date$", this.project.getCreationDate().toLocalDate());
		binding.put("$faceUrls$", wallViewsUrl);
		List<DesignObject3D> elements = new ArrayList<DesignObject3D>( this.project.getKitchens().get(0).getElements());
		ArrayList<DesignObject3D> fakeFacades = new ArrayList<DesignObject3D>();
		for(DesignObject3D design: elements) {
			String type =  design.getDesignCaissonType();
			if(type.equals("FAUSSE_FACADE"))
				fakeFacades.add(design);
		}
		elements.removeAll(fakeFacades);
		
		binding.put("$elements$", elements);
		binding.put("$fake_facades$", fakeFacades);
		binding.put("$capture$", this.screenShotURI);
		elementsReport = new HashMap<DesignObject3D, ElementReport>();
		links = new HashMap<ElementReport, String>();
		String tmpFolderPath = "elements";
		for(KitchenElement element: project.getKitchens().get(0).getScene().getKitchenElements()) {
			ElementReport eltReport = new ElementReport(element);
			try {
				eltReport.setPathToBackImg(picturesPath.get(element)[0]);
				eltReport.setPathToFrontImg(picturesPath.get(element)[1]);
			}catch (Exception e) {
				System.out.println("error in fetching element pictures!");
			}
			eltReport.bind();
			eltReport.generate(false);
			elementsReport.put(element.getDesignObject(), eltReport);
			UUID id = UUID.randomUUID();
			String path = tmpFolderPath + File.separator + id + ".html";
			links.put(eltReport, path);
		}
		binding.put("$reports$", elementsReport);
		binding.put("$links$", links);
		binding.put("$kitchen$",  project.getKitchens().get(0));
	}

	@Override
	public void loadTemplate() {
		loadTemplateFile(this.template_path);
	}

	@Override
	public void writeAndDisplay() {
		String rootFolder = ProjectManager.getManager().getCurrentProjectDirectory() + File.separator + "reporting";
		String path = rootFolder + File.separator + "debitage.html";
		if(path!= null && !path.isEmpty()) {
			path +=".html";
			File file = new File(path);
			File tmpFolder;
			try {
				file.createNewFile();
				tmpFolder = file.getParentFile();
				tmpFolder.mkdir();
				writeElementReports(tmpFolder);
				FileOutputStream fos = new FileOutputStream(file);
				fos.write(doc.toString().getBytes());
				fos.close();
				String fileURI = WorkspaceConfiguration.JETTY_HOST + "/" + file.getName();
				System.out.println(fileURI);
				JettyServer.getInstance().restart(rootFolder);
				URI url = new URI(fileURI);
				Desktop.getDesktop().browse(url);
			}catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	private void writeElementReports(File tmpFolder) {
		for(KitchenElement element: project.getKitchens().get(0).getScene().getKitchenElements() ) {
			ElementReport report = elementsReport.get(element.getDesignObject());
			String path = tmpFolder.getAbsolutePath() + File.separator +  links.get(report);
			try {
				File file = new File(path);
				file.getParentFile().mkdirs();
				file.createNewFile();
				FileOutputStream fos = new FileOutputStream(file);
				fos.write(report.getDoc().toString().getBytes());
				fos.close();
			}catch (Exception e) {
				System.out.println("failed to write element report");
				continue;
			}
		}
	}
	
}
