package dressing.ui.util;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.wb.swt.SWTResourceManager;

import dressing.ui.parts.GdxPart;
import gdxapp.Commun.Fleche;

public class FlecheEditorWindow extends EditorWindow {
	private static FlecheEditorWindow instance;
	
	public static FlecheEditorWindow getInstance() {
 		synchronized(FlecheEditorWindow.class) {
 			if (instance == null) {
 				instance = new FlecheEditorWindow(GdxPart.parentShell);
 				instance.create();
 				instance.constrainShellSize();
 			}
 			return instance;
 		}
	}

	private Spinner spnOffset;
	private Label lblRetrait;
	private Spinner spnLength;
	private Fleche selectedFleche;
	private Button ddouble;
	private Button end;
	private Button start;
	private Color color;
	private Label colorLabel;
	
	public FlecheEditorWindow(Shell parentShell) {
		super(parentShell);
		// TODO Auto-generated constructor stub
	}

	@Override
	protected Composite createClientArea(Composite parent) {
		Composite composite = new Composite(parent, SWT.FILL);
		composite.setTouchEnabled(true);
		composite.setLayout(new GridLayout(3, false));

		Label lblLongeur = new Label(composite, SWT.NONE);
		lblLongeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblLongeur.setText("Longeur");

		spnLength = new Spinner(composite, SWT.BORDER);
		spnLength.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		spnLength.setMaximum(100000000);
		spnLength.setMinimum(-1000000);

		lblRetrait = new Label(composite, SWT.NONE);
		lblRetrait.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblRetrait.setText("Retrait");

		spnOffset = new Spinner(composite, SWT.BORDER);
		spnOffset.setMaximum(1000);
		spnOffset.setMinimum(10);
		spnOffset.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		Label lblCoulour = new Label(composite, SWT.NONE);
		lblCoulour.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblCoulour.setText("Coulour");

		colorLabel = new Label(composite, SWT.NONE);
		colorLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		colorLabel.setText("                                                              ");
		colorLabel.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_FOREGROUND));

		Button btncolorChooser = new Button(composite, SWT.NONE);
		btncolorChooser.setText("...");
		btncolorChooser.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				// Create the color-change dialog
				ColorDialog dlg = new ColorDialog(shell);

				// Set the selected color in the dialog from
				// user's selected color
				dlg.setRGB(colorLabel.getBackground().getRGB());

				// Change the title bar text
				dlg.setText("Choose a Color");

				// Open the dialog and retrieve the selected color
				RGB rgb = dlg.open();
				if (rgb != null) {
					// Dispose the old color, create the
					// new one, and set into the label
					color.dispose();
					color = new Color(shell.getDisplay(), rgb);
					colorLabel.setBackground(color);

				}
			}
		});
		Group dir = new Group(composite, SWT.NONE);
		dir.setText("Direction");
		dir.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 3, 1));
		dir.setLayout(new GridLayout(3, false));
		start = new Button(dir, SWT.RADIO);
		start.setLayoutData(new GridData(SWT.LEFT, SWT.FILL, true, true, 1, 1));
		start.setText("Debut");
		end = new Button(dir, SWT.RADIO);
		end.setLayoutData(new GridData(SWT.LEFT, SWT.FILL, true, true, 1, 1));
		end.setText("Fin");
		ddouble = new Button(dir, SWT.RADIO);
		ddouble.setLayoutData(new GridData(SWT.LEFT, SWT.FILL, true, true, 1, 1));
		ddouble.setText("Double");
		color = new Color(shell.getDisplay(), new RGB(0, 255, 0));
		return composite;
	}

	@Override
	public void terminer() {
		float scale=selectedFleche.getFlecheSegment().getScale();
		float l=FlecheEditorWindow.this.spnLength.getSelection();
		l /= 1000;
		l *=scale;
		//implent update logic here
		selectedFleche.getFlecheSegment().setLength(l, 1);
		float offset=FlecheEditorWindow.this.spnOffset.getSelection();
		offset/=1000;
		offset *= scale;
		selectedFleche.getLine().setOffset(offset);
		if(start.getSelection()) {
			selectedFleche.setDirection(Fleche.START);
		}else
		if(end.getSelection()) {
			selectedFleche.setDirection(Fleche.END);
		}else
		if(ddouble.getSelection()) {
			selectedFleche.setDirection(Fleche.DOUBLE);
		}
		selectedFleche.getLine().setColor(new com.badlogic.gdx.graphics.Color(color.getRed()/255.0f, color.getGreen()/255.0f, color.getBlue()/255.0f, color.getAlpha()/255.0f));
	}

	public void setFleche(Fleche selectedFleche, boolean b) {
		this.selectedFleche = selectedFleche;
		if(selectedFleche!=null)
		{
			float l = this.selectedFleche.getFlecheSegment().getMeasurement();
			this.spnLength.setSelection(Math.round(l * 1000));
			float offset = this.selectedFleche.getLine().getOffset() / this.selectedFleche.getFlecheSegment().getScale();
			this.spnOffset.setSelection(Math.round(offset * 1000));
			if(selectedFleche.getDirection()==Fleche.START) {
				start.setSelection(true);
				end.setSelection(false);
				ddouble.setSelection(false);

			}else
			if(selectedFleche.getDirection()==Fleche.END) {
				end.setSelection(true);
				start.setSelection(false);
				ddouble.setSelection(false);
			}else
			if(selectedFleche.getDirection()==Fleche.DOUBLE) {
				ddouble.setSelection(true);
				end.setSelection(false);
				start.setSelection(false);
			}
			color.dispose();
		    color = new Color(shell.getDisplay(), new RGBA((int)(this.selectedFleche.getLine().getColor().r*255), (int)(this.selectedFleche.getLine().getColor().g*255), (int)(this.selectedFleche.getLine().getColor().b*255), (int)(this.selectedFleche.getLine().getColor().a*255)));
		    colorLabel.setBackground(color);
		}
		
	}

}
