package dressing.ui.usinage;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Text;

import dressing.cam.model.Tool;
import dressing.model.DesignException;
import dressing.model.IUpdateStructure;
import dressing.model.ModelProvider;

import dressing.model.usinage.Usinage;

import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.core.databinding.Binding;

public class RainureEditorComposite extends Composite implements IUpdateStructure{
	private Binding toolbinding;
	private DataBindingContext m_bindingContext;
	Usinage usin;
	private Combo combotool;
	private MDirtyable dirty;
	ComboViewer comboViewer;
	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 */
	public RainureEditorComposite(Composite parent, int style, Usinage selection) {
		super(parent, style);
		this.usin=selection;
		setLayout(new GridLayout(2, false));
		
		Label lblTool = new Label(this, SWT.NONE);
		lblTool.setLayoutData(new GridData(SWT.RIGHT, SWT.FILL, false, false, 1, 1));
		lblTool.setText("Tool");
		
		 comboViewer = new ComboViewer(this, SWT.NONE);
		combotool = comboViewer.getCombo();
		combotool.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		comboViewer.setContentProvider(ArrayContentProvider.getInstance());
		comboViewer.setLabelProvider(new LabelProvider() {
		     @Override
		     public String getText(Object element) {
		         if (element instanceof Tool) {
		        	 Tool tool = (Tool) element;
		             return tool.getName();
		         }
		         return super.getText(element);
		     }
		 });
		comboViewer.setInput(ModelProvider.getTools());
		makedirtycontroller(this);
		if(usin!=null) {
			m_bindingContext = initDataBindings();
		}

	}
	public void setDirty(MDirtyable dirty) {
		this.dirty = dirty;
	}
	public MDirtyable getDirty() {
		return dirty;
	}
	public void updateDirty()
	{
		if(this.dirty!=null)
		{
			this.dirty.setDirty(true);
		}
	}
	protected void makedirtycontroller(Composite composite)
	{
		//Faire la mise ajour des controel pour qui enregistre le dirty
				Control [] ctrl = this.getChildren();
			
				for(Control ctr : composite.getChildren())
				{	
					if(ctr instanceof Composite ) {
						for(Control ctrs : ((Composite)ctr).getChildren()) {
							if(ctrs instanceof Composite) {
								makedirtycontroller((Composite) ctrs);
							}else {
								makeControldirtyController(ctrs);
							}
						}
					}
					
					makeControldirtyController(ctr);		
					
				}
				if(!(composite instanceof TabFolder)) {
					makeControldirtyController(composite);
				}
	}
	protected void makeControldirtyController(Control ctr) {
		if(ctr instanceof Text)
		{
			((Text) ctr).addKeyListener(new KeyListener() {
				
				@Override
				public void keyReleased(KeyEvent e) {
					// TODO Auto-generated method stub
					updateDirty();
				}
				
				@Override
				public void keyPressed(KeyEvent e) {
					// TODO Auto-generated method stub
					
				}
			});
		}
		else
		{
			ctr.addListener(SWT.Selection, event->updateDirty());//Pour les spinner et les chekbox labada expresseion
		}
		if(ctr instanceof Spinner)
		{
			ctr.addListener(SWT.Selection, event->updateCaretposition(ctr));
		}
	}
	//Pour corriger le Bug de spinner que selctionne tous apres chaque saisie
		private void updateCaretposition(Control ctr)
		{
			Event ke = new Event();
	        ke.type = SWT.MENU_KEYBOARD;
	        ke.keyCode = SWT.ARROW_RIGHT;
	        ctr.getDisplay().post(ke);
		}
	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}
	@Override
	public void run() throws DesignException {
		// TODO Auto-generated method stub
//		this.usin.setTool((Tool) ((StructuredSelection) this.comboViewer.getSelection()).getFirstElement());
		m_bindingContext.updateModels();
	}
	@Override
	public void cancel() {
		// TODO Auto-generated method stub
		
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeSingleSelectionComboViewer = ViewerProperties.singleSelection().observe(comboViewer);
		IObservableValue toolUsinObserveValue = BeanProperties.value("tool").observe(usin);
		bindingContext.bindValue(observeSingleSelectionComboViewer, toolUsinObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), null);
		//
		return bindingContext;
	}
}
