package dressing.ui.etagere;

import java.util.Iterator;

import javax.inject.Inject;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import dressing.controller.EtagereCreator;
import dressing.model.Materiaux;
import dressing.model.ModelProvider;
import dressing.model.types.EtagereReferenceType;
import dressing.model.types.EtagereType;
import dressing.ui.util.NumberField;
import dressing.ui.util.SingleImageItemLabelProvider;
import dressing.ui.util.SwtTextFilter;

public class EtagereCompositeWelcomePage extends Composite {
	@Inject
	IEclipseContext eclipsecontext;
	@Inject
	private ESelectionService selectionService;

	@Inject
	private EHandlerService handlerService;

	@Inject
	private ECommandService commandService;
	private DataBindingContext m_bindingContext;
	static EtagereCreator etgCreator = new dressing.controller.EtagereCreator();
	private ModelProvider modelprovider = new ModelProvider();
	private Spinner etageCount;
	private Button DistanceAutomataique;
	private Button DistanceInterEtage;
	private Button tableDistance;
	private Button isometriqueAutomatique; 
//	private Combo typeEtageCombo;
//	private ComboViewer comboViewer;
	private Combo matcombo;
	private ComboViewer comboViewer_1;
	private Combo referencecombo;
	private ComboViewer comboViewer_2;
	int intEtageMax;
	private NumberField numberFild;
	private Text tfDistanceInterEtage;
	private NumberField composite;
	private Text tfDistanceRef;
	Listener pcl;
	private TableComboViewer tcv;
	private Label lblRetraitDepuisFacade;
	private Spinner spnRetraitDeriere;
	public EtagereCreator getEtgCreator() {
		return etgCreator;
	}

	public void setEtgCreator(EtagereCreator etgCreator) {
		this.etgCreator = etgCreator;
	}

	/**
	 * Create the composite.
	 * 
	 * @param parent
	 * @param style
	 */
	public EtagereCompositeWelcomePage(Composite parent, int style, EtagereCreator etgCreator) {

		this(parent, style);
		setEtgCreator(etgCreator);
		if (etgCreator != null) {
			m_bindingContext = initDataBindings();
		}
	}

	public EtagereCompositeWelcomePage(Composite parent, int style) {
		super(parent, SWT.NONE);
		setLayout(new GridLayout(2, false));
		if (getEtgCreator().getParent() != null) {
			intEtageMax = (int) (getEtgCreator().getParent().getHauteurint() / 2);
		}
		Label nbetagereLabel = new Label(this, SWT.NONE);
		nbetagereLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		nbetagereLabel.setForeground(SWTResourceManager.getColor(SWT.COLOR_BLACK));
		nbetagereLabel.setText("Nombre d'étagère");

		etageCount = new Spinner(this, SWT.BORDER);
		GridData gd_etageCount = new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1);
		gd_etageCount.widthHint = 365;
		etageCount.setLayoutData(gd_etageCount);
	
//		Label typeEtagereLabel = new Label(this, SWT.NONE);
//		typeEtagereLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
//		typeEtagereLabel.setText("Type d'ètage");

//		comboViewer = new ComboViewer(this, SWT.READ_ONLY);
//		typeEtageCombo = comboViewer.getCombo();
//		typeEtageCombo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
//		comboViewer.setContentProvider((ArrayContentProvider.getInstance()));
//		comboViewer.setInput(EtagereType.values());
		Label materialLabel = new Label(this, SWT.NONE);
		materialLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		materialLabel.setText("Matériaux");

		 comboViewer_1 = new ComboViewer(this, SWT.READ_ONLY);
		 matcombo = comboViewer_1.getCombo();
		 GridData gd_matcombo = new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1);
		 gd_matcombo.widthHint = 360;
		 matcombo.setLayoutData(gd_matcombo);
		 comboViewer_1.setLabelProvider(new LabelProvider() {
		     @Override
		     public String getText(Object element) {
		         if (element instanceof Materiaux) {
		        	 Materiaux mat = (Materiaux) element;
		             return mat.getName();
		         }
		         return super.getText(element);
		     }
		 });
		 comboViewer_1.setContentProvider((ArrayContentProvider.getInstance()));
		 comboViewer_1.setInput(ModelProvider.getMateriallist());
//		tcv = new TableComboViewer(this, SWT.READ_ONLY | SWT.BORDER);
//		GridData gridData = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
//		gridData.widthHint = 312;
//		tcv.getTableCombo().setLayoutData(gridData);
////		tcv.getTableCombo().getTextControl().setEditable(false);
//		tcv.getTableCombo().setShowTableHeader(true);
//		// tell the TableCombo that I want 2 blank columns auto sized.
//		tcv.getTableCombo().defineColumns(new String[] { "Texture","Epaisseur" });
//		tcv.addSelectionChangedListener( new ISelectionChangedListener() {
//
//		public void selectionChanged(SelectionChangedEvent event) {
//			Materiaux model = (Materiaux)((IStructuredSelection)event.getSelection()).getFirstElement();
//			TableComboViewer viewer = ((TableComboViewer) event.getSource());
//			viewer.getTableCombo().setText(model.getName()+model.getEpaisseur());
//			viewer.update(model, null);
//		}
//	
//
//});
//		// set which column index will be used to display the selected item.
//		tcv.getTableCombo().setDisplayColumnIndex(0);
//		tcv.getTableCombo().getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
//		// do not allow editable
//		tcv.getTableCombo().setEditable(false);
//		tcv.getTableCombo().setShowImageWithinSelection(true);
//
//		// set the content provider
//		tcv.setContentProvider(ArrayContentProvider.getInstance());
//
//		// set the label provider
//		tcv.setLabelProvider(new SingleImageItemLabelProvider(this));
//
//		// load the data
//		tcv.setInput(modelprovider.getMateriallist());

		//
		Label refrenceLabel = new Label(this, SWT.NONE);
		refrenceLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		refrenceLabel.setText("Réfèrence");

		comboViewer_2 = new ComboViewer(this, SWT.READ_ONLY);
		referencecombo = comboViewer_2.getCombo();
		GridData gd_referencecombo = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_referencecombo.widthHint = 298;
		referencecombo.setLayoutData(gd_referencecombo);
		comboViewer_2.setContentProvider((ArrayContentProvider.getInstance()));
		comboViewer_2.setInput(EtagereReferenceType.values());
		Label ditance1etageLabel = new Label(this, SWT.NONE);
		ditance1etageLabel.setText("Distance de la 1'er étage");

		tfDistanceRef = new Text(this, SWT.BORDER | SWT.MULTI);
		GridData gd_tfDistanceRef = new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1);
		gd_tfDistanceRef.widthHint = 349;
		tfDistanceRef.setLayoutData(gd_tfDistanceRef);
		tfDistanceRef.addListener(SWT.Verify, new Listener() {
			public void handleEvent(Event e) {
				SwtTextFilter.ASINT(tfDistanceRef, e);
			}
		});
		
		lblRetraitDepuisFacade = new Label(this, SWT.NONE);
		lblRetraitDepuisFacade.setText("Retrait Depuis Facade");
		
		spnRetraitDeriere = new Spinner(this, SWT.BORDER);
		spnRetraitDeriere.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spnRetraitDeriere.setMaximum(50000);

		DistanceAutomataique = new Button(this, SWT.RADIO);
		DistanceAutomataique.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		DistanceAutomataique.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
			}
		});
		DistanceAutomataique.setText("Distance Automatique");

		new Label(this, SWT.NONE);

		DistanceInterEtage = new Button(this, SWT.RADIO);
		DistanceInterEtage.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		DistanceInterEtage.setText("Distance inter étage");
		tfDistanceInterEtage = new Text(this, SWT.BORDER);
		GridData gd_tfDistanceInterEtage = new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1);
		gd_tfDistanceInterEtage.widthHint = 324;
		tfDistanceInterEtage.setLayoutData(gd_tfDistanceInterEtage);

		tfDistanceInterEtage.addListener(SWT.Verify, new Listener() {
			public void handleEvent(Event e) {
				SwtTextFilter.ASINT(tfDistanceInterEtage, e);
			}
		});
		tableDistance = new Button(this, SWT.RADIO);
		tableDistance.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		tableDistance.setText("Table des dstance");
		new Label(this, SWT.NONE);
		isometriqueAutomatique = new Button(this, SWT.RADIO);
		isometriqueAutomatique.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		isometriqueAutomatique.setText("Isométrique Automatique");
		new Label(this, SWT.NONE);
		
		if (getEtgCreator().getParent() != null) {
			intEtageMax = (int) (getEtgCreator().getParent().getHauteurint() / 2);
		}
		m_bindingContext = initDataBindings();

	}

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeSelectionEtageCountObserveWidget = WidgetProperties.widgetSelection().observe(etageCount);
		IObservableValue etagerecountEtgCreatorObserveValue = BeanProperties.value("etagerecount").observe(etgCreator);
		bindingContext.bindValue(observeSelectionEtageCountObserveWidget, etagerecountEtgCreatorObserveValue, null, null);
		//
		IObservableValue observeSelectionDistanceAutomataiqueObserveWidget = WidgetProperties.widgetSelection().observe(DistanceAutomataique);
		IObservableValue distanceAutomatiqueEtgCreatorObserveValue = BeanProperties.value("distanceAutomatique").observe(etgCreator);
		bindingContext.bindValue(observeSelectionDistanceAutomataiqueObserveWidget, distanceAutomatiqueEtgCreatorObserveValue, null, null);
		//
		IObservableValue observeSelectionDistanceInterEtageObserveWidget_1 = WidgetProperties.widgetSelection().observe(DistanceInterEtage);
		IObservableValue intetrDistanceEtgCreatorObserveValue = BeanProperties.value("intetrDistance").observe(etgCreator);
		bindingContext.bindValue(observeSelectionDistanceInterEtageObserveWidget_1, intetrDistanceEtgCreatorObserveValue, null, null);
		//
		IObservableValue observeSelectionTableDistanceObserveWidget = WidgetProperties.widgetSelection().observe(tableDistance);
		IObservableValue tableDesDistanceEtgCreatorObserveValue = BeanProperties.value("tableDesDistance").observe(etgCreator);
		bindingContext.bindValue(observeSelectionTableDistanceObserveWidget, tableDesDistanceEtgCreatorObserveValue, null, null);
		//
		IObservableValue observeSelectionIsometriqueAutomatiqueObserveWidget = WidgetProperties.widgetSelection().observe(isometriqueAutomatique);
		IObservableValue IsometriqueAutomatiqueEtgCreatorObserveValue = BeanProperties.value("isometriqueAutomatique").observe(etgCreator);
		bindingContext.bindValue(observeSelectionIsometriqueAutomatiqueObserveWidget, IsometriqueAutomatiqueEtgCreatorObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionComboViewer_2 = ViewerProperties.singleSelection().observe(comboViewer_2);
		IObservableValue etagereReferenceTypeEtgCreatorObserveValue = BeanProperties.value("etagereReferenceType").observe(etgCreator);
		bindingContext.bindValue(observeSingleSelectionComboViewer_2, etagereReferenceTypeEtgCreatorObserveValue, null, null);
		//
		IObservableValue observeTextTextObserveWidget = WidgetProperties.text(SWT.Modify).observe(tfDistanceInterEtage);
		IObservableValue interDistanceManuelEtgCreatorObserveValue = BeanProperties.value("interDistanceManuel").observe(etgCreator);
		bindingContext.bindValue(observeTextTextObserveWidget, interDistanceManuelEtgCreatorObserveValue, null, null);
		//
		IObservableValue observeVisibleTfDistanceInterEtageObserveWidget = WidgetProperties.visible().observe(tfDistanceInterEtage);
		bindingContext.bindValue(observeVisibleTfDistanceInterEtageObserveWidget, intetrDistanceEtgCreatorObserveValue, null, null);
		//
		IObservableValue observeTextTfDistanceRefObserveWidget = WidgetProperties.text(SWT.Modify).observe(tfDistanceRef);
		IObservableValue distancerefEtgCreatorObserveValue = BeanProperties.value("distanceref").observe(etgCreator);
		bindingContext.bindValue(observeTextTfDistanceRefObserveWidget, distancerefEtgCreatorObserveValue, null, null);
		//
		IObservableValue observeEnabledTfDistanceRefObserveWidget = WidgetProperties.enabled().observe(tfDistanceRef);
		bindingContext.bindValue(observeEnabledTfDistanceRefObserveWidget, distanceAutomatiqueEtgCreatorObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionComboViewer_1 = ViewerProperties.singleSelection().observe(comboViewer_1);
		IObservableValue materialEtgCreatorObserveValue = BeanProperties.value("material").observe(etgCreator);
		bindingContext.bindValue(observeSingleSelectionComboViewer_1, materialEtgCreatorObserveValue, null, null);
		//
		IObservableValue observeSelectionSpnRetraitDeriereObserveWidget = WidgetProperties.widgetSelection().observe(spnRetraitDeriere);
		IObservableValue sepRetraitEtgCreatorObserveValue = BeanProperties.value("sepRetrait").observe(etgCreator);
		bindingContext.bindValue(observeSelectionSpnRetraitDeriereObserveWidget, sepRetraitEtgCreatorObserveValue, null, null);
		//
		return bindingContext;
	}
}
