package dressing.model;

import dressing.model.debitage.Debitage;
import dressing.model.evalutor.Equation;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.PieceType;
import dressing.model.types.PositionCalculationType;
import dressing.model.types.PositionReferenceType;
import dressing.model.types.SeprationAxe;
import dressing.model.types.Zone3DType;
import dressing.model.usinage.Usinage;

public class Separator extends Piece2D {

	Space3D lefttopchild; 
	Space3D rightdownchild;
	Space3D parentspace;
	double sepposition;
	PositionCalculationType posclaculationtype;
	SeprationAxe sepaxe;
	boolean isSepIsometrique;
	PositionReferenceType posRefType;
	double sepRetrait=0;
	double sepretraitderiere=0;
	boolean inspaceporte=false;
	public Separator(Space3D parent,double position,PositionCalculationType postype,
			SeprationAxe sepaxe,boolean isSepIsometrique, 
			PositionReferenceType sepPositionReferenceType, double sepRetrait,double sepRetraitDreirere) {
		// TODO Auto-generated constructor stub
		this.parentspace = parent;
		this.sepposition = position;
		this.posclaculationtype = postype;
		this.sepaxe = sepaxe;
		this.lefttopchild = new Space3D();
		this.rightdownchild = new Space3D();
		this.isSepIsometrique=isSepIsometrique;
		this.posRefType=sepPositionReferenceType;
		this.sepRetrait=sepRetrait;
		this.sepretraitderiere=sepRetraitDreirere;
	}
	
	public Separator() {
		super();
		// TODO Auto-generated constructor stub
	}

	public boolean isInspaceporte(Separator parent) {
			int portecount=0;
			boolean childhasporte=false;
			boolean parenthasporte=false;
			boolean hasporte=false;
			for(DesignObject3D space:getChilds()) {
				for(DesignObject3D piece:space.getChilds()) {
					if(piece instanceof Piece2D) {
						if(((Piece2D)piece).getPiecetype().equals(PieceType.PORTE) 
								|| ((Piece2D)piece).getPiecetype().equals(PieceType.PORTE_DROITE)
								|| ((Piece2D)piece).getPiecetype().equals(PieceType.PORTE_GAUCHE)
								|| ((Piece2D)piece).getPiecetype().equals(PieceType.PORTE_HAUT)
								|| ((Piece2D)piece).getPiecetype().equals(PieceType.PORTE_BAS)) {
							
							portecount++;
							break;
						}else if(piece instanceof Separator ) {
							childhasporte= ((Separator)piece).isInspaceporte(this);
						}
					}
					
				}
			}
			if(parent ==null) {
				if(getParentdesign()!=null && getParentdesign() instanceof Space3D
						&&getParentdesign().getParentdesign()!=null
						&&getParentdesign().getParentdesign() instanceof Separator) {
					parenthasporte=((Separator)getParentdesign().getParentdesign()).isInspaceporte(null);
				}
			}
			if(portecount>1) {
			return true;
			}else {
				return false||parenthasporte||childhasporte;
			}
			
	}
//	public boolean isInspaceporte(Piece2D porte,DesignObject3D parent) {
//		DesignObject3D parent2=parent;
//		while(parent2!= null && !(parent2 instanceof Caisson)) {
//			parent2=parent2.getParentdesign();
//		}
//		return isInspaceporte2(porte, parent2);
//}
//	public boolean isInspaceporte2(Piece2D porte,DesignObject3D parent) {
//		boolean isintersecte=false;
//		boolean isintersecte1=false;
//		forloop:
//		for(DesignObject3D child:parent.getChilds() ) {
//			if((child instanceof Piece2D) &&(((Piece2D)child).getPiecetype().equals(PieceType.PORTE) 
//						|| ((Piece2D)child).getPiecetype().equals(PieceType.PORTE_DROITE)
//						|| ((Piece2D)child).getPiecetype().equals(PieceType.PORTE_GAUCHE)
//						|| ((Piece2D)child).getPiecetype().equals(PieceType.PORTE_HAUT)
//						|| ((Piece2D)child).getPiecetype().equals(PieceType.PORTE_BAS))&&!(porte.equals(child))) {
//					isintersecte= isIntersect(porte, child);
//				
//			} else if(child instanceof Space3D || child instanceof Separator) {
//				isintersecte1= isInspaceporte2(porte,child);
//				if(isintersecte1) {
//					break forloop;
//				}
//			}
//		}
//		return false || isintersecte1||isintersecte;
//}
	public void setInspaceporte(boolean inspaceporte) {
		boolean oldValue=this.inspaceporte;
		this.inspaceporte = inspaceporte;
		firePropertyChange("inspaceporte", oldValue,inspaceporte);
	}

	public double getSepretraitderiere() {
		return sepretraitderiere;
	}

	public void setSepretraitderiere(double sepretraitderiere) {
		double oldValue=this.sepretraitderiere;
		this.sepretraitderiere = sepretraitderiere;
		firePropertyChange("sepretraitderiere", oldValue,sepretraitderiere);	
	}

	public double getSepRetrait() {
		return sepRetrait;
	}

	public void setSepRetrait(double sepRetrait) {
		double oldValue=this.sepRetrait;
		this.sepRetrait = sepRetrait;
		firePropertyChange("sepRetrait", oldValue,sepRetrait);	
	}

	public void setSepaxe(SeprationAxe sepaxe) {
		SeprationAxe oldValue=this.sepaxe;
		this.sepaxe = sepaxe;
		firePropertyChange("sepaxe", oldValue,sepaxe);	
	}

	public PositionReferenceType getPosRefType() {
		return posRefType;
	}

	public PositionCalculationType getPosclaculationtype() {
		return posclaculationtype;
	}

	public void setPosclaculationtype(PositionCalculationType posclaculationtype) {
		PositionCalculationType oldValue=this.posclaculationtype;
		this.posclaculationtype = posclaculationtype;
		firePropertyChange("posclaculationtype", oldValue,posclaculationtype);
	}

	public void setSepposition(double sepposition) {
	
		double oldValue=this.sepposition;
		this.sepposition = sepposition;
		firePropertyChange("sepposition", oldValue,sepposition);	
	}

	public void setSepIsometrique(boolean isSepIsometrique) {
		
		boolean oldValue=this.isSepIsometrique;
		this.isSepIsometrique = isSepIsometrique;
		firePropertyChange("isSepIsometrique", oldValue,isSepIsometrique);		
	}

	public void setPosRefType(PositionReferenceType posRefType) {
		
		PositionReferenceType oldValue=this.posRefType;
		this.posRefType = posRefType;
		firePropertyChange("posRefType", oldValue,posRefType);		
	}

	public Space3D getLefttopchild() {
		return lefttopchild;
	}
	public Space3D getRightdownchild() {
		return rightdownchild;
	}
	@Override
	public boolean canHold(DesignObject3D child) {
		// TODO Auto-generated method stub
		if(child instanceof Caisson)
		{
			return false;
		}
		if(child instanceof Accessoire || child instanceof Piece2D || child instanceof Space3D || child instanceof Usinage)
		{
			return true;
		}
		return false;
	}
	public Space3D getParentspace() {
		return parentspace;
	}
	public double getSepposition() {
		return sepposition;
	}
	public SeprationAxe getSepaxe() {
		return sepaxe;
	}
	
	public boolean getIsSepIsometrique() {
		return isSepIsometrique;
		
	}
	public void setIsSepIsometrique(boolean isSepIsometrique) {
		boolean oldValue=this.isSepIsometrique;
		this.isSepIsometrique = isSepIsometrique;
		firePropertyChange("isSepIsometrique", oldValue,isSepIsometrique);
	}
	public void constructDebitage() throws DesignException
	{
		debitage = new Debitage();
		if(parentspace==null)
			throw new DesignException("Le parent lors de debitage ne doit pas être null");
		debitage.setParent(parentspace);
		debitage.setChild(this);
		debitage.createupdateDebitage();
	}

	public void setLefttopchild(Space3D lefttopchild) {
		this.lefttopchild = lefttopchild;
	}

	public void setRightdownchild(Space3D rightdownchild) {
		this.rightdownchild = rightdownchild;
	}

	public void setParentspace(Space3D parentspace) {
		this.parentspace = parentspace;
	}

	@Override
	public void update() throws DesignException, GeometricEngineException  {
		if(posclaculationtype.equals(PositionCalculationType.FIX)) {
			if (getSepaxe().equals(SeprationAxe.YAXIS)) {
				if (getSepposition() > getParentdesign().getHauteurint()) {
					throw new DesignException(
							"impossible d'ajouter un separateur avec position sepurieur a la Hauteur du parent");
				}
			} else if (getSepaxe().equals(SeprationAxe.XAXIS)) {
				if (getSepposition() > getParentdesign().getLongeurint()) {
					throw new DesignException(
							"impossible d'ajouter un separateur avec position sepurieur a la Longeur du parent");
				}
			} else {
				if (getSepposition() > getParentdesign().getProfondeurint() - getMaterial().getEpaisseur()) {
					throw new DesignException(
							"impossible d'ajouter un separateur avec position sepurieur a la Profondeur du parent");
				}
			}
		}else if(posclaculationtype.equals(PositionCalculationType.POURCENT)) {
			if (getSepposition() >= 100) {
				throw new DesignException(
						"impossible d'ajouter un separateur avec position sepurieur a la Longeur du parent");
			}
		}
		
		if(getSepRetrait()+getSepretraitderiere()>getParentdesign().getProfondeurint()-100) {
			throw new DesignException(
					"la pronfondeur du separateur doit etre superieur ou egale a la profondeur minimale (100mm)");

		}
		propagateUpdateToChildrens(null);
	}
	
	@Override
	public DesignObject3D clone() {
		Separator sep=new Separator();
		try {
			sep=(Separator) this.copy(sep);
		} catch (DesignException | GeometricEngineException | CloneNotSupportedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return sep;
	}
	@Override
	public DesignObject3D copy(DesignObject3D object) throws DesignException, GeometricEngineException, CloneNotSupportedException {
		Separator sep=(Separator) object;
		sep=(Separator) super.copy(sep);
		sep.setSepposition(getSepposition());
		sep.setPosclaculationtype(getPosclaculationtype());
		sep.setSepaxe(getSepaxe());
		sep.setIsSepIsometrique(getIsSepIsometrique());
		sep.setPosRefType(getPosRefType());
		sep.setSepRetrait(getSepRetrait());
		sep.setSepretraitderiere(getSepretraitderiere());
		for(DesignObject3D design:sep.getChilds()) {
			if(design instanceof Space3D) {
				Space3D space=(Space3D) design;
				if(space.getZonetype().equals(Zone3DType.ZONEHAUT)) {
					sep.setLefttopchild(space);
				}else if(space.getZonetype().equals(Zone3DType.ZONEBAS)) {
					sep.setRightdownchild(space);
				}else {
					throw new DesignException("impossible pour le separator de contient des espace3D que type ZONEHAUT ou ZONEBAS  ");
				}
			}
		}
		return sep;
	}
}
