package dressing.controller;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;

import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Materiaux;
import dressing.model.Tirroir;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.DosType;
import dressing.model.types.PieceType;
import dressing.model.types.TiroireFacadeType;
import dressing.model.types.TirroirType;
import dressing.ui.tiroire.TirroirListDistances;

@Deprecated
public class TiroireCreator implements Creator{
	public final static double MIN_TIROIRE_HEIGHT = 100;
private Boolean facadeEgaux=true;
private Boolean facadeDiffirent=false;
private TiroireFacadeType facadetype=TiroireFacadeType.FACADE_EXTERIEUR_TIROIR;
private Double espaceInterFacade=10.0;
 int tiroireCount=1;
private Materiaux facadeMaterial;
private Materiaux coteMaterial;
private Materiaux basMaterial;
DesignObject3D parent;
List<DesignObject3D> tiroirList = new ArrayList<DesignObject3D>();
String name;
double tiroirehauteur;
List<TirroirListDistances> listDistance =  new ArrayList<TirroirListDistances>();
private TirroirType tiroirType=TirroirType.CLASSIC;


public TirroirType getTiroirType() {
	return tiroirType;
}

public void setTiroirType(TirroirType tiroirType) {
	TirroirType oldValue=this.tiroirType;
	this.tiroirType = tiroirType;
	firePropertyChange("tiroirType", oldValue, this.tiroirType);	
}
/**
 * @return the listDistance
 */
public List<TirroirListDistances> getListDistance() {
	return listDistance;
}

/**
 * @param listDistance the listDistance to set
 */
public void setListDistance(List<TirroirListDistances> listDistance) {
	
	List<TirroirListDistances> oldValue=this.listDistance;
	this.listDistance = listDistance;
	firePropertyChange("listDistance", oldValue, this.listDistance);
}

/**
 * @return the name
 */
public String getName() {
	return name;
}

/**
 * @param name the name to set
 */
public void setName(String name) {
	String oldValue=this.name;
	this.name = name;
	firePropertyChange("name", oldValue, this.name);
	
}

/**
 * @return the facadeMaterial
 */
public Materiaux getFacadeMaterial() {
	return facadeMaterial;
}

/**
 * @param facadeMaterial the facadeMaterial to set
 */
public void setFacadeMaterial(Materiaux facadeMaterial) {
	Materiaux oldValue=this.facadeMaterial;
	this.facadeMaterial = facadeMaterial;
	firePropertyChange("facadeMaterial", oldValue, this.facadeMaterial);
	
}

/**
 * @return the coteMaterial
 */
public Materiaux getCoteMaterial() {
	return coteMaterial;
}

/**
 * @param coteMaterial the coteMaterial to set
 */
public void setCoteMaterial(Materiaux coteMaterial) {
	Materiaux oldValue=this.coteMaterial;
	this.coteMaterial = coteMaterial;
	firePropertyChange("coteMaterial", oldValue, this.coteMaterial);
	
}

/**
 * @return the basMaterial
 */
public Materiaux getBasMaterial() {
	return basMaterial;
}

/**
 * @param basMaterial the basMaterial to set
 */
public void setBasMaterial(Materiaux basMaterial) {
	Materiaux oldValue=this.basMaterial;
	this.basMaterial = basMaterial;
	firePropertyChange("basMaterial", oldValue, this.basMaterial);
}

/**
 * @return the facadeEgaux
 */
public Boolean getFacadeEgaux() {
	
	return facadeEgaux;
}

/**
 * @param facadeEgaux the facadeEgaux to set
 */
public void setFacadeEgaux(Boolean facadeEgaux) {
	Boolean oldValue=this.facadeEgaux;
	this.facadeEgaux = facadeEgaux;
	firePropertyChange("facadeEgaux", oldValue, this.facadeEgaux);
}

/**
 * @return the facadeDiffirent
 */
public Boolean getFacadeDiffirent() {
	return facadeDiffirent;
}

/**
 * @param facadeDiffirent the facadeDiffirent to set
 */
public void setFacadeDiffirent(Boolean facadeDiffirent) {
	Boolean oldValue=this.facadeDiffirent;
	this.facadeDiffirent = facadeDiffirent;
	firePropertyChange("facadeDiffirent", oldValue, this.facadeDiffirent);

}

/**
 * @return the facadetype
 */
public TiroireFacadeType getFacadetype() {
	return facadetype;
}

/**
 * @param facadetype the facadetype to set
 */
public void setFacadetype(TiroireFacadeType facadetype) {
	TiroireFacadeType oldValue=this.facadetype;
	this.facadetype = facadetype;
	firePropertyChange("facadetype", oldValue, this.facadetype);
	
}

/**
 * @return the espaceInterFacade
 */
public Double getEspaceInterFacade() {
	return espaceInterFacade;
}

/**
 * @param espaceInterFacade the espaceInterFacade to set
 */
public void setEspaceInterFacade(Double espaceInterFacade) {
	Double oldValue=this.espaceInterFacade;
	this.espaceInterFacade = espaceInterFacade;
	firePropertyChange("espaceInterFacade", oldValue, this.espaceInterFacade);
	
}

/**
 * @return the tiroireCount
 */
public int getTiroireCount() {
	return tiroireCount;
}

/**
 * @param tiroireCount the tiroireCount to set
 */
public void setTiroireCount(int tiroireCount) {
	int oldValue=this.tiroireCount;
	this.tiroireCount = tiroireCount;
	firePropertyChange("tiroireCount", oldValue, this.tiroireCount);
	
}

/**
 * @return the parent
 */
public DesignObject3D getParent() {
	return parent;
}

/**
 * @param parent the parent to set
 */
public void setParent(DesignObject3D parent) {
	DesignObject3D oldValue=this.parent;
	this.parent = parent;
	firePropertyChange("parent", oldValue, this.parent);

}

/**
 * @return the tiroirList
 */
public List<DesignObject3D> getTiroirList() {
	return tiroirList;
}

/**
 * @param tiroirList the tiroirList to set
 */
public void setTiroirList(List<DesignObject3D> tiroirList) {
	
	List<DesignObject3D> oldValue=this.tiroirList;
	this.tiroirList = tiroirList;
	firePropertyChange("tiroirList", oldValue, this.tiroirList);
}

/**
 * @return the tiroirehauteur
 */
public double getTiroirehauteur() {
	return tiroirehauteur;
}

/**
 * @param tiroirehauteur the tiroirehauteur to set
 */
public void setTiroirehauteur(double tiroirehauteur) {
	double oldValue=this.tiroirehauteur;
	this.tiroirehauteur = tiroirehauteur;
	firePropertyChange("tiroirehauteur", oldValue, this.tiroirehauteur);
	
}
public void trigerChangeCalculation()
{
	
	firePropertyChange("autotrigger", "2", "1");
}
public void check() throws DesignException {
	if (getBasMaterial() == null)
	{
		throw new DesignException("Le matérieaux de bas doit être rensigné");
	}
	if (getCoteMaterial() == null)
		throw new DesignException("Le matérieaux des cote doit être rensigné");
	if (getTiroireCount() < 1 & getTiroireCount()>20 )
		throw new DesignException("Le nombre des etagere doit être superieur ou égale à 1 et inferieru ou egale a 20");

	if (getParent() == null)
		throw new DesignException("Le parent doit être renseigné");

	if (getFacadeMaterial() == null)
		throw new DesignException("Le matérieaux de facade doit être rensigné");
	if (getEspaceInterFacade() == null)
		throw new DesignException("L'espace entre les facades doit être rensigné");
	if (getFacadetype() == null)
		throw new DesignException("Le type de facade doit être rensigné");
	
}

public void create() throws DesignException, GeometricEngineException{
	// TODO Auto-generated method stub
	createSubElements();
	this.toString();
    
}
public void createSubElements() throws DesignException, GeometricEngineException {
	// TODO Auto-generated method stub
	tiroirList.clear();
	check();//On met le controle dans une seule fonction
    Double Ypos=0.0;
    if(getParent() != null && (((getParent().getHauteurint()-(getEspaceInterFacade()*getTiroireCount()-1))/getTiroireCount())<MIN_TIROIRE_HEIGHT)) {
    	throw new DesignException("le hauteur de les tiroir inferieur a  la hauteur minimale du tiroir  ");
    }
    Double hauteur=((getParent().getHauteurint()-(getEspaceInterFacade()*(getTiroireCount()-1)))/getTiroireCount());
    for(int i=0;i<getTiroireCount();i++) {
    	
    
	Tirroir tirroir= new Tirroir();
    tirroir.setName("Tirroir"+i);
    tirroir.setFacadeMaterial(getFacadeMaterial());
    tirroir.setBasematerial(getCoteMaterial());
    tirroir.setBackmaterial(getBasMaterial());
    tirroir.setLongeurext(getParent().getLongeurext());
	tirroir.setHauteurext(getTiroirehauteur());
	tirroir.setProfondeurext(getParent().getProfondeurint());
	tirroir.setParentdesign(getParent());
	tirroir.setTiroirType(getTiroirType());
	tirroir.setHauteurext(hauteur);
	tirroir.setHauteurint(hauteur);
	tirroir.setTiroireFacadeType(getFacadetype());
	if(i==0) {
		Ypos=getParent().getBasematerial().getEpaisseur();
	}
	else if(i>=1){
		Ypos= Ypos+hauteur +getEspaceInterFacade();
	}
	tirroir.setYpos(Ypos);
	
	tirroir.constructDebitage();
	tirroir.evaluate();		

	
	
	//creer les pieces necessaires
	Piece2DCreator piececreator = new Piece2DCreator();

	piececreator.setName("Cote Droite");
	piececreator.setPiecetype(PieceType.COTE_DROITE_TIROIR);	
	piececreator.setMaterial(getCoteMaterial());
	piececreator.setParent(tirroir);	
	piececreator.create();
	tirroir.addElement(piececreator.getPiece2DInstance());

	
	//
	piececreator.setName("Cote Gauche");
	piececreator.setPiecetype(PieceType.COTE_GAUCHE_TIROIR);
	piececreator.setMaterial(getCoteMaterial());
	piececreator.setParent(tirroir);		
	piececreator.create();
	tirroir.addElement(piececreator.getPiece2DInstance());
	
	//
	piececreator.setName("Bas");
	piececreator.setPiecetype(PieceType.BAS_TIROIR);
	piececreator.setMaterial(getBasMaterial());
	piececreator.setParent(tirroir);		
	piececreator.create();
	tirroir.addElement(piececreator.getPiece2DInstance());
	//
	
	piececreator.setName("Facade");
	if(getFacadetype().equals(TiroireFacadeType.FACADE_EXTERIEUR_TIROIR)) {
		piececreator.setPiecetype(PieceType.FACADE_EXTERIEUR_TIROIR);
	}else if(getFacadetype().equals(TiroireFacadeType.FACADE_INTERIEUR_TIROIR)) {
		piececreator.setPiecetype(PieceType.FACADE_INTERIEUR_TIROIR);
	}
	piececreator.setMaterial(getFacadeMaterial());
	piececreator.setParent(tirroir);		
	piececreator.create();
	tirroir.addElement(piececreator.getPiece2DInstance());
	
	//
	piececreator.setName("Dos");
	piececreator.setPiecetype(PieceType.DERIERE_TIROIR);
	piececreator.setMaterial(getCoteMaterial());
	piececreator.setParent(tirroir);		
	piececreator.create();
	tirroir.addElement(piececreator.getPiece2DInstance());
	
	tiroirList.add(tirroir);
    }
}

/* (non-Javadoc)
 * @see java.lang.Object#toString()
 */
@Override
public String toString() {
	return "TiroireCreator [facadeEgaux=" + facadeEgaux + ", facadeDiffirent=" + facadeDiffirent + ", facadetype="
			+ facadetype + ", espaceInterFacade=" + espaceInterFacade + ", tiroireCount=" + tiroireCount
			+ ", facadeMaterial=" + facadeMaterial + ", coteMaterial=" + coteMaterial + ", basMaterial=" + basMaterial
			+ "]";
}

transient protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(
		this);
public void addPropertyChangeListener(PropertyChangeListener listener) {
	propertyChangeSupport.addPropertyChangeListener(listener);
}

public void addPropertyChangeListener(String propertyName,
		PropertyChangeListener listener) {
	propertyChangeSupport.addPropertyChangeListener(propertyName,
			listener);
}

public void removePropertyChangeListener(PropertyChangeListener listener) {
	propertyChangeSupport.removePropertyChangeListener(listener);
}

public void removePropertyChangeListener(String propertyName,
		PropertyChangeListener listener) {
	propertyChangeSupport.removePropertyChangeListener(propertyName,
			listener);
}

protected void firePropertyChange(String propertyName, Object oldValue,
		Object newValue) {
		propertyChangeSupport.firePropertyChange(propertyName, oldValue,
				newValue);
}
}
