/*
 * Decompiled with CFR 0.152.
 */
package com.sandmonkey.viewer3d.parts;

import api.graphics.Model;
import com.sandmonkey.viewer3d.api.ui.RenderingCanvas;
import com.sandmonkey.viewer3d.internal.ModelViewer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class ViewerPart {
    private RenderingCanvas canvas;
    private ModelViewer modelViewer;

    @PostConstruct
    public void createControl(Composite parent) {
        this.canvas = new RenderingCanvas(parent, 360, 360);
        this.modelViewer = new ModelViewer();
        this.canvas.setScene(this.modelViewer);
        this.canvas.run();
    }

    @Inject
    @Optional
    public void onPreviewModelEvent(@EventTopic(value="PREVIEW_MODEL") Object data) {
        System.out.println("Received event with data: " + String.valueOf(data));
        HashMap map = (HashMap)data;
        String modelPath = (String)map.get("value");
        HashMap<Model, Matrix4f[]> addons = this.loadAddons(modelPath);
        float[] dims = (float[])map.get("size");
        Model model = new Model(modelPath);
        Display.findDisplay((Thread)this.canvas.getThread()).asyncExec(() -> {
            model.load();
            this.modelViewer.setDims(new Vector3f(dims));
            this.modelViewer.setAddons(addons);
            this.modelViewer.setModel3D(model);
        });
    }

    public HashMap<Model, Matrix4f[]> loadAddons(String modelPath) {
        File file = new File(modelPath);
        File[] folders = file.getParentFile().listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        FileFilter dotobjFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".obj");
            }
        };
        FileFilter transformFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".txt");
            }
        };
        HashMap<Model, Matrix4f[]> instances = new HashMap<Model, Matrix4f[]>();
        File[] fileArray = folders;
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            File folder = fileArray[n2];
            File modelFile = folder.listFiles(dotobjFilter)[0];
            File transformFile = folder.listFiles(transformFilter)[0];
            Model model = new Model(modelFile.getAbsolutePath());
            Matrix4f[] transforms = ViewerPart.readTransformsFromFile(transformFile);
            instances.put(model, transforms);
            ++n2;
        }
        return instances;
    }

    public static Matrix4f[] readTransformsFromFile(File file) {
        ArrayList<Matrix4f> transforms = new ArrayList<Matrix4f>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(file.getAbsolutePath()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    line = line.replaceAll("[\\[\\]]", "").trim();
                    String[] parts = line.split(",\\s*");
                    float[] floatArray = new float[parts.length];
                    int i = 0;
                    while (i < parts.length) {
                        floatArray[i] = Float.parseFloat(parts[i]);
                        ++i;
                    }
                    transforms.add(new Matrix4f(floatArray[0], floatArray[1], floatArray[2], floatArray[3], floatArray[4], floatArray[5], floatArray[6], floatArray[7], floatArray[8], floatArray[9], floatArray[10], floatArray[11], floatArray[12], floatArray[13], floatArray[14], floatArray[15]));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return transforms.toArray(new Matrix4f[0]);
    }

    @PreDestroy
    public void dispose() {
    }
}

