package dressing.ui.usinage;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

import dressing.cam.model.Operation;
import dressing.cam.model.Tool;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.IUpdateStructure;
import dressing.model.ModelProvider;
import dressing.model.Parameters;


import dressing.model.usinage.Usinage;
import dressing.ui.configuration.CustomParametersComposite;
import dressing.ui.util.DoubleCellEditor;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class UsinageCamEditorComposite extends Composite implements IUpdateStructure{
	public static final String NAME="Name";
	public static final String CODE = "Code";
	public static final String DEPTH ="Depth";
	public static final String START="Start";
	public static final String END ="End";
	public static final String STEP="Step";
	public static final String TOOL="tool";
	public static final String USINAGE="Usinage";
	public static final String[] PROPS = { NAME,CODE, USINAGE,TOOL,DEPTH,STEP,START,END };
	public Usinage usin = null;
	private MDirtyable dirty;

	private Table table;
	private TableViewer tableViewer;
	PropertyChangeListener pcl;
	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 */
	public UsinageCamEditorComposite(Composite parent, int style,Usinage usin) {
		super(parent, style);
		setUsin(usin);
		initTable();
	}

	public Usinage getUsin() {
		return usin;
	}

	public void setUsin(Usinage usin) {
		this.usin = usin;
		if(this.usin.getOperations()==null) {
			this.usin.setOperations(new ArrayList<Operation>());
		}
		if(tableViewer !=null && !this.isDisposed())
		{

			tableViewer.setInput(this.usin.getOperations());
			tableViewer.refresh();
			
		}
	}
	public void setDirty(MDirtyable dirty) {
		this.dirty = dirty;
	}
	public MDirtyable getDirty() {
		return dirty;
	}
	public void updateDirty()
	{
		if(this.dirty!=null)
		{
			this.dirty.setDirty(true);
		}
	}
	private void initTable()
	{
		setLayout(new GridLayout(4, false));
		Button btnadd=new Button(this, SWT.PUSH);
		btnadd.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnadd.setText("Ajouter");
		Button btndelete=new Button(this, SWT.PUSH);
		btndelete.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btndelete.setText("Supprimer");
		btndelete.addSelectionListener(new SelectionListener() {
			
			@Override
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection selection=	tableViewer.getStructuredSelection();
				usin.getOperations().removeAll(selection.toList());
				tableViewer.refresh();
			}
			
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				
			}
		});
		btnadd.addSelectionListener(new SelectionListener() {
			
			@Override
			public void widgetSelected(SelectionEvent e) {
				
				usin.addOperation(new Operation(usin));
				tableViewer.refresh();
			}
			
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
			
			}
		});
		
		tableViewer = new TableViewer(this, SWT.MULTI | SWT.H_SCROLL
	            | SWT.V_SCROLL | SWT.FULL_SELECTION | SWT.BORDER);
		tableViewer.setContentProvider(new UsinageOperationsContentProvider());
		tableViewer.setLabelProvider(new UsinageOperationsLabelProvider(tableViewer,this.usin));
		tableViewer.setInput(this.usin.getOperations());

		table = tableViewer.getTable();
		table.setTouchEnabled(true);
		GridData gd_table = new GridData(SWT.FILL, SWT.FILL, true, true, 4, 1);
		gd_table.heightHint = 92;
		gd_table.widthHint = 424;
		table.setLayoutData(gd_table);
		
		TableColumn tblClmn=  new TableColumn(table, SWT.LEFT);
	    tblClmn.setText(NAME);
	    tblClmn.setWidth(60);

	    TableColumn tblClmn1=  new TableColumn(table, SWT.LEFT);
	    tblClmn1.setText(CODE);
	    tblClmn1.setWidth(58);
	    
	    TableColumn tblClmn2=  new TableColumn(table, SWT.LEFT);
	    tblClmn2.setText(USINAGE);
	    tblClmn2.setWidth(62);	
	    
	    TableColumn tblClmn3=  new TableColumn(table, SWT.LEFT);
	    tblClmn3.setText(TOOL);
	    tblClmn3.setWidth(41);
	    
	    TableColumn tblClmn4=  new TableColumn(table, SWT.LEFT);
	    tblClmn4.setText(DEPTH);
	    tblClmn4.setWidth(49);
	    
	    TableColumn tblClmn5=  new TableColumn(table, SWT.LEFT);
	    tblClmn5.setText(STEP);
	    tblClmn5.setWidth(40);
	    
	    TableColumn tblClmn6=  new TableColumn(table, SWT.LEFT);
	    tblClmn6.setText(START);
	    tblClmn6.setWidth(62);
	    
	    TableColumn tblClmn7=  new TableColumn(table, SWT.LEFT);
	    tblClmn7.setText(END);
	    tblClmn7.setWidth(69);
	    
		ControlAdapter cal= new ControlAdapter() {
		
		    public void controlResized(ControlEvent e) {
		    	
		      Rectangle area = UsinageCamEditorComposite.this.getClientArea();
		      Point preferredSize = table.computeSize(SWT.DEFAULT, SWT.DEFAULT);
		      int width = area.width - 2*table.getBorderWidth();
		      if (preferredSize.y > area.width + table.getHeaderHeight()) {
		        // Subtract the scrollbar width from the total column width
		        // if a vertical scrollbar will be required
		       
		      }
		      Point vBarSize = table.getVerticalBar().getSize();
		        width -= vBarSize.x;
		      Point oldSize = table.getSize();
		      if (oldSize.x > area.width) {
		        // table is getting smaller so make the columns 
		        // smaller first and then resize the table to
		        // match the client area width
		        tblClmn.setWidth(width/8-2*table.getBorderWidth());
		        tblClmn1.setWidth(width/8-2*table.getBorderWidth());
		        tblClmn2.setWidth(width/8-2*table.getBorderWidth());
		        tblClmn3.setWidth(width/8-2*table.getBorderWidth());
		        tblClmn4.setWidth(width/8-2*table.getBorderWidth());
		        tblClmn5.setWidth(width/8-2*table.getBorderWidth());
		        tblClmn6.setWidth(width/8-2*table.getBorderWidth());
		        tblClmn7.setWidth(width/8-2*table.getBorderWidth());
		        table.setSize(area.width, area.height-30);
		      } else {
		        // table is getting bigger so make the table 
		        // bigger first and then make the columns wider
		        // to match the client area width
		        table.setSize(area.width, area.height-30);
		        tblClmn.setWidth(width/8-2*table.getBorderWidth());
		        tblClmn1.setWidth(width/8-2*table.getBorderWidth());
		        tblClmn2.setWidth(width/8-2*table.getBorderWidth());
		        tblClmn3.setWidth(width/8-2*table.getBorderWidth());
		        tblClmn4.setWidth(width/8-2*table.getBorderWidth());
		        tblClmn5.setWidth(width/8-2*table.getBorderWidth());
		        tblClmn6.setWidth(width/8-2*table.getBorderWidth());
		        tblClmn7.setWidth(width/8-2*table.getBorderWidth());
		      }
		    }};
		
		  
		this.addControlListener(cal);
		table.addControlListener(cal);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		tableViewer.refresh();

		CellEditor[] editors = new CellEditor[8];
		editors[0] = new TextCellEditor(table);
		editors[0].getControl().setEnabled(true);
		editors[1] = new TextCellEditor(table);
		editors[1].getControl().setEnabled(true);
		editors[2]=new TextCellEditor(table);
		editors[2].getControl().setEnabled(true);
		//
		ComboBoxViewerCellEditor comboviewcellEditor=	new ComboBoxViewerCellEditor(table);
		comboviewcellEditor.setContentProvider(ArrayContentProvider.getInstance());
		comboviewcellEditor.setLabelProvider(new LabelProvider() {
		     @Override
		     public String getText(Object element) {
		         if (element instanceof Tool) {
		        	 Tool tool = (Tool) element;
		             return tool.getName();
		         }
		         return super.getText(element);
		     }
		 });
		comboviewcellEditor.setInput(ModelProvider.getTools());
		editors[3]=comboviewcellEditor;
		editors[3].getControl().setEnabled(true);
		//
		DoubleCellEditor editor4=new DoubleCellEditor(table);
		
		editor4.getControl().setEnabled(true);
		editor4.getControl().setTextDirection(SWT.LEFT_TO_RIGHT);
		editor4.setMaximum(100000, 3);
		editors[4]=editor4;
		//
		DoubleCellEditor editor5=new DoubleCellEditor(table);
		
		editor5.getControl().setEnabled(true);
		editor5.getControl().setTextDirection(SWT.LEFT_TO_RIGHT);
		editor5.setMaximum(100000, 3);
		editors[5]=editor5;
		//
		DoubleCellEditor editor6=new DoubleCellEditor(table);
		
		editor6.getControl().setEnabled(true);
		editor6.getControl().setTextDirection(SWT.LEFT_TO_RIGHT);
		editor6.setMaximum(100000, 3);
		editors[6]=editor6;
		//
		DoubleCellEditor editor7=new DoubleCellEditor(table);
		
		editor7.getControl().setEnabled(true);
		editor7.getControl().setTextDirection(SWT.LEFT_TO_RIGHT);
		editor7.setMaximum(100000, 3);
		editors[7]=editor7;
		//
		tableViewer.setColumnProperties(PROPS);
		for (int i = 0, n = table.getColumnCount(); i < n; i++) {
			table.getColumn(i).pack();
		}
		for (int i = 0, n = table.getItemCount(); i < n; i++) {
			table.getItem(i).setGrayed(false);
		}
		tableViewer.setCellModifier(new UsinageOperationsCellModifier(tableViewer));
		tableViewer.setCellEditors(editors);
		
	}
	
	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}

	@Override
	public void run() throws DesignException {
		this.dirty.setDirty(false);;
	}

	@Override
	public void cancel() {
		
	}

}



class UsinageOperationsContentProvider implements IStructuredContentProvider {
	/**
	 * Returns the Person objects
	 */
	public Object[] getElements(Object inputElement) {
		return ((List) inputElement).toArray();
	}
}

/**
 * This class provides the content for the FoodList application
 */
class  UsinageOperationsCellModifier implements ICellModifier {
	private TableViewer viewer;

	public UsinageOperationsCellModifier(TableViewer viewer) {
		this.viewer = viewer;
	}

	/**
	 * Returns whether the property can be modified
	 * 
	 * @param element
	 *            the element
	 * @param property
	 *            the property
	 * @return boolean
	 */
	public boolean canModify(Object element, String property) {
		// Allow editing of all values
		if (element instanceof Item)
			element = ((Item) element).getData();

		if (UsinageCamEditorComposite.USINAGE.equals(property)) {
			return false;
		}
		else 
		{
			return true;
		}
		
	}

	/**
	 * Returns the value for the property
	 * 
	 * @param element
	 *            the element
	 * @param property
	 *            the property
	 * @return Object
	 */
	public Object getValue(Object element, String property) {
		if (element instanceof Item)
			element = ((Item) element).getData();

		Operation p = (Operation) element;
		if (UsinageCamEditorComposite.NAME.equals(property)) {
			if(p.getName()==null) {
				return "";
			}
			return p.getName();
		}
		else if (UsinageCamEditorComposite.CODE.equals(property))
		{		
			if(p.getCode()==null) {
				return "";
			}		
			return p.getCode();						
		}else if(UsinageCamEditorComposite.USINAGE.equals(property)) {
			return p.getUsin();
		}else if (UsinageCamEditorComposite.TOOL.equals(property))
		{			
			return p.getTool();						
		}else if(UsinageCamEditorComposite.DEPTH.equals(property)) {
			return  String.valueOf(p.getDepth());
		}else if(UsinageCamEditorComposite.STEP.equals(property)) {
			return String.valueOf(p.getStep());
		}else if(UsinageCamEditorComposite.START.equals(property)) {
			return  String.valueOf(p.getStart());
		}else if(UsinageCamEditorComposite.END.equals(property)) {
			return String.valueOf( p.getEnd());
		}
			return null;
		
		
	}

	/**
	 * Modifies the element
	 * 
	 * @param element
	 *            the element
	 * @param property
	 *            the property
	 * @param value
	 *            the value
	 */
	public void modify(Object element, String property, Object value) {
		if (element instanceof Item)
			element = ((Item) element).getData();

		Operation p = (Operation) element;
		if (UsinageCamEditorComposite.NAME.equals(property))
			 p.setName((String) value);
		else if (UsinageCamEditorComposite.CODE.equals(property))
		{			
			 p.setCode((String) value);						
		}else if(UsinageCamEditorComposite.USINAGE.equals(property)) {
			 p.setUsin((Usinage) value);
		}else if (UsinageCamEditorComposite.TOOL.equals(property))
		{			
			 p.setTool((Tool) value);						
		}else if(UsinageCamEditorComposite.DEPTH.equals(property)) {
			  p.setDepth(Double.valueOf((String) value));
		}else if(UsinageCamEditorComposite.STEP.equals(property)) {
			String s=(String)value;
			if(s!=null && !s.isEmpty()) {
				  p.setStep(Double.valueOf( s) );
			}
			
		}else if(UsinageCamEditorComposite.START.equals(property)) {
			  p.setStart(Double.valueOf((String) value));
		}else if(UsinageCamEditorComposite.END.equals(property)) {
			  p.setEnd(Double.valueOf((String) value));
		}
		
		// Force the viewer to refresh
		viewer.refresh();
		
	}
}

class UsinageOperationsLabelProvider implements ITableColorProvider, ITableLabelProvider {
	TableViewer viewerr;
	Usinage usin;
	/**
	 * Returns the image
	 * 
	 * @param element
	 *            the element
	 * @param columnIndex
	 *            the column index
	 * @return Image
	 */
	
	public Image getColumnImage(Object element, int columnIndex) {
//		((Item)element).getImage().setBackground(((Item)element).getDisplay().getSystemColor(SWT.COLOR_YELLOW));	
		return null;
	}

	public UsinageOperationsLabelProvider(TableViewer viewer, Usinage usin ) {
		super();
		this.usin=usin;
		this.viewerr=viewer;
	}

	/**
	 * Returns the column text
	 * 
	 * @param element
	 *            the element
	 * @param columnIndex
	 *            the column index
	 * @return String
	 */
	public String getColumnText(Object element, int columnIndex) {
		Operation p = (Operation) element;
		switch (columnIndex) {
		case 0:
			return p.getName();
		case 1:
			return p.getCode();
		case 2:
			return p.getUsin().getName();
		case 3:
			if(p.getTool()==null) {
				return null;
			}
			return p.getTool().getName();
		case 4:
			return String.valueOf(p.getDepth());
		case 5:
			return String.valueOf(p.getStep());
		case 6:
			return String.valueOf(p.getStart());
		case 7: 
			return String.valueOf(p.getEnd());
		}
		return null;
	}

	/**
	 * Adds a listener
	 * 
	 * @param listener
	 *            the listener
	 */
	public void addListener(ILabelProviderListener listener) {
		// Ignore it
	}

	/**
	 * Disposes any created resources
	 */
	public void dispose() {
		// Nothing to dispose
	}

	/**
	 * Returns whether altering this property on this element will affect the label
	 * 
	 * @param element
	 *            the element
	 * @param property
	 *            the property
	 * @return boolean
	 */
	public boolean isLabelProperty(Object element, String property) {
		return false;
	}

	/**
	 * Removes a listener
	 * 
	 * @param listener
	 *            the listener
	 */
	public void removeListener(ILabelProviderListener listener) {
		// Ignore
	}

	@Override
	public Color getForeground(Object element, int columnIndex) {
		Color color=new Color(viewerr.getTable().getDisplay(),40, 40, 40);
		return color;
	}

	@Override
	public Color getBackground(Object element, int columnIndex) {
		if (element instanceof Item)
		{
			element = ((Item) element).getData();
		}
		if(element instanceof Operation) {
			boolean error=((Operation) element).check();
			if(error) {
				Color color=new Color(viewerr.getTable().getDisplay(),255, 20, 20);
				return color;
			}
			
		}
		Color color=new Color(viewerr.getTable().getDisplay(),220, 220, 220);
		return color;
	}

}
class UsinageOperationsColorProvider implements ITableColorProvider{
TableViewer viewerr;
DesignObject3D designObject3d;
	public UsinageOperationsColorProvider(TableViewer viewer, DesignObject3D designObject3d) {
		viewerr=viewer;
		this.designObject3d=designObject3d;
		// TODO Auto-generated constructor stub
	}

	@Override
	public Color getForeground(Object element, int columnIndex) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Color getBackground(Object element, int columnIndex) {
		// TODO Auto-generated method stub
		if (element instanceof Item)
		{
			element = ((Item) element).getData();
		}
//		if(element instanceof Parameters) {
//			Parameters p = (Parameters) element;
//			if(designObject3d.getParam(p)!=null && designObject3d.getParentdesign() != null && designObject3d.getParentdesign().getParam(p)!=null ){
//				Parameters param1=designObject3d.getParentdesign().getParam(p);
//				Parameters param2=designObject3d.getParam(p);							
//				if(!param2.getDefaultValue().equals(param1.getValue())) {
//					Color color=new Color(viewerr.getTable().getDisplay(),232, 144, 66);
//					return color;
//				}
//			}
//			if(!(p.getDefaultValue().equals(p.getValue()))) {
//				Color color=new Color(viewerr.getTable().getDisplay(),232, 244, 66);
//				return color;	
//				}
//			
//		}

		return null;
	}
	
}
