package dressing.ui.tiroire;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

import dressing.model.ModelProvider;
import dressing.model.types.TiroireFacadeType;
import dressing.ui.util.SingleImageItemLabelProvider;
import dressing.ui.util.SwtTextFilter;

import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.swt.widgets.Spinner;

import java.beans.PropertyChangeListener;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import dressing.controller.TiroireCreator;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;

public class TiroireCompositeWelcomePage extends Composite {
	private DataBindingContext m_bindingContext;
	PropertyChangeListener pcl;
	TiroireCreator tCreator;
	ModelProvider modelProvider=new ModelProvider();
	
	public static final String NAME = "Name";
	public static final String Distance = "Distance";
	public static final String[] PROPS = { NAME, Distance };
	private Table table;
	private Button btnREqualTiroire;
	private Button btnRDiffirentTiroire;
	private Combo CFacadeType;
	private ComboViewer comboViewer;
	private Label lblNewLabel;
	private Label lblNewLabel_1;
	private Label lblNewLabel_2;
	private Combo cFacadeMaterial;
	private ComboViewer comboViewer_1;
	private Combo cCoteMaterial;
	private ComboViewer comboViewer_2;
	private Combo cBasMaterial;
	private ComboViewer comboViewer_3;
	private TableViewer tableViewer;
	private Text tiroireCount;
	private TableComboViewer tableComboViewerCoteMaterial;
	private TableComboViewer tableComboViewerBasMaterial;
	private TableComboViewer tableComboViewerFacadeMaterial;
	private Spinner spntiroireInterFacade;
	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 */
	
	
	public TiroireCompositeWelcomePage(Composite parent, int style,TiroireCreator tCreator) {
		this(parent, style);
		settCreator(tCreator);
		if (this.tCreator != null) {
			m_bindingContext = initDataBindings();
		}
	}
	
	/**
	 * @return the tCreator
	 */
	public TiroireCreator gettCreator() {
		return tCreator;
	}

	/**
	 * @param tCreator the tCreator to set
	 */
	public void settCreator(TiroireCreator tCreator) {
		this.tCreator = tCreator;
	}

	public TiroireCompositeWelcomePage(Composite parent, int style) {
		super(parent, style);
		setLayout(new GridLayout(2, false));
		
		Label lblNbTiroitre = new Label(this, SWT.NONE);
		lblNbTiroitre.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNbTiroitre.setText("Nombre des tiroire");
		
		tiroireCount = new Text(this, SWT.BORDER);
		tiroireCount.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tiroireCount.addListener(SWT.Verify, new Listener() {
			public void handleEvent(Event e) {
	
			
				SwtTextFilter.ASINT(tiroireCount,2 ,e);
			
			}
		});
		Label lblTypeFacade = new Label(this, SWT.NONE);
		lblTypeFacade.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblTypeFacade.setText("Type de facade");
		
		comboViewer = new ComboViewer(this, SWT.READ_ONLY);
		CFacadeType = comboViewer.getCombo();
		CFacadeType.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
	
		comboViewer.setContentProvider((ArrayContentProvider.getInstance()));
		comboViewer.setInput(TiroireFacadeType.values());
		Label lblNewLabel_3 = new Label(this, SWT.NONE);
		GridData gd_lblNewLabel_3 = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_lblNewLabel_3.widthHint = 151;
		lblNewLabel_3.setLayoutData(gd_lblNewLabel_3);
		lblNewLabel_3.setText("Espacement entre Facade");
		
		spntiroireInterFacade = new Spinner(this, SWT.BORDER);
		spntiroireInterFacade.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spntiroireInterFacade.setMaximum(10000);
		lblNewLabel = new Label(this, SWT.NONE);
		lblNewLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel.setText("Matériaux de Facade  ");
		
//		comboViewer_1 = new ComboViewer(this, SWT.READ_ONLY);
//		cFacadeMaterial = comboViewer_1.getCombo();
//		cFacadeMaterial.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		//
		tableComboViewerFacadeMaterial = new TableComboViewer(this, SWT.READ_ONLY | SWT.BORDER);
		tableComboViewerFacadeMaterial.getTableCombo().setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableComboViewerFacadeMaterial.getTableCombo().setShowTableHeader(true);
		tableComboViewerFacadeMaterial.getTableCombo().defineColumns(new String[] { "Texture", "Epaisseur" });

		tableComboViewerFacadeMaterial.getTableCombo().setDisplayColumnIndex(0);
		tableComboViewerFacadeMaterial.getTableCombo().getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		// do not allow editable
		tableComboViewerFacadeMaterial.getTableCombo().setEditable(false);
		// set the content provider
		tableComboViewerFacadeMaterial.setContentProvider(ArrayContentProvider.getInstance());
		
		// set the label provider
		tableComboViewerFacadeMaterial.setLabelProvider(new SingleImageItemLabelProvider(this));

		// load the data
		tableComboViewerFacadeMaterial.setInput(modelProvider.getMateriallist());	

		//
		lblNewLabel_1 = new Label(this, SWT.NONE);
		lblNewLabel_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_1.setText("Matériaux des cote");
//		
//		comboViewer_2 = new ComboViewer(this, SWT.READ_ONLY);
//		cCoteMaterial = comboViewer_2.getCombo();
//		cCoteMaterial.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		tableComboViewerCoteMaterial = new TableComboViewer(this, SWT.READ_ONLY | SWT.BORDER);
		tableComboViewerCoteMaterial.getTableCombo().setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableComboViewerCoteMaterial.getTableCombo().setShowTableHeader(true);
		tableComboViewerCoteMaterial.getTableCombo().defineColumns(new String[] { "Texture", "Epaisseur" });

		tableComboViewerCoteMaterial.getTableCombo().setDisplayColumnIndex(0);
		tableComboViewerCoteMaterial.getTableCombo().getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		// do not allow editable
		tableComboViewerCoteMaterial.getTableCombo().setEditable(false);
		// set the content provider
		tableComboViewerCoteMaterial.setContentProvider(ArrayContentProvider.getInstance());
		
		// set the label provider
		tableComboViewerCoteMaterial.setLabelProvider(new SingleImageItemLabelProvider(this));

		// load the data
		tableComboViewerCoteMaterial.setInput(modelProvider.getMateriallist());	

		//
		
		lblNewLabel_2 = new Label(this, SWT.NONE);
		lblNewLabel_2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_2.setText("Matériaux de bas");
		
//		comboViewer_3 = new ComboViewer(this, SWT.READ_ONLY);
//		cBasMaterial = comboViewer_3.getCombo();
//		cBasMaterial.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		//
		tableComboViewerBasMaterial = new TableComboViewer(this, SWT.READ_ONLY | SWT.BORDER);
		tableComboViewerBasMaterial.getTableCombo().setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableComboViewerBasMaterial.getTableCombo().setShowTableHeader(true);
		tableComboViewerBasMaterial.getTableCombo().defineColumns(new String[] { "Texture", "Epaisseur" });

		tableComboViewerBasMaterial.getTableCombo().setDisplayColumnIndex(0);
		tableComboViewerBasMaterial.getTableCombo().getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		// do not allow editable
		tableComboViewerBasMaterial.getTableCombo().setEditable(false);
		// set the content provider
		tableComboViewerBasMaterial.setContentProvider(ArrayContentProvider.getInstance());
		
		// set the label provider
		tableComboViewerBasMaterial.setLabelProvider(new SingleImageItemLabelProvider(this));

		// load the data
		tableComboViewerBasMaterial.setInput(modelProvider.getMateriallist());	

		//
		
		btnREqualTiroire = new Button(this, SWT.RADIO);
		btnREqualTiroire.setText("Tiroire égaux");
		new Label(this, SWT.NONE);
		
		btnRDiffirentTiroire = new Button(this, SWT.RADIO);
		btnRDiffirentTiroire.setText("Tiroire Différent ");
		new Label(this, SWT.NONE);
		
		TableViewer tableViewer = new TableViewer(this, SWT.BORDER | SWT.FULL_SELECTION | SWT.MULTI);
		table = tableViewer.getTable();
		table.setLinesVisible(true);
		table.setHeaderVisible(true);
		table.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));
		if(tCreator!=null) {
			m_bindingContext = initDataBindings();
		}
		////
//		pcl = new PropertyChangeListener() {
//
//			@Override
//			public void propertyChange(PropertyChangeEvent evt) {
//
//				if (evt.getPropertyName() == "etagerecount") {
//					tCreator.getListDistance().clear();
//					for (int i = 0; i < tCreator.getTiroireCount(); i++) {
//						tCreator.getListDistance().add(new TirroirListDistances("Tirroir" + i,  100.0));
//					}		
//					tableViewer.refresh();
//					/**
//					 * ce method creer a pour résans à trigerer un virtuelle propertychange 
//					 * pour forcer tout listener a faire le calcul a nouveau 
//					 * 
//					 */
//					tCreator.trigerChangeCalculation();
//				}
//
//			}
//		};
//		tCreator.addPropertyChangeListener(pcl);
	}
	private void initTable()
	{
		setLayout(new GridLayout(1, false));
		tableViewer = new TableViewer(this, SWT.BORDER | SWT.FULL_SELECTION);
		tableViewer.setContentProvider(new TirroirlistContentProvider());
		tableViewer.setLabelProvider(new TirroirDistancesLabelProvider());
		tableViewer.setInput(this.tCreator.getListDistance());
		table = tableViewer.getTable();
		GridData gd_table = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		gd_table.widthHint = 235;
		table.setLayoutData(gd_table);
	    TableColumn tblClmn=   new TableColumn(table, SWT.CENTER);
	    tblClmn.setText(NAME);
	    tblClmn.setWidth(300);
	    TableColumn tblClmn1=  new TableColumn(table, SWT.CENTER);
	    tblClmn1.setText(Distance);
	    tblClmn1.setWidth(300);
		for (int i = 0, n = table.getColumnCount(); i < n; i++) {
			table.getColumn(i).pack();
		}

		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		tableViewer.refresh();

		CellEditor[] editors = new CellEditor[2];
		editors[0] = new TextCellEditor(table);
		editors[1] = new TextCellEditor(table);
		/**
		 * add a listener to the control of the editor with verify flag give us he ability to control it as a textfield 
		 */
	    editors[1].getControl().addListener(SWT.Verify, new Listener() {
			
			@Override
			public void handleEvent(Event event) {
				SwtTextFilter.ASDOUBLE(editors[1].getControl(), event);
				
			}
		});
	    //
		tableViewer.setColumnProperties(PROPS);
		tableViewer.setCellModifier(new TirroirlistCellModifier(tableViewer));
		tableViewer.setCellEditors(editors);
	
	}
	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeSelectionBtnREqualTiroireObserveWidget = WidgetProperties.widgetSelection().observe(btnREqualTiroire);
		IObservableValue facadeEgauxTCreatorObserveValue = BeanProperties.value("facadeEgaux").observe(tCreator);
		bindingContext.bindValue(observeSelectionBtnREqualTiroireObserveWidget, facadeEgauxTCreatorObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnRDiffirentTiroireObserveWidget = WidgetProperties.widgetSelection().observe(btnRDiffirentTiroire);
		IObservableValue facadeDiffirentTCreatorObserveValue = BeanProperties.value("facadeDiffirent").observe(tCreator);
		bindingContext.bindValue(observeSelectionBtnRDiffirentTiroireObserveWidget, facadeDiffirentTCreatorObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionComboViewer = ViewerProperties.singleSelection().observe(comboViewer);
		IObservableValue facadetypeTCreatorObserveValue = BeanProperties.value("facadetype").observe(tCreator);
		bindingContext.bindValue(observeSingleSelectionComboViewer, facadetypeTCreatorObserveValue, null, null);
		//
		IObservableValue observeSingleSelectiontTableComboViewerfacadeMaterial = ViewerProperties.singleSelection().observe(tableComboViewerFacadeMaterial);
		IObservableValue facadeMaterialTCreatorObserveValue = BeanProperties.value("facadeMaterial").observe(tCreator);
		bindingContext.bindValue(observeSingleSelectiontTableComboViewerfacadeMaterial, facadeMaterialTCreatorObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), null);
		//
		IObservableValue observeSingleSelectiontableComboViewercoteMaterial = ViewerProperties.singleSelection().observe(tableComboViewerCoteMaterial);
		IObservableValue coteMaterialTCreatorObserveValue = BeanProperties.value("coteMaterial").observe(tCreator);
		bindingContext.bindValue(observeSingleSelectiontableComboViewercoteMaterial, coteMaterialTCreatorObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), null);
		//
		IObservableValue observeSingleSelectiontableComboViewerbasMaterial = ViewerProperties.singleSelection().observe(tableComboViewerBasMaterial);
		IObservableValue basMaterialTCreatorObserveValue = BeanProperties.value("basMaterial").observe(tCreator);
		bindingContext.bindValue(observeSingleSelectiontableComboViewerbasMaterial, basMaterialTCreatorObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), null);
		//
		IObservableValue observeTextTiroireCountObserveWidget = WidgetProperties.text(SWT.Modify).observe(tiroireCount);
		IObservableValue tiroireCountTCreatorObserveValue = BeanProperties.value("tiroireCount").observe(tCreator);
		bindingContext.bindValue(observeTextTiroireCountObserveWidget, tiroireCountTCreatorObserveValue, null, null);
		//
		IObservableValue observeSelectionSpntiroireInterFacadeObserveWidget = WidgetProperties.widgetSelection().observe(spntiroireInterFacade);
		IObservableValue espaceInterFacadeTCreatorObserveValue = BeanProperties.value("espaceInterFacade").observe(tCreator);
		bindingContext.bindValue(observeSelectionSpntiroireInterFacadeObserveWidget, espaceInterFacadeTCreatorObserveValue, null, null);
		//
		return bindingContext;
	}
}
