package dressing.ui.exemples.tableaux;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import javax.inject.Inject;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

import dressing.model.Materiaux;
import dressing.model.ModelProvider;
import dressing.ui.exemples.tableaux.TableComboViewerSnippet1.SingleImageItemLabelProvider;


/**
 * Shows basic features of TableComboViewer
 *
 */
public class TableComboViewertextimage {
	@Inject 
	IEclipseContext eclipsecontext;
	@Inject
	private ESelectionService selectionService;
	
	private static Image testImage;
	private static Image test2Image;
	private static Image test3Image;
	private static List modelList;
	private static Text listenerResults;
	private static Group listenerGroup;
	private static ModelProvider modelProvider=new ModelProvider();
	/**
	 * @param args
	 */
	public static void main(String[] args) {

		// get display.
		Display display = new Display();

		// create a new shell.
		Shell shell = new Shell(display);
		shell.setText("TableComboViewer Snippet 1");
		shell.setSize(500, 400);
		shell.setLayout(new GridLayout());
		////////////////////////////////////////////////////////////////////////
		// Sample #1
		////////////////////////////////////////////////////////////////////////

		Label label = new Label(shell, SWT.NONE);

		label.setText("Single Column (With Images):");

		// create TableCombo
		TableComboViewer tcv = new TableComboViewer(shell, SWT.READ_ONLY | SWT.BORDER);
		tcv.getTableCombo().setLayoutData(new GridData(125, SWT.DEFAULT));
		modelList = loadModel();
		// set the content provider
		tcv.setContentProvider(ArrayContentProvider.getInstance());

		// set the label provider
		tcv.setLabelProvider(new SingleImageItemLabelProvider());


		// load the data
//		tcv.setInput(modelProvider.getMateriallist());
		tcv.setInput(modelList);
		// add listener
//		tcv.addSelectionChangedListener(new ItemSelected("Sample2"));
		// create group
		listenerGroup = new Group(shell, SWT.NONE);
		listenerGroup.setLayout(new GridLayout(1, false));
		listenerGroup.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false));
		listenerGroup.setText("Listener Results");

		listenerResults = new Text(listenerGroup, SWT.BORDER | SWT.MULTI);
		GridData gd = new GridData(SWT.FILL, SWT.DEFAULT, true, false);
		gd.heightHint = 30;
		listenerResults.setLayoutData(gd);
		shell.open();

		while (!shell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}

		display.dispose();
	}

	private static class SingleImageItemLabelProvider extends LabelProvider implements ITableLabelProvider {
		/**
		 * We return null, because we don't support images yet.
		 * 
		 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnImage(java.lang.Object,
		 *      int)
		 */
		@Inject 
		IEclipseContext eclipsecontext;
		public Image getColumnImage(Object element, int columnIndex) {

			Model item = (Model) element;

			if (columnIndex == 0) {
				
				testImage = ImageDescriptor.createFromFile(TableComboViewertextimage.class, 
						"ajout.png").createImage();
				return testImage;
//				try {
//					Bundle bundle = FrameworkUtil.getBundle(SingleImageItemLabelProvider.class);
//				URL url = FileLocator.find(bundle, new Path("ajout.png"), null);
//				ImageDescriptor descriptor = ImageDescriptor.createFromURL(url);
//				ResourceManager rsmanager = new LocalResourceManager(JFaceResources.getResources());
//				Image im = rsmanager.createImage(descriptor);
//				} catch (Exception |ExceptionInInitializerError e) {
//					// TODO: handle exception
//					System.out.println(e.getMessage());
//				}
//				
			}

			return null;
		}

		/**
		 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnText(java.lang.Object,
		 *      int)
		 */
		public String getColumnText(Object element, int columnIndex) {

			Model item = (Model) element;

			switch (columnIndex) {
			case 0:
				return item.getDescription();
			}
			return "";
		}
	}

	

//	private static class ItemSelected implements ISelectionChangedListener {
//
//		private String text;
//
//		public ItemSelected(String text) {
//			this.text = text;
//		}
//
//		public void selectionChanged(SelectionChangedEvent event) {
//			Materiaux model = (Materiaux) ((IStructuredSelection) event.getSelection()).getFirstElement();
//
//			listenerGroup.setText("Listener Results - (" + text + ")");
//			listenerResults.setText(model.toString());
//		}
//	}
	private static List loadModel() {
		List items = new ArrayList();
		items.add(new Model(1, "One"));
		items.add(new Model(2, "Two"));
		items.add(new Model(3, "Three"));
		items.add(new Model(4, "Four"));
		items.add(new Model(5, "Five"));
		items.add(new Model(6, "Six"));
		items.add(new Model(7, "Seven"));
		items.add(new Model(8, "Eight"));
		items.add(new Model(9, "Nine"));
		items.add(new Model(10, "Ten"));
		items.add(new Model(11, "Eleven"));
		items.add(new Model(12, "Twelve"));
		items.add(new Model(13, "Thirteen"));
		items.add(new Model(14, "Fourteen"));
		items.add(new Model(15, "Fiveteen"));
		items.add(new Model(16, "Sixteen"));
		items.add(new Model(17, "Seventeen"));
		items.add(new Model(18, "Eighteen"));
		items.add(new Model(19, "Nineteen"));
		items.add(new Model(20, "Twenty"));		
		
		return items;
	}	
	
}
