package dressing.ui.design.PublicParam;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import dressing.model.ModelProvider;
import dressing.ui.util.SingleImageItemLabelProvider;
import param.MechanicDesign;

public class MechanicDesignComposite extends Composite {
	private DataBindingContext m_bindingContext;
	private MechanicDesign design;
	private Text text;
	PublicParamGroupComposite params;
	private TableComboViewer tableComboViewer;
	private TableComboViewer tableComboViewer_1;
	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 */
	public MechanicDesignComposite(MechanicDesign design,Composite parent, int style) {
		super(parent, style|SWT.V_SCROLL);
		this.design = design;
		setLayout(new GridLayout(2, false));
		
		Label lblNom = new Label(this, SWT.NONE);
		lblNom.setLayoutData(new GridData(SWT.FILL, SWT.TOP, false, false, 1, 1));
		lblNom.setText("Nom");
		
		text = new Text(this, SWT.BORDER);
		text.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 1, 1));
		params=new PublicParamGroupComposite(design.getPublicparamgroup(),2,this, SWT.BORDER);
		params.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));
		if(design !=null) {
			m_bindingContext = initDataBindings();

		}
	}

	
	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeTextTextObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(text);
		IObservableValue nameDesignObserveValue = BeanProperties.value("name").observe(design);
		bindingContext.bindValue(observeTextTextObserveWidget, nameDesignObserveValue, null, null);
		//
		return bindingContext;
	}
}
