package dressing.ui.cuisine;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import dressing.controller.CuisineCreator;
import dressing.model.DesignException;
import dressing.model.evalutor.GeometricEngineException;

public class CuisineWizardPage extends WizardPage {

	CuisineCreator cuisine;
	PropertyChangeListener pcl;
	boolean errorfound=false;
	
	public CuisineCreator getCuisine() {
		return cuisine;
	}
	public void setCuisine(CuisineCreator cuisine) {
		this.cuisine = cuisine;
	}
	/**
	 * Create the wizard.
	 */

	
	public CuisineWizardPage(String pageName, CuisineCreator cuisine) {
		super(pageName);
		setTitle("Créer un nouveau cuisine");
		setDescription("Veuillez renseigner les propriétés de votre Cuisine ");
		setPageComplete(false);
		setCuisine(cuisine);
	}
	/**
	 * Create contents of the wizard.
	 * @param parent
	 */
	public void createControl(Composite parent) {
		CuisineWizardComposite container = new CuisineWizardComposite(parent, SWT.BORDER,cuisine);
	
		setControl(container);
		pcl = new PropertyChangeListener() {
			
			@Override
			public void propertyChange(PropertyChangeEvent evt) {
				// TODO Auto-generated method stub
				if(!evt.getPropertyName().startsWith("project.")) //seulemnt les proprietes de javabean
				{
					try {						
						cuisine.create();
						setErrorMessage(null);	
						errorfound = false;
						setMessage("Vous pouvez ajouter votre cuisine", WizardPage.INFORMATION);
					} catch (DesignException  | GeometricEngineException e) {
						setErrorMessage(e.getMessage());	
						errorfound = true;
					}
					getWizard().getContainer().updateButtons();
				}

			}
		};
		cuisine.addPropertyChangeListener(pcl);
	
	}

	@Override
	public boolean isPageComplete() {
		// TODO Auto-generated method stub
		boolean b = !errorfound;
		return b;
	}
	public void clearlistners() {
		cuisine.removePropertyChangeListener(pcl);
	}
}
