package dressing.model.cam;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import dressing.cam.model.PlanUsinage;
import dressing.cam.model.Tool;

public class HyperLayer {
	PlanUsinage plan=null;
	private Map<Tool,Layer> layers=new HashMap<Tool, Layer>();

	public HyperLayer() {
		super();
	}

	public Map<Tool, Layer> getLayers() {
		return layers;
	}

	public void setLayers(Map<Tool, Layer> layers) {
		this.layers = layers;
	}
	
	public Layer getLayer(Tool tool) {
		return layers.get(tool);
	}
	
	public void addLayer(Tool tool,Layer layer) {
		layers.put(tool, layer);
	}
	
	public boolean isToolExist(Tool tool) {
		return layers.containsKey(tool);
	}

	public PlanUsinage getPlan() {
		return plan;
	}

	public void setPlan(PlanUsinage plan) {
		this.plan = plan;
	}
	
}
