package dressing.handlers;

import javax.inject.Inject;

import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

import dressing.config.model.ModelpackageProvider;
import dressing.model.ModelPackageProjectParent;
import dressing.model.ModelProvider;
import dressing.model.Project3D;
import dressing.model.ProjectParent;
import dressing.ui.dressing.DressingWizard;
import dressing.ui.model.project3d.ModelPackageProject3DWizard;
import dressing.ui.project3d.Project3DWizard;

public class AddModelProjectWizardHandler {

	@Inject ESelectionService selectionService;
	
	@Inject
	IEclipseContext  eclipsecontext;
	@Execute
	public void execute(Shell shell,EPartService partService){
	
		
		ModelPackageProjectParent parent  = ModelpackageProvider.RootInstance();
		//Voire l element de l arbre selectionne
		if(parent!=null)
		{
			ModelPackageProject3DWizard projectwizard = ContextInjectionFactory.make(ModelPackageProject3DWizard.class,eclipsecontext);
			projectwizard.setRoot(parent);
			WizardDialog dialog = new WizardDialog(shell, projectwizard);
			dialog.open();		

		}
		else
		{
			MessageDialog.openError(shell, "Impossible d'ajouter un projet", "Espace de travail non intilialisée");
		}
	}
	@CanExecute
	public boolean check()
	{
		if(eclipsecontext!=null)
		{
			if( ModelpackageProvider.RootInstance()!=null)
			{
				return true;
			}
		}
		return false;
	}
}