package dressing.ui.library;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.inject.Inject;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

import dressing.config.model.ModelpackageProvider;
import dressing.model.ModelPackageProjectParent;
import dressing.ui.ModelPackageTreeContentProvider;
import dressing.ui.modelprovders.DimHLabelProvider;
import dressing.ui.modelprovders.DimLLabelProvider;
import dressing.ui.modelprovders.MaterialLabelProvider;
import dressing.ui.modelprovders.NameLabelProvider;

public class LibraryModelsTree extends Composite {
	@Inject 
	IEclipseContext eclipsecontext;
	TreeViewer treeViewer;
	ModelPackageProjectParent parentproject;
	private Text caissonName;
	 Tree tree;
	Listener listener =null;
	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 */
	public LibraryModelsTree(Composite parent, int style) {
		super(parent, style);
		 parentproject = ModelpackageProvider.RootInstance();
		setLayout(new FillLayout(SWT.HORIZONTAL));
		
		Composite composite = new Composite(this, SWT.NONE);
		composite.setLayout(new GridLayout(1, false));
		treeViewer = new TreeViewer(composite, SWT.BORDER|SWT.MULTI);
		tree = treeViewer.getTree();
		tree.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		
		ModelPackageProjectParent parentproject = ModelpackageProvider.RootInstance();
		treeViewer.setContentProvider(new ModelPackageTreeContentProvider());
		treeViewer.setInput(parentproject);	
		
		
		TreeViewerColumn viewerColumn = new TreeViewerColumn(treeViewer, SWT.NONE);
		TreeColumn column = viewerColumn.getColumn();
		column.setText("Nom");
		column.setWidth(200);
		viewerColumn.setLabelProvider(new DelegatingStyledCellLabelProvider(new NameLabelProvider()));


		viewerColumn = new TreeViewerColumn(treeViewer, SWT.NONE);
	    column = viewerColumn.getColumn();
		column.setText("Materieaux");
		column.setWidth(100);
		viewerColumn.setLabelProvider(new DelegatingStyledCellLabelProvider(new MaterialLabelProvider()));
		
		
		viewerColumn = new TreeViewerColumn(treeViewer, SWT.NONE);
	    column = viewerColumn.getColumn();
		column.setText("Longeur");
		column.setWidth(100);
		viewerColumn.setLabelProvider(new DelegatingStyledCellLabelProvider(new DimLLabelProvider()));
		
		viewerColumn = new TreeViewerColumn(treeViewer, SWT.NONE);
	    column = viewerColumn.getColumn();
		column.setText("Largeur");
		column.setWidth(100);
		viewerColumn.setLabelProvider(new DelegatingStyledCellLabelProvider(new DimHLabelProvider()));
		
		caissonName = new Text(composite, SWT.BORDER);
		caissonName.setLayoutData(new GridData(SWT.FILL, SWT.BOTTOM, true, false, 1, 1));
		
	
		
		listener = new Listener() {

			   @Override
			   public void handleEvent(Event event) {
			      TreeItem treeItem = (TreeItem) event.item;
			      
			      final TreeColumn[] treeColumns = treeItem.getParent().getColumns();
			      parent.getDisplay().asyncExec(new Runnable() {

			         @Override
			         public void run() {
			            for (TreeColumn treeColumn : treeColumns)
			                 treeColumn.pack();
			         }
			        
			      });
			   }
			};
		


		tree.addListener(SWT.Expand, listener);		
	}

	public void setCaissonName(String name) {
		caissonName.setText(name);		
	}
	public Text getCaissonNameTextField() {
		return caissonName;
	}
	public String getCaissonName() {
		return caissonName.getText();		
	}
	public void addSelectionListner(ISelectionChangedListener listener) {
		treeViewer.addSelectionChangedListener(listener);
	}
	public void removeSelectionListner(ISelectionChangedListener listener) {
		treeViewer.removeSelectionChangedListener(listener);
	}
	public IStructuredSelection getSelection() {
		  IStructuredSelection selection = (IStructuredSelection)treeViewer.getSelection();
		  return selection;
	}
	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}
	
	public void clearlistners() {
		treeViewer.getTree().removeListener(SWT.Expand, listener);
		tree.removeListener(SWT.Expand, listener);
	}
}
