package dressing.model.persistence.dpos;

import gdxapp.object3d.Wall;
import gdxapp.object3d.WorldObject;
import gdxapp.object3d.WorldObject.ObjectType;
import gdxapp.shaders.PbrMaterial;
import geometry.CompoundShape;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="Wall")
public class WallDPO extends Object3D implements DPO<Wall>{
	
	private CompoundShape perimeter;
	private float thickness;
	private float height;
	private PbrMaterial material;
	
	public WallDPO() {
		super();
	}
	
	public WallDPO(Wall wall) {
		super(wall);
		this.perimeter = wall.getPerimeter();
		this.thickness = wall.getThickness();
		this.height = wall.getHeight();
		this.material = wall.getMaterial();
	}

	@Override
	public Wall getWorldActor() {
		Wall wall = new Wall(this.height, this.thickness);
		CompoundShape perimeter = new CompoundShape();
		perimeter.setNodes(this.perimeter.getNodes());
		perimeter.setWorldTransform(this.perimeter.getWorldTransform());
		perimeter.calculateProperties();
		wall.setPerimeter(perimeter);
		wall.setMaterial(this.material);
		wall.setRealWorldDimension(this.dimension);
		wall.setRealWorldPosition(this.position);
		wall.setRotation(this.rotation);
		wall.setType(ObjectType.MODELED);
		wall.setStaticobject(this.staticObject);
		wall.setProperties(this.properties);
		return wall;
	}
	
	
	public void set(Wall wall) {
		setPerimeter(wall.getPerimeter());
		setThickness(wall.getThickness());
		setHeight(wall.getHeight());
		setMaterial(wall.getMaterial());
	}
	

	@Override
	public DPO<Wall> from(Wall entity) {
		WallDPO dpo = new WallDPO();
		super.from(entity, dpo);
		dpo.set(entity);
		return dpo;
	}

	@Override
	public Wall get() {
		Wall wall = new Wall(height, thickness);
		wall.setPerimeter(perimeter);
		wall.setMaterial(material);
		return wall;
	}
	
	
	

	public CompoundShape getPerimeter() {
		return perimeter;
	}

	public void setPerimeter(CompoundShape perimeter) {
		this.perimeter = perimeter;
	}

	public float getThickness() {
		return thickness;
	}

	public void setThickness(float thickness) {
		this.thickness = thickness;
	}

	public float getHeight() {
		return height;
	}

	public void setHeight(float height) {
		this.height = height;
	}

	public PbrMaterial getMaterial() {
		return material;
	}

	public void setMaterial(PbrMaterial material) {
		this.material = material;
	}


	
}
