package dressing.model.evalutor;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

public class Equation {
	private String key = "";
	private String expr = "";
	private String calculation = ""; //
	private String runexp = "";
	private double evaluation = 0.0;
	private boolean evaluated = false;
	public static final String CALCULATION_AUTO="auto";
	public static final String CALCULATION_MANUAL="manual";
	public static final String CALCULATION_FIRST_AUTO="firstauto";
	public Equation(String a, String b, String c) {
		super();
		key = a;
		expr = b;
		if(c ==null || c.isEmpty())
		{
			calculation = CALCULATION_AUTO;
		}
		else
		{
			calculation = c;
		}
		
		runexp = expr;
	}

	public String getKey() {
		return key;
	}

	public static Equation FIND_EQUATION(String depvar, ArrayList<Equation> debitage) {
		// TODO Auto-generated method stub
		if(depvar==null)
			return null;
		
		for (Equation t : debitage) {
			if (t.key.equals(depvar)) {
				return t;
			}
		}
		return null;
	}

	public void resolve(ScriptEngine engine, ArrayList<Equation> equations,ArrayList<String>   dependencystack) throws GeometricEngineException {
		// TODO Auto-generated method stub
		String lastdata=null;
		while (!this.isResolved()) {
//			System.out.println("Try to resolve " + this.getKey());
			// Chercher les dependences
			String mydata = this.getRunexp();
			if(lastdata!=null && lastdata.equals(mydata))
			{
				throw new GeometricEngineException(this.getKey()+" cannot be resolved with expression " +expr);
			}
			else
			{
				lastdata = mydata;
			}
			Pattern pattern = Pattern.compile("@\\w*\\.\\w*@");
			Matcher matcher = pattern.matcher(mydata);
			ArrayList<String> dependendvars = new ArrayList<>();
			while (matcher.find()) {
				// System.out.println(mydata+" Start At"+matcher.start());
				// System.out.println("Group : ---> "+mydata.substring(matcher.start(),
				// matcher.end()));
				dependendvars.add(mydata.substring(matcher.start(), matcher.end()));
			}

			for (String depvar : dependendvars) {
				if(dependencystack.contains(depvar))
				{
					throw new GeometricEngineException("Inifinite dependency loop "+depvar +
							" in equation "+key +" = " +expr);
				}
				else
				{
					dependencystack.add(depvar);
				}
//				System.out.println("Found depended key " + depvar);
				Equation tdepndend = Equation.FIND_EQUATION(depvar, equations);
				if(tdepndend==null)
				{
					throw new GeometricEngineException("Symbol not found "+depvar+" in equation "+key + " = " + expr);
				}
				if (tdepndend.isResolved()) {
//					System.out.println("Evaluating depended key " + depvar);
					this.filldependency(depvar, tdepndend.getEvaluation(engine));
				} else {
//					System.out.println("Resolving depended key " + depvar);

					tdepndend.resolve(engine, equations,dependencystack); // resoudre la variable dependante
					this.filldependency(depvar, tdepndend.getEvaluation(engine));
				}
				dependencystack.remove(depvar);
			}

		}
		this.evaluate(engine);
//		System.out.println(this.getKey() + " = " + this.getEvaluation(engine));
	}

	public boolean isResolved() {
		if (runexp.contains("@")) {
			return false;
		} else {
			return true;
		}
	}

	public void filldependency(String s, double value) {
		runexp = runexp.replaceAll(s, "" + value);
	}

	public void evaluate(ScriptEngine engine) throws GeometricEngineException {
		try {
			evaluation = new Double(engine.eval(runexp).toString());
			evaluated = true;
		} catch (ScriptException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw new GeometricEngineException("Evaluation expression " + expr + " par " + runexp + " is impossible");
		}
	}

	public Double getEvaluation(ScriptEngine engine) throws GeometricEngineException {
		if (engine == null)
			return evaluation;
		else if (evaluated) {
			return evaluation;
		} else {
			this.evaluate(engine);
			evaluated = true;
			return evaluation;
		}
	}

	public String getRunexp() {
		return runexp;
	}
	public void reset()
	{
		runexp = expr;
		evaluated =false;
	}
	public boolean isEvaluated() {
		return evaluated;
	}
	public String getExpr() {
		return expr;
	}
	public boolean isDependentTo(String key) {
		// TODO Auto-generated method stub
		if(expr.contains(key))
		{
			return true;
		}
		return false;
	}

	public void setEvaluation(double value) {
		// TODO Auto-generated method stub
		runexp=""+value;
		evaluated = true;
		evaluation=value;		
	}
	public void setExpr(String expr) {
		this.expr = expr;
		evaluated =false;
	}
	public void printEvaluation() {
		// TODO Auto-generated method stub
//		System.out.println(this.getKey() + " = " + this.evaluation);
	}
	
	@Override
	public String toString() {
		// TODO Auto-generated method stub
		return key + " : " + expr;
	}
	
	@Override
	protected void finalize() throws Throwable {
		// TODO Auto-generated method stub
		super.finalize();
	}
}