package dressing.model;

import dressing.model.evalutor.GeometricEngineException;
import dressing.cam.model.PlanUsinage;
import dressing.cam.model.Rotationangle;
import dressing.model.usinage.Usinage;

import com.badlogic.gdx.math.Vector3;

import dressing.cam.model.DXF_STATIC_VALUE;
import tech.frsdev.graphunit.PLineDXFEntity;
import tech.frsdev.graphunit.PointDXF;
import tech.frsdev.graphunit.PolyLineDXFEntity;

/**
 * @Bug 0001866: ajouter les support pour les caisson bas 
 *  {@link Cavity}  est le model Accessoire du support des caisson haut
 * @author Imed
 *
 */
public class Cavity extends Usinage {
			
	@Override
	public boolean canHold(DesignObject3D child) {
		return false;
	}
	
	@Override
	public boolean isdrawable() {
		return false;
	}

	@Override
	public Cavity clone() {

		Cavity support=new Cavity();
		try {
			support=(Cavity) this.copy(support);
		} catch (DesignException | GeometricEngineException | CloneNotSupportedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return support;
	}

	/**
	 * @author Imed 
	 * @Bug 0001710
	 * @param pl le plan de representation d'un piece2D
	 * @return retourne la longur de piece sur le plan spécifier
	 */	
	public double getWidth(PlanUsinage pl) {
		// TODO Auto-generated method stub
		float width = 0;
		float height = 0;
		switch (pl) {
		case FRONT:
			width = (float) this.getLongeurext();
			height = (float) this.getHauteurext();
			break;
		case BACK:
			width = (float) this.getLongeurext();
			height = (float) this.getHauteurext();
			break;

		case RIGHT:
			width = (float) this.getProfondeurext();
			height = (float) this.getHauteurext();
			break;
		case LEFT:
			width = (float) this.getProfondeurext();
			height = (float) this.getHauteurext();
			break;
		case DOWN:
			width = (float) this.getLongeurext();
			height = (float) this.getProfondeurext();
			break;
		case TOP:
			width = (float) this.getLongeurext();
			height = (float) this.getProfondeurext();
			break;
		default:
			break;
		}
		return width;
	}
	/**
	 * @author Imed 
	 * @Bug 0001710
	 * @param pl le plan de representation d'un piece2D
	 * @return retourne la hauteur de piece sur le plan spécifier
	 */	
	public double getHight(PlanUsinage pl) {
		// TODO Auto-generated method stub
		// TODO Auto-generated method stub
		float width = 0;
		float height = 0;
		switch (pl) {
		case FRONT:
			width = (float) this.getLongeurext();
			height = (float) this.getHauteurext();
			break;
		case BACK:
			width = (float) this.getLongeurext();
			height = (float) this.getHauteurext();
			break;

		case RIGHT:
			width = (float) this.getProfondeurext();
			height = (float) this.getHauteurext();
			break;
		case LEFT:
			width = (float) this.getProfondeurext();
			height = (float) this.getHauteurext();
			break;
		case DOWN:
			width = (float) this.getLongeurext();
			height = (float) this.getProfondeurext();
			break;
		case TOP:
			width = (float) this.getLongeurext();
			height = (float) this.getProfondeurext();
			break;
		default:
			break;
		}

		return height;
	}
	/**
	 * @author Imed 
	 * @Bug 0001710
	 * @param pl le plan de representation d'un piece2D
	 * @return retourne la dxf represente le rainure actuelle sur le plan spécifier
	 */	
	public String getDXFLineEntetity(PlanUsinage persp,Rotationangle anglerotation,Piece2D parentPiece) {
		float width = (float) this.getWidth(persp);
    	float height=(float) this.getHight(persp);
    	
 
    	String s="";
        PLineDXFEntity line1 = null;
        PLineDXFEntity line2 = null;
        PLineDXFEntity line3 = null;
        PLineDXFEntity line4 = null;
        PointDXF origin = getOrigin(persp,parentPiece);

        //ligne 1 
        PointDXF p1 = origin.getLocation();
        PointDXF p2 = p1.getLocation();
        p2.x += width;

        //ligne2
        PointDXF p3 = p2.getLocation();
        p3.y += height;

        //ligne 3 
        PointDXF p4 = p1.getLocation();
        p4.y += height;


        if (DXF_STATIC_VALUE.USE_POLYLINE == false) {
            line1 = new PLineDXFEntity(p1, p2);
            line2 = new PLineDXFEntity(p2, p3);
            line3 = new PLineDXFEntity(p1, p4);
            line4 = new PLineDXFEntity(p4, p3);

            //Create String seintity
            s += line1.getDXFLineEntetity();
            s += line2.getDXFLineEntetity();
            s += line3.getDXFLineEntetity();
            s += line4.getDXFLineEntetity();
        }
        else
        {
            PolyLineDXFEntity poly = new PolyLineDXFEntity(true);
            poly.addVertices(p1);
            poly.addVertices(p2);
            poly.addVertices(p3);
            poly.addVertices(p4);
            poly.addVertices(p1);
            s +=  poly.getDXFEntity(anglerotation);
        }
        return s;
	}
	/**
	 * @author Imed 
	 * @Bug 0001710
	 * @param pl le plan de representation d'un piece2D
	 * @return retourne la point d'origine de ce rainure sur le plan spécifier
	 */	
	public PointDXF getOrigin(PlanUsinage persp, Piece2D piece2d) {
				PointDXF centre = new PointDXF(0, 0); 
				float width = (float) piece2d.getWidth(persp);
				float height = (float) piece2d.getHight(persp);
				
				
				switch (persp) {
				case FRONT:
					centre.x = (float) getXpos();
					centre.y = (float) getYpos();
					break;
				case BACK:
					centre.x = (float) (width - getXpos() - getLongeurext());
					centre.y = (float) getYpos();
					break;

				case RIGHT:
					centre.x = (float) (width - getZpos() - getProfondeurext());
					centre.y = (float) getYpos();
					break;
				case LEFT:
					centre.x = (float) (getZpos());
					centre.y = (float) getYpos();
					break;
				case DOWN:
					centre.x = (float) getXpos();
					centre.y = (float) getZpos();
					break;
				case TOP:
					centre.x = (float) getXpos();
					centre.y = (float) (height - getZpos() - getProfondeurext());
					break;
				default:
					break;
				}
				return centre;
	}

	@Override
	public Vector3 getSize() {
		float x = (float) getLongeurext();
		float y = (float) getHauteurext();
		float z = (float) getProfondeurext();
		return new Vector3(x,y,z);
	}
	
	
	
}
